
##################################################################################################################################################################
class Title_Scene_02 < Init_Scene

begin

  def init
    Clear_Timer.reset
    SceneMove_Timer.reset
    
    init_panel
    init_variable
    init_image
    init_font_key(White)
    init_progress_bar(@clear_percentage)
    init_cursor("lib/image/pointer/keshigomu.png")
    init_end_animation

    init_gaze_data
    @plot_image = Images.new(0, 0, Clear, Window_w, Window_h)

    @bgm=Sound.new("lib/game/02_ImageBrowsing/sound/bgm.mid")

    @countdown = Images.new(0, 0, [0,0,0,0], 700, 200, "start", 200*$ratio_x)
    @countdown.x, @countdown.y = Window_w/2-@countdown.w/2, Window_h/2-@countdown.h/2
    @countdown.font_color(White)
    countdown
  end
  
  ##########################################@ϐ֘A@###################################################
  
  def init_variable
    @progress_percentage = 0
    @area_percentage = 0
    @clear_percentage = 90
    @flag_font_change = :off
    @start_flag = :off
    $date = Time.now.strftime("%Y/%m/%d %H:%M:%S") #N̎擾
    $date_file_name = $date.tr("/ :","._.")
    @time_out = $setup[3][1].to_i
  end
  
  ##########################################@摜֘A@###################################################
  
  def init_image
    @area_percentage_max = 0  # @area_percentage̍ől
    $pen_color=[0,0,0,0]
    $pen_size=65#*$ratio_y
    #p $pen_size
    @stop=0
    
    @bg = Images.new(0,0, Darkblue, Window_w, Window_h)
    
    @file_name = Dir.glob("lib/game/02_ImageBrowsing/image/*.jpg")
    @tmp_name = nil
    @image_name = Array.new

    for i in 0..@file_name.size-1
      @tmp_name = @file_name[i].tr("/",",")
      @tmp_name = @tmp_name.split(/,/)
      @image_name[i] = @tmp_name[@tmp_name.size-1]
    end
    
    @image_illustration = Images.new(0, 0, White, 70, 70)
    #@image_illustration.image("lib/game/02_摜{/image/#{rand(6)}.jpg")
    @image_illustration.image("lib/game/02_ImageBrowsing/image/#{@image_name[rand(@image_name.size-1)]}")
    @image_illustration.x, @image_illustration.y = Window_w/2-@image_illustration.w/2, Window_h/12
    
    @image_black = Images.new(0, 0, Black, @image_illustration.w/$ratio_x, @image_illustration.h/$ratio_y+5, "", 300, 1)
    #@image_black.x, @image_black.y = Window_w/2-@image_illustration.w/2, Window_h/12
    @image_black.x, @image_black.y = @image_illustration.x, @image_illustration.y

    @count_timer = Fonts.new("#{(@time_out - Clear_Timer.get).to_i}", Window_w-150*$ratio_x, 60*$ratio_y, 60*$ratio_x)
  end
  
  def update_image
    @image_black.pen_active($pen_color,$pen_size)
    for i in 0..9
      for j in 0..9
        if @image_black.get_color(@image_black.w/10*i,@image_black.h/10*j) == Clear
          @area_percentage += 1
        end
      end
    end
    update_progress_bar(@area_percentage)
    # oCu}p
    if @area_percentage > @area_percentage_max
      @area_percentage_max = @area_percentage
      @vibeman.vibration
    end

    @area_percentage = 0

    @count_timer.string = "#{(@time_out - Clear_Timer.get).to_i}"
  end
  
  def init_end_animation
    #XRA莞Ԉȓꍇ
    @great_flag = :off
      
    @hanabi1 = Images.new(0,0, Black, 10, 10)
    @hanabi1.image("lib/game/04_Oculogyric/image/hanabi.png")
    @hanabi1.x, @hanabi1.y = Window_w/2-@hanabi1.w, 0
    @hanabi2 = Images.new(0,0, Black, 10, 10)
    @hanabi2.image("lib/game/04_Oculogyric/image/hanabi.png")
    @hanabi2.x, @hanabi2.y = Window_w/2, Window_h/3
    
    @hanabi_sound = Sound.new("lib/game/04_Oculogyric/sound/hanabi.wav")
    @hanabi_sound.setVolume(255)
    
    @alpha1 = 255
    @alpha_count1 = 255
    @alpha2 = 255
    @alpha_count2 = 120
  end
  
  def update_anime
    @alpha_count1 -= 4
    @alpha1 = @alpha_count1%256
    if @alpha1 == 255
      @hanabi_sound.play
    end
    @alpha_count2 -= 4
    @alpha2 = @alpha_count2%256
    if @alpha2 == 252
      @hanabi_sound.play
    end
  end
  
  def render_image
    @bg.render
    @image_illustration.render
    @image_black.render
    if @great_flag == :on
      @hanabi1.alpha_render(@alpha1)
      @hanabi2.alpha_render(@alpha2)
    end
    @count_timer.render
  end
  
  ##########################################@JEg_E֘A@###################################################
  
  def countdown
    #@countdown.string("#{(3-SceneMove_Timer.get).to_i+1}",200*$ratio_x)
    @countdown.string_dispose
    @countdown.string_new("#{(3-SceneMove_Timer.get).to_i+1}",200*$ratio_x)
    @countdown.x, @countdown.y = Window_w/2-@countdown.w/2+(200*$ratio_x/2), Window_h/2-@countdown.h/2
      p("count_"+ "con")
  end

  def render_countdown
    @countdown.render
  end
  
  ##########################################@XRA֘A@###################################################
  
  def score
    before = $player_score[1][1]
    if before != "-"
      before.chop
      before = before.to_i
      if before > Clear_Timer.get.to_i
        tmp = before - Clear_Timer.get.to_i
        $panel_score.string_pos_2("#{tmp}b͂₭Ȃ܂",30*$ratio_x)
      elsif before < Clear_Timer.get.to_i
        tmp = Clear_Timer.get.to_i - before
        $panel_score.string_pos_2("#{tmp}bȂ܂",30*$ratio_x)
      end
    end
    
    $player_score[1][1] = "#{Clear_Timer.get.to_i}"+"b"
    #$panel_under_string.string("SCOREF#{$player_score[1][1]}",70*$ratio_x)
    $panel_score.string("SCOREF#{$player_score[1][1]}",50*$ratio_x)

    begin
      #SQ[̃XRA܂Ƃ߂Ăt@Cւ̏ _000.csv
      file_name = "player_data/#{$player_name[0][0]}/#{$player_name[0][0]}.csv"
      log_file = File::open(file_name, "a")
      log_file.puts"#{$date},,#{Clear_Timer.get},,,,,#{Clear_Timer.get}"
      log_file.close

      log_write(2, $player_score[1][1], Clear_Timer.get)
      init_log_plot

    rescue => e
      p e.message
    end
  end
  
  ##########################################@XV@##################################################
  def play_stop
    
    $gaze_data.shift
    #Ȍ
    file_name = "player_data/#{$player_name[0][0]}/#{$ran_array[1][0]}/#{$date_file_name}_GazeData.csv"
    log_file = File::open(file_name, "w")
    #log_file.puts"摜, 𑜓x_x, 𑜓x_y, ͎ID, ͎Җ, {, ̃f[^, NA"
    log_file.puts"#{$date_file_name}_GazeData.png,#{Window_w},#{Window_h},#{$player_name[0][0]},#{$player_name[0][1]},#{$date},#{$gaze_data.size},f"
    #log_file.puts", xW, yW"
    for i in 0..$gaze_data.size-1
      log_file.puts"#{$gaze_data[i][0]},#{$gaze_data[i][1]},#{$gaze_data[i][2]}"
    end
    Window.getScreenShot("player_data/#{$player_name[0][0]}/#{$ran_array[1][0]}/#{$date_file_name}_GazeData.png")
  end

  def update
    
    key_pushed
    update_cursor
    
    if @start_flag == :off
      countdown
      if SceneMove_Timer.get > 4
        @start_flag = :on
        @bgm.play
        Clear_Timer.reset
        init_gaze_data
      end
    elsif @start_flag == :on
      if @flag_end == :off
        if Input.keyPush?(K_T) or Input.keyPush?(K_H) or Input.keyPush?(K_E)
          play_stop
        end
        update_image
        update_gaze_data
      elsif @flag_end == :on
        update_cursor
        update_anime
        btn_end(Title_Scene_02)
        if @flag_font_change == :off
          @flag_font_change = :on
          score
          @bgm.stop
          init_log_plot
        end
      end

      if @flag_font_change == :on
        init_font_key(Black)
        init_cursor("lib/image/pointer/finger.png")
        @flag_font_change = :finish
        if Clear_Timer.get < 50
          @great_flag = :on
        end
        if @great_flag == :on
          @bgm=Sound.new("lib/game/02_ImageBrowsing/sound/bgm_ed_great.mid")
        else
          @bgm=Sound.new("lib/game/02_ImageBrowsing/sound/bgm_ed.mid")
        end
        @bgm.play
      end

      # ^CAEg
      if @time_out - Clear_Timer.get < 0
        @flag_end = :on
      end
  end
end
  ##########################################@`揈@###################################################

  def render
    render_image
    render_progress_bar
    render_font_key

    if @flag_end == :on
      render_plot
      render_end_frame
      render_cursor
    end
    
    if @start_flag == :off
      render_countdown
    end
    render_cursor

  end
  
rescue
end
  
end
##################################################################################################################################################################
class End_Scene_02 < Init_Scene

  def init
    $date = Time.now.strftime("%Y/%m/%d_%H:%M.%S") #N̎擾
    Input.mouseEnable=true
    @bg = Images.new(0,0, Black, 1024, 768)
  end
  
  def update
    btn_game
  end

  def render
    @bg.render
  end
  
end
#######################################################################################################################################################
#Scene.main_loop  Title_Scene
