
##################################################################################################################################################################
class Title_Scene_11 < Init_Scene

  begin
    def init
      init_font_key(Black)
      init_piano_key
      init_cursor("lib/image/pointer/dot_red.png")
      @back_img = Images.new(0, 0, Black, 1920 * $ratio_x, 1080 * $ratio_y)
      @back_img.image("lib/game/11_Piano2/image/back.png")
      init_piano_cursor
    end

    def init_piano_key
      @ratio_r = Math.sqrt($ratio_x * $ratio_x + $ratio_y * $ratio_y)
      @piano_key = Array.new()
      @key_objects = Array.new()
      @sounds = Array.new()
      musical_scale = ["h", "", "~", "t@", "\\ ", "", "V", "h"]#["\", "", "V", "h", "", "~", "t@", "\", "", "V", "h", "", "~"]
      @can_play = true
      piano_key_r = 90 * @ratio_r
      for i in 0..7
        x, y = piano_key_pos(250 * @ratio_r, 45 * i)
        @piano_key[i] = CircleSprite.new(x - piano_key_r, y - piano_key_r, piano_key_r, Darkgray, musical_scale[i], 70, White)
        @piano_key[i].reduce_collision_r(20 * @ratio_r)
        @key_objects[i] = @piano_key[i].sprite_obj
        @sounds[i] = Sound.new("lib/game/11_Piano2/sound/piano_#{i + 1}.wav")
      end
    end

    def init_piano_cursor
      @cursor_piano = CircleSprite.new(300, 400, 20, Blue)
      @center_circle = CircleSprite.new(Window_w / 2 - 100, Window_h / 2 - 100, 100, Green)
      @center_circle.sprite_obj.collision_enable = false
      @img_cursor = Image.load("lib/image/pointer/stick.png")
      @img_cursor_hit = Image.load("lib/image/pointer/stick_hit.png")
      @cursor_piano.sprite_obj.image = @img_cursor
      @hit_img = Images.new(-300, -300, White)
      @hit_img.image("lib/game/11_Piano2/image/hit.png")
    end

    def piano_key_pos(r, angle)
      angle = angle - 90
      x = Window_w / r/2 * Math.cos(Math::PI * angle / 180)
      y = Window_h / r/2 * Math.sin(Math::PI * angle / 180)
      return x, y
    end

    def piano_key_update
      for i in 0..@key_objects.size - 1
        if @cursor_piano.hit?(@piano_key[i].sprite_obj)
          @piano_key[i].color(Red)
          if @can_play
            @sounds[i].play
            @vibeman.vibration
            @cursor_piano.sprite_obj.image = @img_cursor_hit
            @hit_img.set_pos(@piano_key[i].x + 79 - 40 * @ratio_r, @piano_key[i].y  - 60)
            @can_play = false
          end
        end
      end

      if !@can_play
        if @cursor_piano.sprite_obj.check(@key_objects) == []
          for i in 0..@key_objects.size - 1
            @piano_key[i].color(Darkgray)
          end
          @can_play = true
          @hit_img.set_pos(-300, -300)
          @cursor_piano.sprite_obj.image = @img_cursor
        end
      end
    end


    def piano_cursor_update
      @cursor_piano.pos(Input.mouse_pos_x - 10, Input.mouse_pos_y - 10)
    end

    def update
      key_pushed
      piano_cursor_update
      update_cursor
      piano_key_update
      if $btn_back.pushed?($mouse_use)
        @vibeman.vibration
        self.next_scene = Home_Scene
      end
    end

    def piano_key_render
      for i in 0..@piano_key.size - 1
        @piano_key[i].render
      end
      @center_circle.render
    end

    def piano_cursor_render
      @hit_img.render
      @cursor_piano.render
    end

    def render
      @back_img.render
      render_font_key
      piano_key_render
      $btn_back.render
      piano_cursor_render
    end

  rescue
  end

end
#######################################################################################################################################################
#Scene.main_loop  Title_Scene
