
class Title_Scene_08 < Init_Scene

  def init
    init_cursor("lib/image/pointer/finger.png")
    init_font_key(Black)
    $btn_start.x, $btn_start.y = Window_w/2-$btn_start.w/2, Window_h-Window_h/5.5
    
    make_save_data
    
    init_image
    init_character
    make_mode_btn
    $date = Time.now.strftime("%Y/%m/%d %H:%M:%S") #N̎擾
    $date_file_name = $date.tr("/ :","._.")
    make_dir
    
    @bgm = Sound.new("lib/game/08_CharacterInput/sound/bgm_title.mid")
    @bgm.play
    @bgm_select = Sound.new("lib/game/08_CharacterInput/sound/select.wav")
    $english_key_mode = false
  end
  
  def make_dir
    if FileTest.exist?("player_data/#{$player_name[0][0]}/08_CharacterInput/#{$date_file_name}") == false
      Dir::mkdir("player_data/#{$player_name[0][0]}/08_CharacterInput/#{$date_file_name}")
    end
  end
  
  def make_save_data
    if FileTest.exist?("player_data/#{$player_name[0][0]}/08_CharacterInput") == false
      Dir::mkdir("player_data/#{$player_name[0][0]}/08_CharacterInput")
    end
    if FileTest.exist?("player_data/#{$player_name[0][0]}/08_CharacterInput/save_data.txt") == false
      level = ["Bx",0]
      file_name = "player_data/#{$player_name[0][0]}/08_CharacterInput/save_data.txt"
      $log_file = File::open(file_name, "w")
      $log_file.puts"#{level[0]},#{level[1]}"
      $log_file.close
    end
  end

  def make_mode_btn
    @btn_kana = Button.new(0, 0, "", 40*$ratio_x, 250*$ratio_x, 120*$ratio_y, White, [220,220,220], [70,70,70], Black)
    @btn_kana.set_pos(Window_w/5-@btn_kana.w-50*$ratio_x, 50*$ratio_y)
    @btn_kana.color(Yellow)
    @btn_english = Button.new(0, 0, "p", 40*$ratio_x, 250*$ratio_x, 120*$ratio_y, White, [220,220,220], [70,70,70], Black)
    @btn_english.set_pos(Window_w/5+50*$ratio_x, 50*$ratio_y)
  end

  def update_mode_btn
    if @btn_kana.pushed?($mouse_use)
      @btn_kana.color(Yellow)
      @btn_english.color(White)
      $english_key_mode = false
    elsif @btn_english.pushed?($mouse_use)
      @btn_english.color(Yellow)
      @btn_kana.color(White)
      $english_key_mode = true
    end
  end

  def render_mode_btn
    @btn_kana.render
    @btn_english.render
  end
  
  ##########################################@摜֘A@###################################################
  
  def init_image
    @bg = Images.new(0,0, Black, 10, 10)
    @bg.image("lib/game/08_CharacterInput/image/bg.jpg")
    
    @title_banner = Images.new(0,0, Black, 10, 10)
    @title_banner.image("lib/image/plate/plate_title.png")
    @title_banner.x = Window_w/2-@title_banner.w/2
    
    @title = Image_string.new(@title_banner.x, @title_banner.y, Clear, @title_banner.w, @title_banner.h, "LN^[I", 60*$ratio_x, White)
  end
  
  def render_image
    @bg.render
    @title_banner.render
    @title.render
  end
  
  ##########################################@LN^[֘A@###################################################
  
  def init_character
    @save_data = load_datafile("player_data/#{$player_name[0][0]}/08_CharacterInput/save_data.txt")
    $chara_open = @save_data[0][1].to_i
    @character = Array.new
    @character_bg =Array.new
    for i in 0..9
      @character[i] = Button.new(0, 0, " ", 25, 10, 10)
      if i <= $chara_open
        @character[i].image=("lib/game/08_CharacterInput/image/character/#{i}.png")
      else
        @character[i].image=("lib/game/08_CharacterInput/image/character/#{i}_b.png")
      end
      @character[i].waku_thickness(Black, 3)
      @character[i].set_pos( Window_w/2-(@character[i].w*5)/2+@character[i].w*(i%5), Window_h/5 + @character[i].h*(i/5) )
      @character_bg[i] = Images.new(0,0, White, @character[i].w/$ratio_x, @character[i].h/$ratio_x)
      @character_bg[i].x, @character_bg[i].y = @character[i].x, @character[i].y
    end
    @character_select = Images.new(0,0, Yellow, @character[0].w/$ratio_x, @character[0].h/$ratio_x)
    $select_character = nil
    @select_flag = :off
  end
  
  def update_character
    for i in 0..$chara_open.to_i
      if @character[i].pushed?($mouse_use)
        @bgm_select.play
        @select_flag = :on
        #@character[$select_character].waku_thickness(Black, 3) if $select_character != nil
        #@character[i].waku_thickness(Red, 3)
        @character_select.x, @character_select.y = @character[i].x, @character[i].y
        $select_character = i
      end
    end
  end
  
  def render_character
    for i in 0..9
      @character_bg[i].render
      @character[i].render
    end
    if @select_flag == :on
      @character_select.alpha_render(150)
    end
  end
  
  ##########################################@XV@###################################################
  
  def update
    update_cursor
    key_pushed
    update_character
    update_mode_btn
    if @select_flag == :on
      if $btn_start.pushed?($mouse_use)
        @bgm.stop
        self.next_scene = Game_Scene_08
      end
    end
  end
  
  ##########################################@`揈@###################################################
  
  def render
    render_image
    render_mode_btn
    $btn_start.render
    render_character
    render_font_key
    render_cursor
  end
  
end


class Game_Scene_08 < Init_Scene

  def init
    init_repeat
    init_question
    init_sound
    init_image
    make_question_image
    init_font_key(Black)
    init_progress_bar(10)
    init_cursor("lib/image/pointer/dot_red.png")
    init_keyboard

    init_gaze_data
    @end_flag = :off
    $chara_open_flag = :off
    $clear_time = 0
    $date = Time.now.strftime("%Y/%m/%d %H:%M:%S") #N̎擾
    S_Timer.reset
    
  end
  
  ##########################################@O֘A@###################################################
  
  def log_data_write
    date_file_name = $date.tr("/ :","._.")
    
    $gaze_data.shift

    begin
      #Ȍ
      file_name = "player_data/#{$player_name[0][0]}/08_CharacterInput/#{$date_file_name}/#{date_file_name}_GazeData.csv"
      log_file = File::open(file_name, "w")
      #log_file.puts"摜, 𑜓x_x, 𑜓x_y, ͎ID, ͎Җ, {, ̃f[^, NA"
      log_file.puts"#{$date_file_name}_GazeData.png,#{Window_w},#{Window_h},#{$player_name[0][0]},#{$player_name[0][1]},#{$date},#{$gaze_data.size},#{S_Timer.get}"
      #log_file.puts", xW, yW"
      for i in 0..$gaze_data.size-1
        log_file.puts"#{$gaze_data[i][0]},#{$gaze_data[i][1]},#{$gaze_data[i][2]}"
      end
      Window.getScreenShot("player_data/#{$player_name[0][0]}/08_CharacterInput/#{$date_file_name}/#{date_file_name}_GazeData.png")

    rescue => e
      p e.message
    end
  end
  
  ##########################################@TEh֘A@###################################################
  
  def init_sound
    @bgm = Sound.new("lib/game/08_CharacterInput/sound/bgm_#{@question_count}.mid")
    @bgm.play
    @player_attack = Sound.new("lib/game/08_CharacterInput/sound/player_attack.wav")
    @enemy_attack = Sound.new("lib/game/08_CharacterInput/sound/enemy_attack.wav")
  end
  
  def update_sound
    @bgm.stop
    @bgm = Sound.new("lib/game/08_CharacterInput/sound/bgm_#{@question_count}.mid")
    @bgm.play
  end
  
  ##########################################@Q[JԂ񐔁@###################################################
  
  def init_repeat
    @repeat_count = 3
    @shot_count = 0
  end
    
  ##########################################@֘A@###################################################
  
  def init_question
    if $english_key_mode
      @question = load_datafile("lib/game/08_CharacterInput/question_english.txt")
    else
      @question = load_datafile("lib/game/08_CharacterInput/question.txt")
    end
    @question_count  = 0
    rand = rand(@question[@question_count].size)
    @question_string = @question[@question_count][rand].split("")
  end
  
  def make_question_image
    @question_image  = Array.new
    w = ((@enemy.x - (@player.x + @player.w))-100*$ratio_x) / 5#@question_string.size
    h = w
    for i in 0..@question_string.size-1
      @question_image[i] = Image_string.new( 0, 0, White, w, h )
      @question_image[i].x, @question_image[i].y = Window_w/2-(@question_image[i].w*@question_string.size)/2+@question_image[i].w*i, 100*$ratio_y
      @question_image[i].waku(Black)
      @question_image[i].string( "#{@question_string[i]}", 100*$ratio_x )
    end
    @question_image[0].color(DarkCream)
  end
  
  def update_question
    rand = rand(@question[@question_count].size)
    @question_string = @question[@question_count][rand].split("")
    make_question_image
  end
  
  def render_question
    for i in 0..@question_string.size-1
      @question_image[i].render
    end
  end
  
  ##########################################@摜֘A@###################################################
  
  def init_image
    @bg = Images.new(0,0, Black, 10, 10)
    @bg.image("lib/game/08_CharacterInput/image/bg.jpg")
    
    @clear_bg = Images.new(0,0, Black, 10, 10)
    @clear_bg.image("lib/game/08_CharacterInput/image/clear_moji.png")
    
    init_play_chara
    init_enemy
  end
  
  
  def init_play_chara
    @player = Images.new(100*$ratio_x,150*$ratio_y, Black, 10, 10)
    @player.image("lib/game/08_CharacterInput/image/character/#{$select_character}.png")
    player_life
  end
  
  def player_life
    @player_life = 3
    @player_life_image = Array.new
    for i in 0..@player_life-1
      @player_life_image[i] = Images.new(0,100*$ratio_y, Black, 10, 10)
      @player_life_image[i].image("lib/game/08_CharacterInput/image/heart_0.png")
      @player_life_image[i].x = @player.x + @player.w/2 - (@player_life_image[i].w * @player_life) / 2 + @player_life_image[i].w * i
    end
  end
  
  def init_enemy
    @enemy = Images.new(0,150*$ratio_y, Black, 10, 10)
    @enemy.image("lib/game/08_CharacterInput/image/1_#{@question_count}.png")
    @enemy.x = Window_w-400*$ratio_x
    enemy_life
    
    @moji_clear_flag = :off
    @clear_image_rendercount = 0
  end
  
  def enemy_life
    @enemy_life = @question_string.size #+ @question_count/3
    @enemy_life_image = Array.new
    for i in 0..@enemy_life-1
      @enemy_life_image[i] = Images.new(0,100*$ratio_y, Black, 10, 10)
      @enemy_life_image[i].image("lib/game/08_CharacterInput/image/heart_0.png")
      @enemy_life_image[i].x = @enemy.x + @enemy.w/2 - (@enemy_life_image[i].w * @enemy_life) / 2 + @enemy_life_image[i].w * i
    end
  end
  
  def render_image
    @bg.render
    for i in 0..@player_life-1
      @player_life_image[i].render
    end
    for i in 0..@enemy_life-1
      @enemy_life_image[i].render
    end
    @enemy.render
    @player.render
  end
  
  ##########################################@L[{[h֘A@###################################################
  
  def init_keyboard
    @input_count  = 0
    @anime_count  = 0
    @miss_count   = @player_life-1
    @input_flag   = :off
    @input_string = ""
    
    @kana = ["","","","","","","","","","","","","","","","","","","","",
             "","","","","","","","","","","","","","","","","","",
             "","","","","","","","","","","","",
             "","","","","","","","","","","","","","","","","","","","",
             "","","","",""]
    @eng = ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P",
            "A", "S", "D", "F", "G", "H", "J", "K", "I",
            "Z", "X", "C", "V", "B", "N", "M"]
    @keyboard = Array.new
    @keyboard_string = Array.new
    #@keyboard_string_ArrayɖŎgǉ
    @keyboard_string_Array = @question_string.dup
    @number = 10
    
    #L[{[h̕Io
    until(@keyboard_string_Array.size == @number)
      if $english_key_mode
        @keyboard_string_Array.push(@eng.choice)
      else
        @keyboard_string_Array.push(@kana.choice)
      end
      @keyboard_string_Array = @keyboard_string_Array.uniq
    end
    
    #L[{[hŎgVbt
    @keyboard_string_Array = @keyboard_string_Array.shuffle
    
    #L[{[h̐
    key_w = 250*$ratio_x-20*$ratio_x*$select_character
    ker_h = key_w
    for i in 0..@number-1
      @keyboard[i] = Button.new(0, 0, " ", 25, key_w, ker_h, White, [220,220,220], [70,70,70], Black)
      @keyboard[i].x, @keyboard[i].y = Window_w/2-@keyboard[i].w*(@number/2)/2 + @keyboard[i].w*(i%(@number/2)), Window_h/2+@keyboard[i].h*(i/(@number/2))#Window_h-@keyboard[i].h*2-100+@keyboard[i].h*(i/(@number/2))
      @keyboard_string[i] = Button_string.new(@keyboard[i].x, @keyboard[i].y, Clear, @keyboard[i].w, @keyboard[i].h, "#{@keyboard_string_Array[i]}", 80*$ratio_x, Black)
    end
  end
  
  #L[{[h̓͏
  def update_keyboard
    if @input_flag == :off
      for i in 0..@number-1
        if @keyboard_string[i].pushed?($mouse_use)
          @input_string = @keyboard_string_Array[i]
          @input_flag = :on
        end
      end
    elsif @input_flag == :on
      #͂ꍇ
      if @question_string[@input_count] == @input_string
        #̐Fς
        @question_image[@input_count].color(Gray)
        @question_image[@input_count].waku_thick(Red)
        if @input_count > 0  # GrayœhԂ
          @question_image[@input_count].box_fill(0, 5, 4, @question_image[0].h - 5, Gray)
        end
        if @input_count < @question_image.size - 1  # ݂̖
          @question_image[@input_count + 1].color(DarkCream)
        end
        @question_image[@input_count].string( "#{@question_string[@input_count]}", 100*$ratio_x )
        @vibeman.vibration
        #G̃Ct炷
        @player_attack.play
        #@enemy_life_image[@input_count].image("lib/game/08_/image/brokenheart.png")
        @enemy_life_image[@input_count].image("lib/game/08_CharacterInput/image/heart_1.png")
    
        @input_count += 1
      #͂Ⴄꍇ
      else 
        @enemy_attack.play
        @player_life_image[@miss_count].image("lib/game/08_CharacterInput/image/heart_1.png")
        if @miss_count == 0
          $chara_open_flag = :lose
          
          $date = Time.now.strftime("%Y/%m/%d %H:%M:%S") #N̎擾
          log_data_write
          @bgm.stop
          self.next_scene = End_Scene_08
        end
        @miss_count -= 1
      end
      #ׂĂ͂̕ǂ  
      if @input_count != @question_string.size
        @input_flag = :off
      else
        @input_flag = :judge
        @moji_clear_flag = :on
      end
    elsif @input_flag == :judge
      if @moji_clear_flag == :on
        @clear_image_rendercount += 1
        if @clear_image_rendercount == 150
          @moji_clear_flag = :next
        end
      elsif @moji_clear_flag == :next
        if @question_count != @question.size-1
          $date = Time.now.strftime("%Y/%m/%d %H:%M:%S") #N̎擾
          log_data_write
          @question_count += 1
          update_sound
          update_question
          init_keyboard
          init_enemy
          S_Timer.reset
        else
          if $chara_open != 9
            if $select_character == $chara_open
              $chara_open += 1
              $chara_open_flag = :on
            else
              $chara_open_flag = :win
            end
          end
          
          $date = Time.now.strftime("%Y/%m/%d %H:%M:%S") #N̎擾
          log_data_write
          @bgm.stop
          self.next_scene = End_Scene_08
        end
      end
    end
  end
  
  def render_keyboard
    for i in 0..@number-1
      @keyboard[i].render
      @keyboard_string[i].render
    end
  end
  
  ##########################################@XV֘A@###################################################
  
  def update
    if Input.keyPush?(K_T) or Input.keyPush?(K_H) or Input.keyPush?(K_E)
      log_data_write
    end
    key_pushed
    update_gaze_data
    update_cursor
    if @end_flag == :off
      update_keyboard
    else
      #End_Scene
    end
  end

  ##########################################@`֘A@###################################################
  
  def render
    render_image
    render_keyboard
    render_question
    #render_progress_bar
    if @moji_clear_flag == :on
      @clear_bg.render
    end
    render_font_key
    render_cursor
  end
  
end
##################################################################################################################################################################
class End_Scene_08 < Init_Scene

  def init
    init_image
    init_cursor("lib/image/pointer/finger.png")
    init_font_key(Black)
    
    if $chara_open_flag == :on
      data_save
    end
  end
  
  def data_save
    level = ["Bx",$chara_open]
    file_name = "player_data/#{$player_name[0][0]}/08_CharacterInput/save_data.txt"
    $log_file = File::open(file_name, "w")
    $log_file.puts"#{level[0]},#{level[1]}"
    $log_file.close
    
    @new_character = Button.new(0, 0, " ", 25, 10, 10)
    @new_character.image=("lib/game/08_CharacterInput/image/character/#{$chara_open}.png")
    @new_character.set_pos( Window_w/2-@new_character.w/2, Window_h/2-@new_character.h/2 )
    
    #@title = Image_string.new(0, 0, Clear, Window_w, 200, "VLN^[!!", 60*$ratio_x, Red)
  end
  
  ##########################################@摜֘A@###################################################
  
  def init_image
    init_cursor("lib/image/pointer/finger.png")
    @bg = Images.new(0,0, Black, 10, 10)
    @bg.image("lib/game/08_CharacterInput/image/bg.jpg")
    @bg_2 = Images.new(0,0, Black, 10, 10)
    if $chara_open_flag == :win
      @bg_2.image("lib/game/08_CharacterInput/image/win_bg.png")
      @bgm = Sound.new("lib/game/08_CharacterInput/sound/bgm_end_1.mid")
      @bgm.play
    elsif $chara_open_flag == :lose
      @bg_2.image("lib/game/08_CharacterInput/image/lose_bg.png")
      @bgm = Sound.new("lib/game/08_CharacterInput/sound/bgm_end_2.mid")
      @bgm.play
    else
      @bg_2.image("lib/game/08_CharacterInput/image/new_bg.jpg")
      sound = Sound.new("lib/game/08_CharacterInput/sound/open.wav")
      sound.play
      @bgm = Sound.new("lib/game/08_CharacterInput/sound/bgm_end_0.mid")
      @bgm.play
    end
  end
  
  def render_image
    @bg.render
    @bg_2.render
  end
  
  ##########################################@O֘A@###################################################
  
  def score
  end
  
  ##########################################@XV֘A@###################################################
  
  def update
    key_pushed
    update_cursor
    btn_end(Title_Scene_08)
    if $btn_start.pushed?($mouse_use)
      $bgm.stop if $bgm
      @bgm.stop if @bgm
      if $chara_open != 9 and $chara_open_flag == :on
        $select_character += 1
      end
      self.next_scene = Game_Scene_08
    end
  end
  
  ##########################################@`֘A@###################################################
  
  def render
    render_image
    #render_end_frame
    if $chara_open_flag == :on
      #@title.render
      @new_character.render
    end
    $btn_back.render
    $btn_once.render
    $btn_start.render
    render_font_key
    render_cursor
  end
  
end
