# scene???W???[????????????
# ??{?f?[?^???L
require 'dxruby'
require 'lib/source/vibeman.rb'
require 'lib/source/EyeMoT_mouse.rb'
require 'lib/source/language.rb'
require 'lib/source/EnviromentSend'

module Scene
  class Exit
  end

  class Base
    attr_accessor :next_scene
    attr_reader :frame_counter

    def initialize
      @next_scene = nil
      @frame_counter = 0
      @vibeman = VibeMan.new  # ?o?C?u?}????????
      @EyeMoT_mouse = EyeMoT_Mouse.new
      @enviromentsend = EnvSend.new
      @lang = Language.new  # ????N???X??????
      init
    end

    def __update
      @frame_counter += 1
      update
    end
    private :__update

    def init
    end

    def quit
      #GC.RUby_GC
    end

    def update
    end

    def render
    end
  end

  def self.main_loop(scene_class, fps = 60, step = 1)
    scene = scene_class.new
    default_step = step

    Window.loop do
      #exit if Input.keyPush?(K_ESCAPE)
      if Input.keyPush?(K_PGDN)
        step += 1
        Window.fps = fps * default_step / step
      end

      if Input.keyPush?(K_PGUP) and step > default_step
        step -= 1
        Window.fps = fps * default_step / step
      end

      step.times do
        break if scene.next_scene
        scene.__send__ :__update
      end

      scene.render

      if scene.next_scene
        scene.quit
        break if Exit == scene.next_scene
        scene = scene.next_scene.new
      end
    end
  end
end
#####################################################################
class Init_Scene  < Scene::Base
  
  ##########################################?@???????@###################################################
  
  def init_panel #?g????
    $panel_under = Images.new(0, 0, Black, 10, 10)
    $panel_under.image("lib/image/panel/panel_under.png")
    $panel_under.x, $panel_under.y = 0, Window_h-$panel_under.h
    $panel_under_string = Image_string.new(0, Window_h-$panel_under.h, Clear, $panel_under.w, $panel_under.h, "", 36)
    
    $panel_score = Images.new(0, 0, White, 500, 150)
    #$panel_score.waku(Red)
    $panel_score.image("lib/image/panel/panel_score.png")
    $panel_score.x, $panel_score.y = Window_w/2-$panel_score.w/2, Window_h/2-$panel_score.h/2
    $panel_score_string = Image_string.new(Window_w/2-$panel_score.w/2, Window_h/2-$panel_score.h/2, Clear, $panel_score.w, $panel_score.h, "", 36)
  end
  
  def init_btn #?{?^??????
    $btn_start = Button.new(0, 0, "",36,10,10)
    $btn_start.image=("lib/image/button/btn_start.png")
    $btn_start.x, $btn_start.y = Window_w/2-$btn_start.w/2, Window_h-Window_h/5.5
    #$btn_start_string = Button_string.new(Window_w/2-$btn_start.w/2, Window_h-Window_h/6.2, Clear, $btn_start.w, $btn_start.h, "??????", 36*$ratio_x, White)
    
    $btn_esc = Button.new(0, 0, "", 25,110,70)
    $btn_esc.image=("lib/image/button/btn_end.png")
    $btn_esc.x, $btn_esc.y = Window_w-$btn_esc.w, 0
    #$btn_esc_string = Button_string.new(Window_w-$btn_esc.w, 0, Clear, $btn_esc.w, $btn_esc.h, "?I??", 25*$ratio_x, White)
    
    $btn_back = Button.new(0, 0, "",25,110,70)
    $btn_back.image=("lib/image/button/btn_back.png")
    $btn_back.x, $btn_back.y = 0, 0
    #$btn_back_string = Button_string.new(0, 0, Clear, $btn_back.w, $btn_back.h, "???",25*$ratio_x, White)
    
    $btn_once = Button.new(0, 0, "",36,162,112)
    $btn_once.image=("lib/image/button/btn_re.png")
    $btn_once.x, $btn_once.y = Window_w-$btn_once.w, 0
    #$btn_once_string = Button_string.new(Window_w/2-$btn_once.w/2, Window_h-Window_h/6.2, Clear, $btn_once.w, $btn_once.h, "?????P??",36*$ratio_x, White)
    
    #$btn_credit = Button.new(0, 0, "",36,162,112)
    #$btn_credit.image=("lib/image/button/btn_image.png")
    #$btn_credit.x, $btn_credit.y = Window_w-$btn_credit.w, Window_h-Window_h/6.2
    #$btn_credit_string = Button_string.new(Window_w/4*3, Window_h-Window_h/6.2, Clear, $btn_credit.w, $btn_credit.h, "?N???W?b?g", 36*$ratio_x, White)
    
    $btn_setup = Button.new(0, 0, "",36,10,10)
    $btn_setup.image=("lib/image/button/btn_setup.png")
    $btn_setup.x, $btn_setup.y = Window_w - $btn_setup.w*1.25, Window_h-Window_h/5.5
    #$btn_setup_string = Button_string.new(Window_w/6-$btn_setup.w/2, Window_h-Window_h/6.2, Clear, $btn_setup.w, $btn_setup.h, "???", 36*$ratio_x, White)
    
  end

  def init_version #?o?[?W?????????L??
    @font9 = Fonts.new("Ver.20220910",0+50*$ratio_x,Window_h-70*$ratio_y,50*$ratio_x,Black)
  end


  def init_frame
    init_panel
    init_btn
    init_version
    @vibeman.init_vibeman
  end

  ##########################################?@?e??{?^????????@###################################################

  def btn_esc_eye_pushed #?I???{?^?????????????????
    if $btn_esc.pushed?($mouse_use)
      @vibeman.vibration
      sleep(0.2)
      @vibeman.close
      sleep(0.2)
      if $setup[0][1].to_i != 2
        begin
          #Process.kill('KILL', $cmd.pid)
          @EyeMoT_mouse.close
        rescue
        end
      end
      exit
    end
  end

  def btn_end(scene) #?e?Q?[?????????e??{?^???????
    if $btn_back.pushed?($mouse_use)
      @vibeman.vibration
      @bgm.stop if @bgm
      $bgm.stop if $bgm
      self.next_scene = Home_Scene
    elsif $btn_once.pushed?($mouse_use)
      @vibeman.vibration
      @bgm.stop if @bgm
      $bgm.stop if $bgm
      self.next_scene = scene
    end
  end


  def render_title_frame #Title_Scene???????`????
    $panel_under.render
    $btn_esc.render
    #$btn_esc_string.render
    $btn_start.render
    #$btn_start_string.render
    #$btn_credit_string.render
    $btn_setup.render
    #$btn_setup_string.render
    @font9.render # ?o?[?W???????
    @vibeman.vibeman_render
  end

  def render_credit_frame #Credit_Scene???????`????
    $btn_back.render
    #$btn_back_string.render
  end

  def render_home_frame
    $panel_under.render
    $panel_under_string.render
    $btn_esc.render
    #$btn_esc_string.render
    $btn_back.render
    #$btn_back_string.render
  end

  def render_end_frame
    #$panel_under.render
    #$panel_under_string.render
    $panel_score.render
    #$panel_score_string.render
    $btn_back.render
    #$btn_back_string.render
    $btn_once.render
    #$btn_once_string.render
  end
  
  def show(strText,intSecondsToWait,strTitle,intType = VbOKOnly + VbInformation )
    Input.mouseEnable=true
    Window.windowed = true
    wsh = WIN32OLE.new('WScript.Shell')
    yes_no = wsh.Popup('Are you sure you quit?', 0, 'message', 4 + 32 + 0x40000)
    case yes_no
      when 6
        exit
      when 7
        Input.mouseEnable=false
        Window.windowed = false
    end # case yes_no
  end

  def key_pushed #?B???L?[????
    if Input.keyPush?(K_T)
      if $setup[0][1].to_i != 2
        #Process.kill('KILL', $cmd.pid)
        @EyeMoT_mouse.close
      end
      @bgm.stop if @bgm
      $bgm.stop if $bgm
      self.next_scene = Title_Scene
    elsif Input.keyPush?(K_ESCAPE)
      @bgm.stop if @bgm
      $bgm.stop if $bgm
      self.next_scene = Home_Scene
    elsif Input.keyPush?(K_E)
      sleep(0.2)
      @vibeman.close
      sleep(0.2)
      if $setup[0][1].to_i != 2
        begin
          @EyeMoT_mouse.close
          #Process.kill('KILL', $cmd.pid)
        rescue
        end
      end
      exit
    elsif Input.keyPush?(K_P)
      Window.getScreenShot("#{Time.now.instance_eval { '%s.%1d' % [strftime('%Y.%m.%d_%H.%M.%S'), (usec / 100000).round] }}.png")
    elsif Input.keyPush?(K_X)
      if $is_using_gaze_mouse
        #$cmd.puts"mouse_off\n"
        @EyeMoT_mouse.eye_off
        $is_using_gaze_mouse = false
      else
        #$cmd.puts"mouse_on\n"
        @EyeMoT_mouse.eye_on
        $is_using_gaze_mouse = true
      end
    end
  end

  ##########################################?@?????????@###################################################

  def init_font_key(color, num_color=[0,0,0,0])
    @fonot_num = Fonts.new("FQ[I", Window_w/1.27, Window_h/1.29, 35*$ratio_x, num_color)
    @font_title = Fonts.new("TF^Cgɖ߂",Window_w/1.27,Window_h/1.24,35*$ratio_x, color)
    @font_home = Fonts.new("EscFQ[Iʂɖ߂",Window_w/1.27,Window_h/1.19,35*$ratio_x, color)
    @font_mouse = Fonts.new("XF}EXOFF/ON",Window_w/1.27,Window_h/1.14,35*$ratio_x, color)
    @font_end = Fonts.new("EFQ[I",Window_w/1.27,Window_h/1.09,35*$ratio_x, color)
    @font_screen = Fonts.new("PFXN[Vbg", Window_w/1.27, Window_h/1.05, 35*$ratio_x, color)
  end

  def render_font_key
    @fonot_num.render
    @font_title.render
    @font_home.render
    @font_mouse.render
    @font_end.render
    @font_screen.render
  end
  
  ##########################################?@?}?E?X?J?[?\????f?U?C???@###################################################
  
  def init_cursor(filename)
    Input.mouseEnable=false
    @mouse_cursor = Images.new(0,0, Black, 10, 10)
    @mouse_cursor.image(filename)
    @x_cursor = Images.new(0,0, Black, 10, 10)
    @x_cursor.image("./lib/image/pointer/x_mark.png")
    if $is_using_gaze_mouse
      @cursor = @mouse_cursor
    else
      @cursor = @x_cursor
    end
    $eye_x = 0
    $eye_y = 0
  end
  
  def update_cursor_title
    $eye_x = Input.mousePosX
    $eye_y = Input.mousePosY
    @cursor.x = $eye_x-(@cursor.w/$ratio_x)/2
    @cursor.y = $eye_y#-(@cursor.h/$ratio_x)/2
  end
  
  def update_cursor
    Input.mouseEnable=false
    if $params == nil
      $eye_x = Input.mousePosX
      $eye_y = Input.mousePosY
      if $is_using_gaze_mouse
        @cursor = @mouse_cursor
      else
        @cursor = @x_cursor
      end
      @cursor.x = $eye_x-(@cursor.w/$ratio_x)/2
      @cursor.y = $eye_y-(@cursor.h/$ratio_x)/2
    else
      @eye_x = Input.mousePosX
      @eye_y = Input.mousePosY
      if $is_using_gaze_mouse
        @cursor = @mouse_cursor
      else
        @cursor = @x_cursor
      end
      #?z???O???t?B?????l????????
      $eye_x = (@eye_x*$params[0] + @eye_y*$params[1] + $params[2]) / (@eye_x*$params[6] + @eye_y*$params[7] + 1)
      $eye_y = (@eye_x*$params[3] + @eye_y*$params[4] + $params[5]) / (@eye_x*$params[6] + @eye_y*$params[7] + 1)
      @cursor.x = $eye_x-(@cursor.w/$ratio_x)/2
      @cursor.y = $eye_y-(@cursor.h/$ratio_x)/2
    end
  end
  
  def render_cursor
    @cursor.mouse_image_render
  end

  ##########################################?@???O??A?@###################################################
  def init_gaze_data
    $gaze_data = Array.new
    Play_Timer.reset
  end

  def update_gaze_data
    # # time = "#{Time.now.sec}"+"."+"#{Time.now.usec}"
    $gaze_data.push([Play_Timer.get,$eye_x,$eye_y])
  end

  def log_write(game_number, score, clear_time)
    if game_number < 7
      game_name = $ran_array[game_number-1][0]
    else
      game_name = $ran_secret_array[game_number-7][0]
    end

    Window.getScreenShot("player_data/#{$player_name[0][0]}/#{game_name}/#{$date_file_name}_GazeData.png")
    
    file_name = "player_data/#{$player_name[0][0]}/#{$player_name[0][0]}_LatestScore.txt"
    log_file = File::open(file_name, "w")
    log_file.puts"????????,?????????,????????,????????,??]????,???????m???????"
    log_file.puts"#{$player_score[1][0]},#{$player_score[1][1]},#{$player_score[1][2]},#{$player_score[1][3]},#{$player_score[1][4]},#{$player_score[1][5]}"
    log_file.close

    file_name = "player_data/#{$player_name[0][0]}/#{game_name}/#{$date_file_name}_GazeData.csv"
    log_file = File::open(file_name, "w")
    #log_file.puts"??, ??x_x, ??x_y, ?????ID, ??????, ???{????, ??????f?[?^??, ?N???A????"
    log_file.puts"#{$date_file_name}_GazeData.png,#{Window_w},#{Window_h},#{$player_name[0][0]},#{$player_name[0][1]},#{$date},#{$gaze_data.size},#{clear_time}"
    #log_file.puts"????, x???W, y???W"
    for i in 0..$gaze_data.size-1
      log_file.puts"#{$gaze_data[i][0]},#{$gaze_data[i][1]},#{$gaze_data[i][2]}"
    end
    log_file.close
  end

  def init_log_plot
    @plot_image = Images.new(0, 0, Clear, Window_w/$ratio_x, Window_h/$ratio_y)
    $gaze_data.shift
    for i in 0..$gaze_data.size-1
      if i == 0
        @plot_image.circlefill($gaze_data[i][1], $gaze_data[0][2], 17, Red)
        @plot_image.circle($gaze_data[i][1], $gaze_data[0][2], 17, Black)
      elsif i == $gaze_data.size-1
        @plot_image.circlefill($gaze_data[i][1], $gaze_data[i][2], 17, Blue)
        @plot_image.circle($gaze_data[i][1], $gaze_data[i][2], 17, Black)
      else
        @plot_image.circlefill($gaze_data[i][1], $gaze_data[i][2], 10, White)
        @plot_image.circle($gaze_data[i][1], $gaze_data[i][2], 10, Black)
      end
      if i > 0
        @plot_image.line($gaze_data[i-1][1], $gaze_data[i-1][2], $gaze_data[i][1], $gaze_data[i][2], White)
      end
    end
    @plot_image.circlefill($gaze_data[0][1], $gaze_data[0][2], 17, Red)
    @plot_image.circle($gaze_data[0][1], $gaze_data[0][2], 17, Black)
  end

  def render_plot
    @plot_image.render
  end

  ##########################################?@?\?P?b?g??M????EyeX??f?[?^??@###################################################
  # def eyex_start
  #   cmd = 'lib/EyeX_data/MinimalGazeDataStream'
  #   Thread.new( cmd ){ system cmd; }
  #   $host = 'localhost'
  #   $port = '9999'
  #   $sock = TCPSocket.open($host, $port)
  #   $gaze_data = nil
  # end
  
  def init_gaze
    @eye_x = nil
    @eye_y = nil
    @temp_x = 0
    @temp_y = 0
    @array_gaze_ave = Array.new #?????????????????f?[?^???i?[????z??
    @array_temp_gaze = Array.new #?????????????????f?[?^???i?[???????z??
  end
  
  def gaze_ave_update(average,mouse) # average:??????? mouse:?}?E?X?A????L??
    $gaze_data = $sock.gets.chop.split(/,/)
    eye_x = $gaze_data[0].to_i #Input.mousePosX
    eye_y = $gaze_data[1].to_i #Input.mousePosY
    
    @array_gaze_ave.push([eye_x,eye_y])
    if @array_gaze_ave.size == average
      for i in 0..@array_gaze_ave.size-1
        @temp_x += @array_gaze_ave[i][0]
        @temp_y += @array_gaze_ave[i][1]
      end
      @eye_x = @temp_x/average
      @eye_y = @temp_y/average
      @temp_x = 0
      @temp_y = 0
      @array_gaze_ave = Array.new
      
      #?}?E?X?A????L??
      if mouse == :on
        Input.setMousePos( @eye_x,@eye_y )
      elsif mouse == :off
        Input.mouseEnable = true
      end
      
      #????????
      @scorp.x = @eye_x-@scorp.w/2 if @scorp
      @scorp.y = @eye_y-@scorp.h/2 if @scorp 
    end
  end
  
  ##########################################?@?t?@?C?????????@###################################################
  
  def load_datafile(filename)
    array = []
    open(filename) do |file|
      while l = file.gets
         #array.push l.chomp.split(//s)
         array.push l.chomp.split(",")
      end
    end
    return array
  end
  
  def load_datafile1(filename)
    array = []
    open(filename) do |file|
      while l = file.gets
         array.push l.chomp.split(//s)
      end
    end
    return array
  end
  
  def nm_array (n,m)
    (0..n).map {Array.new(m)}
  end
  
  ##########################################?@?v???O???X?o?[?@###################################################
  
  def init_progress_bar(parameter) #()????I??????
    @bar_gray = Images.new(Window_w/2-253,20, Dgray, 506, 30)
    @bar_gray.x, @bar_gray.y = Window_w/2-@bar_gray.w/2, 30
    @bar_green = Images.new(Window_w/2-250,23, Green, 500, 24)
    @bar_green.x, @bar_green.y = Window_w/2-@bar_green.w/2, 33
    @exit_condition = parameter
    @percentage = 0
    @flag_end = :off
  end
  
  def update_progress_bar(exit_condition) #)()????I??????????????B??????A????
    if @flag_end == :off
      @percentage = (100-(exit_condition*100)/@exit_condition).to_i
      a = [exit_condition,@exit_condition,exit_condition/@exit_condition]
      if @percentage > 0 
        @bar_green.width(500*$ratio_x*@percentage/100.to_i)
      elsif @percentage == 0 
        @bar_green = nil
        @bgm.stop if @bgm
        @flag_end = :on
      end
    end
  end
  
  def render_progress_bar
    #@bar_gray.scale_render($ratio_x,$ratio_y)
    @bar_gray.render
    if @bar_green != nil
      #@bar_green.scale_render($ratio_x,$ratio_y)
      @bar_green.render
    end
  end
  
end
#################################################################
class S_Timer
  def self.reset  #???????????
    @start_time = Time.now
  end

  def self.get  #?o???????
    return Time.now - @start_time
  end 
end

class Interval_Timer
  def self.reset  #???????????
    @start_time = Time.now
  end

  def self.get  #?o???????
    return Time.now - @start_time
  end 
end

class Clear_Timer
  def self.reset  #???????????
    @start_time = Time.now
  end

  def self.get  #?o???????
    return Time.now - @start_time
  end 
end

class SceneMove_Timer
  def self.reset  #???????????
    @start_time = Time.now
  end

  def self.get  #?o???????
    return Time.now - @start_time
  end 
end

class Animation_Timer
  def self.reset  #???????????
    @start_time = Time.now
  end

  def self.get  #?o???????
    return Time.now - @start_time
  end 
  
  def self.restart(time)
    @start_time = Time.now-time
    return Time.now - @start_time
  end
end

class Play_Timer
  def self.reset  #???????????
    @start_time = Time.now
  end

  def self.get  #?o???????
    return Time.now - @start_time
  end
end

class Shot_Timer
  def self.reset  #???????????
    @start_time = Time.now
  end

  def self.get  #?o???????
    return Time.now - @start_time
  end
end

class Calib_Timer
  def self.reset  #???????????
    @start_time = Time.now
  end

  def self.get  #?o???????
    return Time.now - @start_time
  end
end
##################################################################
