require 'dxruby'

class CircleSprite
  attr_accessor :sprite_obj, :x, :y, :is_shining, :is_hitting
  def initialize(x, y, r=20,  color=[130, 130, 130], string="", font_size=36, st_color=[255, 255, 255])
    @x, @y = x, y
    @r = r
    @string = string
    @color = color
    @st_color = st_color
    @font_size = font_size
    @image = Image.new(@r*2, @r*2).circle_fill(@r, @r, @r, @color)
    @font = Font.new(font_size, "MSPSVbN")
    @sprite_obj = Sprite.new(@x, @y, @image)
    @sprite_obj.collision = [@r, @r, @r]
    @sprite_obj.collision_sync = false
    @is_shining = false  # Ă鎞̔
    @is_hitting = false  # Ă鎞̔
  end

  def pos(x, y)
    @sprite_obj.x, @sprite_obj.y = x, y
  end

  def reduce_collision_r(r)
    @sprite_obj.collision = [@r, @r, @r - r]
  end

  def color(color)
    @image.circle_fill(@r, @r, @r, color)
  end

  def hit?(obj)
    return @sprite_obj === obj
  end

  def render
    @sprite_obj.draw
    font_x = @x + @r - @font.getWidth(@string) / 2
    font_y = @y + @r - @font_size / 2
    Window.drawFont(font_x, font_y, @string, @font, :color => @st_color)
  end

end