class Timer
  def initialize
    @start_time = Time.now
  end

  def reset
    @start_time = Time.now
  end

  def get
    return Time.now - @start_time
  end
end
##################################################################################################################################################################
class Title_Scene_10 < Init_Scene

begin
  def init
    init_font_key(Black)
    init_piano_key
    init_cursor("lib/image/pointer/dot_red.png")
    @back_img = Images.new(0, 0, Black, 1920 * $ratio_x, 1080 * $ratio_y)
    @back_img.image("lib/game/10_Perform/image/back.png")
    make_dir
    init_piano_cursor
    init_musical_score
    init_gaze_data
    @miss_count = 0
    @game_end_flag = false
    @game_start_flag = true
    @game_timer = Timer.new()
  end

  def init_piano_key
    @ratio_r = Math.sqrt($ratio_x * $ratio_x + $ratio_y * $ratio_y)
    @piano_key = Array.new()
    @key_objects = Array.new()
    @sounds = Array.new()
    musical_scale = ["h", "", "~", "t@", "\\ ", "", "V", "h"]
    @can_play = true
    piano_key_r = 90 * @ratio_r
    for i in 0..7
      x, y = piano_key_pos(250 * @ratio_r, 45 * i)
      @piano_key[i] = CircleSprite.new(x - piano_key_r, y - piano_key_r, piano_key_r, Darkgray, musical_scale[i], 70, White)
      @piano_key[i].reduce_collision_r(20 * @ratio_r)
      @key_objects[i] = @piano_key[i].sprite_obj
      @sounds[i] = Sound.new("lib/game/10_Perform/sound/piano_#{i + 1}.wav")
    end
  end

  def init_piano_cursor
    @cursor_piano = CircleSprite.new(300, 400, 20, Blue)
    @center_circle = CircleSprite.new(Window_w / 2 - 100, Window_h / 2 - 100, 100, Green)
    @center_circle.sprite_obj.collision_enable = false
    @img_cursor = Image.load("lib/image/pointer/stick.png")
    @img_cursor_hit = Image.load("lib/image/pointer/stick_hit.png")
    @cursor_piano.sprite_obj.image = @img_cursor
    @hit_img = Images.new(-300, -300, White)
    @hit_img.image("lib/game/10_Perform/image/hit.png")
  end

  def init_musical_score
    song = load_datafile("./musical_score/musical_score.csv")
    scale_list = ["c", "d", "e", "f", "g", "a", "b", "hic"]
    @musical_score_counter = 0
    @musical_score = Array.new()
    @musical_score_time_list = Array.new()
    for scale in song
      for i in 0..scale_list.size - 1
        if scale[0] == scale_list[i]
          @musical_score.push(i)
        end
      end
      @musical_score_time_list.push(scale[1].to_f)
    end
    @musical_score_timer = Timer.new()
  end

  def piano_key_pos(r, angle)
    angle = angle - 90
    x = Window_w / 2 + r * Math.cos(Math::PI * angle / 180)
    y = Window_h / 2 + r * Math.sin(Math::PI * angle / 180)
    return x, y
  end

  def make_dir
    if FileTest.exist?("player_data/#{$player_name[0][0]}/10_Perform/#{$date_file_name}") == false
      Dir::mkdir("player_data/#{$player_name[0][0]}/10_Perform/#{$date_file_name}")
    end
  end

  def piano_key_update
    if @musical_score_timer.get > @musical_score_time_list[@musical_score_counter]  # w莞ԈȏłΌ
      @piano_key[@musical_score[@musical_score_counter]].color(Yellow)
      @piano_key[@musical_score[@musical_score_counter]].is_shining = true  # Ă邩ǂ肷tO
    end

    for i in 0..@key_objects.size - 1
      if @cursor_piano.hit?(@piano_key[i].sprite_obj)
        # L[Ă鎞ɉΐ
        if @musical_score_timer.get > @musical_score_time_list[@musical_score_counter]
          if @musical_score[@musical_score_counter] == i  # ̏ꍇ
            correct_piano_key_hit(i)
          else  # s̏ꍇ
            if !@piano_key[i].is_hitting
              @miss_count += 1
              @piano_key[i].is_hitting = true
            end
          end
        end
      end
    end
    piano_key_out
  end

  def piano_key_out
    if @cursor_piano.sprite_obj.check(@key_objects) == []  # tO
      for i in 0..@key_objects.size - 1
        @piano_key[i].is_hitting = false
      end
    end

    if !@can_play  # Ȃ
      if @cursor_piano.sprite_obj.check(@key_objects) == []  # ՂOꂽ
        for i in 0..@key_objects.size - 1
          if !@piano_key[i].is_shining
            @piano_key[i].color(Darkgray)
          end
        end
        @can_play = true
        @hit_img.set_pos(-300, -300)  # hit_imgʊOɔ΂
        @cursor_piano.sprite_obj.image = @img_cursor
      end
    end
  end

  def correct_piano_key_hit(key_number)
    @piano_key[key_number].is_hitting = true
    @piano_key[key_number].color(Red)
    if @can_play
      @sounds[key_number].play
      @vibeman.vibration
      @cursor_piano.sprite_obj.image = @img_cursor_hit
      @hit_img.set_pos(@piano_key[key_number].x + 79 - 40 * @ratio_r, @piano_key[key_number].y  - 60)
      @can_play = false
      @musical_score_timer.reset
    end
    @piano_key[@musical_score[@musical_score_counter]].is_shining = false
    if @musical_score.size - 1 > @musical_score_counter  # y̏I
      @musical_score_counter += 1
    else
      @game_end_flag = true
    end
  end

  def piano_cursor_update
    @cursor_piano.pos($eye_x - 10, $eye_y - 10)
  end

  def game_end_init
    init_panel
    $panel_score.string("~X񐔁F#{@miss_count}", 50 * $ratio_x)
    init_cursor("lib/image/pointer/finger.png")
    @bgm = Sound.new("lib/game/10_Perform/sound/bgm_ed.mid")
    @bgm.play
    for obj in @piano_key
      obj.sprite_obj.collision_enable = false
    end
    log_write(10, @miss_count, @game_timer.get)
    init_log_plot
  end

  def update
    key_pushed
    piano_cursor_update
    update_cursor
    piano_key_update
    if @game_end_flag
      if @game_start_flag
        game_end_init
        @game_start_flag = false
      end
      btn_end(Title_Scene_10)
    else
      if $btn_back.pushed?($mouse_use)
        @vibeman.vibration
        self.next_scene = Home_Scene
      end
      update_gaze_data
    end
  end

  def piano_key_render
    for i in 0..@piano_key.size - 1
      @piano_key[i].render
    end
    @center_circle.render
  end

  def piano_cursor_render
    @hit_img.render
    @cursor_piano.render
  end

  def game_end_render
    render_plot
    render_end_frame
    render_cursor
  end

  def render
    @back_img.render
    render_font_key
    piano_key_render
    if @game_end_flag
      game_end_render
    else
      $btn_back.render
      piano_cursor_render
    end
  end
  
rescue
end
  
end
#######################################################################################################################################################
#Scene.main_loop  Title_Scene
