#! ruby -Ks
# -*- mode:ruby; coding:shift_jis -*-
$KCODE = "s"
require "jcode"

# `FbN{bNXNX

require "dxruby"


class CheckBox

  attr_accessor :x, :y, :id, :name, :target, :z, :is_hoverable, :is_enable, :is_auto_clicked, :is_checked
  attr_reader :width, :height

  def initialize(x, y, id=0, size=20, mark_image="", mark_color=C_BLACK, inner_color=C_WHITE, frame_color=C_BLACK, option={})
    option = {:id=>0, :name=>"check_box", :frame_width=>2, :z=>0, :target=>Window,
              :is_hoverable=>true, :is_enable=>true}.merge(option)

    @target = option[:target]
    @x = x
    @y = y
    @z = option[:z]
    @width = size
    @height = size
    @name = option[:name]
    @id = id
    @frame_width = option[:frame_width]
    @is_hoverable = option[:is_hoverable]
    @is_enable = option[:is_enable]

    image = Image.new(@width, @height, C_DEFAULT)
    image.box_fill(0, 0, @width, @height, frame_color)
    image.box_fill(@frame_width, @frame_width, @width - @frame_width - 1, @height - @frame_width - 1, inner_color)

    unless mark_image == "" then
      _mark = Image.load(mark_image)
      size = @height - (@frame_width * 2)
      mark = RenderTarget.new(size, size).draw_scale(0, 0, _mark, size / _mark.width.to_f,
                                                      size / _mark.height.to_f, 0, 0).update.to_image
      mark = mark.flush(mark_color)
      _mark.dispose
    end

    @images, @marks = [image], [mark]

    @images.push(image.change_hls(0, -20, 0))
    @images.push(image.change_hls(0, 20, 0))
    @images.push(image.change_hls(0, 35, -35))

    @marks.push(mark.change_hls(0, -20, 0))
    @marks.push(mark.change_hls(0, 20, 0))
    @marks.push(mark.change_hls(0, 35, -35))

    @image, @mark = @images[0], @marks[0]

    @is_checked = false
    @is_clicked = false
  end

  def set_pos(x, y)
    @x, @y = x, y
  end

  def draw
    @target.draw(@x, @y, @image, @z) if @image
    @target.draw(@x + @frame_width, @y + @frame_width, @mark, @z) if @is_checked and @mark
  end

  def clicked?

    mouse_x = Input.mouse_pos_x
    mouse_y = Input.mouse_pos_y

    if Input.mouse_push?(M_LBUTTON) and
      mouse_x >= @x and mouse_x <= @x + @width and mouse_y >= @y and mouse_y <= @y + @height and
      not @is_clicked and @is_enable then

      @image = @images[1] if @images[1]
      @mark = @marks[1] if @marks[1]

      @is_clicked = true
      return false

    elsif Input.mouse_release?(M_LBUTTON) then
      if mouse_x >= @x and mouse_x <= @x + @width and mouse_y >= @y and mouse_y <= @y + @height then
        if @is_clicked and @is_enable then

          @image = @images[0] if @images[0]
          @mark = @marks[0] if @marks[0]
          @is_clicked = false

          unless @is_checked then
            @is_checked = true
          else
            @is_checked = false
          end
          return true
        end
      else
        @image = @images[0] if @images[0]
        @mark = @marks[0] if @marks[0]
        @is_clicked = false
      end
    else
      return false
    end
  end

  def hovered?

    mouse_x = Input.mouse_pos_x
    mouse_y = Input.mouse_pos_y

    if not @is_clicked and @is_hoverable and @is_enable then
      if mouse_x >= @x and mouse_x <= @x + @width and mouse_y >= @y and mouse_y <= @y + @height then
        @image = @images[2] if @images[2]
        @mark = @marks[2] if @marks[2]
        return true
      else
        @image = @images[0] if @images[0]
        @mark = @marks[0] if @marks[0]
        return false
      end
    end
  end

  def auto_click

    if @is_enable then
      unless @is_checked then
        @is_checked = true
      else
        @is_checked = false
      end
    end
  end

  def enable=(is_enable)

    @is_enable = is_enable
    if @is_enable then
      @image = @images[0]
    else
      @image = @images[3]
    end
  end

  def vanish

    unless @images.empty then
      @images.each do |image|
        image.clear
        image.dispose unless image.disposed?
      end
      @images.clear

      unless @marks.empty then
        @marks.each do |mark|
          mark.clear
          mark.dispose unless mark.disposed?
        end
        @marks.clear
      end
    end
  end
end


if __FILE__ == $0

  MARK_IMAGE = File.dirname(__FILE__) + "/../../images/22612348_a.png"

  if File.exist?(MARK_IMAGE) then
    mark_image = MARK_IMAGE
  else
    mark_image = ""
  end

  check_box = CheckBox.new(0, 0, 0, 100, mark_image, C_BLACK, C_WHITE, C_BLACK, :frame_width=>5)
  check_box.set_pos((Window.width - check_box.width) * 0.5, (Window.height - check_box.height) * 0.5)

  # check_box.enable = false

  Window.bgcolor = C_GREEN
  Window.loop do
    check_box.hovered?
    check_box.clicked?
    check_box.draw
  end
end
