#! ruby -Ks
# -*- mode:ruby; coding:shift_jis -*-
$KCODE = "s"
require "jcode"

# OL^֘A

require "dxruby"


class Log

  attr_reader :start_date, :start_date_time
  attr_accessor :parent_dir

  if __FILE__ == $0
    require "../lib/files"
  else
    require "./lib/files"
  end

  include Files

  def initialize
    @start_date = Time.now.strftime("%Y.%m.%d")
    @start_date_time = Time.now.strftime("#{@start_date}_%H.%M.%S")
    @parent_dir = ""
  end

  # L^̑OɃOt@Cݒ肷邱ƂYꂸ
  def set_log(dir, file="")
    @dir = dir
    @file = file
    makeDirNotExist(@dir)
    @path = "#{@dir}/#{@file}"
  end

  def write(data, dim=1)
    csvWriteArray(@path, data) if data.class == Array and dim == 1
    csvAddArray2d(@path, data) if data.class == Array and dim == 2
    file_write(@path, data) if data.class == String
  end

  def add(data)
    csvAddArray(@path, data) if data.class == Array
    file_add(@path, data) if data.class == String
  end

  def read(file=@file, dir=@dir)
    path = "#{dir}/#{file}"
    csvReadArray(path)
  end

  # XN[Vbgۑ
  def screen_shot(file="test.png", dir=@dir,  target=Window)
    makeDirNotExist(dir)
    path = "#{dir}/#{file}"
    target.get_screen_shot(path)
  end
end
