#! ruby -Ks
# -*- mode:ruby; coding:shift_jis -*-
$KCODE = "s"
require "jcode"

# NWbgʃNX

require "dxruby"

require File.dirname(__FILE__) + "/../lib/dxruby/images"
require File.dirname(__FILE__) + "/../lib/dxruby/button"


class Credit

  attr_accessor :shadow_x, :shadow_y, :name, :id, :target, :z, :is_active, :is_viewable
  attr_reader :width, :height, :close_button

  FRAME_IMAGE_FILE = File.dirname(__FILE__) + "/../images/22075110_a.png"
  CLOSE_BUTTON_IMAGE = File.dirname(__FILE__) + "/../images/sozai_cman_jp_20220417010211.png"

  SHADOW_OFFSET_X = 10
  SHADOW_OFFSET_Y = 10

  CREDIT_IMAGE_SCALE_RATIO = 0.96

  def initialize(x=0, y=0, width=300, height=100, credit_image_file="", option={})
    option = {:name=>"message_dialog", :id=>0, :target=>Window, :z=>0}.merge(option)

    @x = x
    @y = y
    @width = width
    @height = height

    @target = option[:target]
    @id = option[:id]
    @name = option[:name]
    @z = option[:z]

    @shadow_x = SHADOW_OFFSET_X
    @shadow_y = SHADOW_OFFSET_Y

    @image = Image.new(@width, @height)

    _credit_image = Image.load(credit_image_file)
    credit_scale =  @height * CREDIT_IMAGE_SCALE_RATIO / _credit_image.height
    credit_image = Images.scale_resize(_credit_image, credit_scale, credit_scale)
    @image.draw((@width - credit_image.width) * 0.5, (@height - credit_image.height) * 0.5, credit_image)

    _frame_image = Image.load(FRAME_IMAGE_FILE)
    frame_image = Images.fit_resize(_frame_image, @width, @height)
    @image.draw(0, 0, frame_image)

    @shadow = @image.flush([64, 0, 0, 0])

    close_button_height = @height * 0.1
    close_button_width = close_button_height
    @close_button = Button.new(@x + (@width - close_button_width) + 0.97, @y + (@height - close_button_height) * 0.04,
                               close_button_width, close_button_height)

    close_button_image = Image.load(CLOSE_BUTTON_IMAGE)
    @close_button.set_image(Images.fit_resize(close_button_image, @close_button.width, @close_button.height))
    @close_button.set_pos(@x + (@width - @close_button.width) * 0.967, @y + (@height - @close_button.height) * 0.05)
  end

  def set_pos(x, y)
    @x = x
    @y = y
    @close_button.set_pos(@x + (@width - @close_button.width) * 0.967, @y + (@height - @close_button.height) * 0.05)
  end

  def draw
    @target.draw(@x + @shadow_x, @y + @shadow_y, @shadow, @z)
    @target.draw(@x, @y, @image, @z)
    @close_button.draw
  end

  def vanish
    @shadow.dispose
    @image.dispose
    @close_button.vanish
  end
end


if __FILE__ == $0 then

  Window.width = 1980
  Window.height = 1080

  CREDIT_IMAGE_FILE = File.dirname(__FILE__) + "/../images/Credit.PNG"

  credit_height = Window.height * 0.6
  credit_width = credit_height * (16 / 9.to_f)

  credit = Credit.new(0, 0, credit_width, credit_height, CREDIT_IMAGE_FILE)
  credit.set_pos((Window.width - credit.width) * 0.5, (Window.height - credit.height) * 0.5)

  Window.bgcolor = C_GREEN
  Window.loop do
    credit.draw if credit
  end
end
