#! ruby -Ks
# -*- mode:ruby; coding:shift_jis -*-
$KCODE = "s"
require "jcode"

# ݒ_CAO

require "dxruby"

require File.dirname(__FILE__) + "/../lib/dxruby/roundbox"
require File.dirname(__FILE__) + "/../lib/dxruby/fonts"
require File.dirname(__FILE__) + "/../lib/dxruby/images"
require File.dirname(__FILE__) + "/../lib/dxruby/button"
require File.dirname(__FILE__) + "/../lib/dxruby/color"
require File.dirname(__FILE__) + "/../lib/dxruby/check_box"

include Color


class SettingDialog

  attr_accessor :shadow_x, :shadow_y, :target, :z, :is_active, :is_viewable
  attr_reader :x, :y, :width, :height, :is_close, :close_button,
              :hilight_check_box, :heatmap_check_box, :ranking_check_box,
              :time_input_box, :time_up_button, :time_down_button, :test_button,  :connect_button, :output_box

  CLOSE_BUTTON_IMAGE = File.dirname(__FILE__) + "/../images/sozai_cman_jp_20220417010211.png"
  MARK_IMAGE = File.dirname(__FILE__) + "/../images/22612348_a.png"
  TIME_UP_BUTTON_IMAGE = File.dirname(__FILE__) + "/../images/yazirusi_r.png"
  TIME_DOWN_BUTTON_IMAGE = File.dirname(__FILE__) + "/../images/yazirusi_l.png"
  CONNECT_BUTTON_IMAGE = File.dirname(__FILE__) + "/../images/m_1.png"

  SHADOW_OFFSET_X = 10
  SHADOW_OFFSET_Y = 10

  def initialize(x=0, y=0, width=800, height=600, option={})
    option = {:frame_thickness=>2, :radius=>10, :bg_color=>C_WHITE, :frame_color=>C_GREEN,
              :default_font_name=>"lr oSVbN", :number_font_name=>"lr oSVbN",
              :name=>"setting_dialog", :id=>0, :target=>Window, :z=>0}.merge(option)

    @frame_thickness = option[:frame_thickness].round
    @radius = option[:radius]
    @bg_color = option[:bg_color]
    @frame_color = option[:frame_color]

    @x = x
    @y = y
    @width = width
    @height = height

    @target = option[:target]
    @z = option[:z]

    @shadow_x = SHADOW_OFFSET_X
    @shadow_y = SHADOW_OFFSET_Y

    @image = Image.new(@width, @height)
    @image.roundbox_fill(0, 0, @width, @height, @radius, @bg_color)

    @frame_thickness.times do |index|
      @image.roundbox(index, index, @width - 1 - index, @height - 1 - index, @radius, @frame_color)
    end
    @shadow = @image.flush([64, 0, 0, 0])

    title_label = Fonts.new(0, 0, "ݒ", @height * 0.09, C_CUD_NON_COLORED_BLACK,
                            {:shadow=>false, :edge=>true, :edge_color=>C_CUD_NON_COLORED_WHITE, :edge_level=>9,
                             :font_name=>option[:default_font_name]})
    title_label.edge_width = title_label.height * 0.05

    @image.draw((@width - title_label.width) * 0.5, (@height - title_label.height) * 0.04, title_label.to_image)
    title_label.vanish

    close_button_height = @height * 0.1
    close_button_width = close_button_height
    @close_button = Button.new(@x + (@width - close_button_width) + 0.97, @y + (@height - close_button_height) * 0.04,
                               close_button_width, close_button_height)

    close_button_image = Image.load(CLOSE_BUTTON_IMAGE)
    @close_button.set_image(Images.fit_resize(close_button_image, @close_button.width, @close_button.height))
    @close_button.set_pos(@x + (@width - @close_button.width) * 0.97, @y + (@height - @close_button.height) * 0.04)

    hilight_check_box_size = @height * 0.1
    @hilight_check_box = CheckBox.new(@x + (@width - hilight_check_box_size) * 0.08,
                                     @y + (@height - hilight_check_box_size) * 0.2, 0, hilight_check_box_size,
                                     MARK_IMAGE, C_CUD_NON_COLORED_BLACK, C_CUD_NON_COLORED_WHITE,
                                     C_CUD_NON_COLORED_BLACK, :frame_width=>hilight_check_box_size * 0.1)
    @hilight_check_box.set_pos(@x + (@width - @hilight_check_box.width) * 0.1,
                               @y + (@height - @hilight_check_box.height) * 0.2)

    hilight_check_label = Fonts.new(0, 0, "wi", @height * 0.06, C_CUD_NON_COLORED_BLACK,
                            {:shadow=>false, :edge=>true, :edge_color=>C_CUD_NON_COLORED_WHITE, :edge_level=>9,
                             :font_name=>option[:default_font_name]})
    hilight_check_label.edge_width = hilight_check_label.height * 0.05

    @image.draw((@width - hilight_check_label.width) * 0.24, (@height - hilight_check_label.height) * 0.2,
                hilight_check_label.to_image)
    hilight_check_label.vanish

    heatmap_check_box_size = @height * 0.1
    @heatmap_check_box = CheckBox.new(@x + (@width - heatmap_check_box_size) * 0.53,
                                      @y + (@height - heatmap_check_box_size) * 0.2, 0, heatmap_check_box_size,
                                      MARK_IMAGE, C_CUD_NON_COLORED_BLACK, C_CUD_NON_COLORED_WHITE,
                                      C_CUD_NON_COLORED_BLACK, :frame_width=>heatmap_check_box_size * 0.1)
    @heatmap_check_box.set_pos(@x + (@width - @heatmap_check_box.width) * 0.55,
                               @y + (@height - @heatmap_check_box.height) * 0.2)

    heatmap_check_label = Fonts.new(0, 0, "q[g}bv\", @height * 0.06, C_CUD_NON_COLORED_BLACK,
                                    {:shadow=>false, :edge=>true, :edge_color=>C_CUD_NON_COLORED_WHITE,
                                     :edge_level=>9, :font_name=>option[:default_font_name]})
    heatmap_check_label.edge_width = heatmap_check_label.height * 0.05

    @image.draw((@width - heatmap_check_label.width) * 0.87, (@height - heatmap_check_label.height) * 0.2,
                heatmap_check_label.to_image)
    heatmap_check_label.vanish

    ranking_check_box_size = @height * 0.1
    @ranking_check_box = CheckBox.new(@x + (@width - ranking_check_box_size) * 0.53,
                                      @y + (@height - ranking_check_box_size) * 0.2, 0, ranking_check_box_size,
                                      MARK_IMAGE, C_CUD_NON_COLORED_BLACK, C_CUD_NON_COLORED_WHITE,
                                      C_CUD_NON_COLORED_BLACK, :frame_width=>ranking_check_box_size * 0.1)
    @ranking_check_box.set_pos(@x + (@width - @ranking_check_box.width) * 0.1,
                               @y + (@height - @ranking_check_box.height) * 0.4)

    ranking_check_label = Fonts.new(0, 0, "LO", @height * 0.06, C_CUD_NON_COLORED_BLACK,
                                    {:shadow=>false, :edge=>true, :edge_color=>C_CUD_NON_COLORED_WHITE,
                                     :edge_level=>9, :font_name=>option[:default_font_name]})
    ranking_check_label.edge_width = ranking_check_label.height * 0.05

    @image.draw((@width - ranking_check_label.width) * 0.22, (@height - ranking_check_label.height) * 0.4,
                ranking_check_label.to_image)
    ranking_check_label.vanish

    eye_mot_box_label = Fonts.new(0, 0, "EyeMoTBox Rg[", @height * 0.06, C_CUD_NON_COLORED_BLACK,
                                    {:shadow=>false, :edge=>true, :edge_color=>C_CUD_NON_COLORED_WHITE,
                                     :edge_level=>9, :font_name=>option[:default_font_name]})
    eye_mot_box_label.edge_width = eye_mot_box_label.height * 0.05

    eye_mot_box_label_y = (@height - eye_mot_box_label.height) * 0.74
    @image.draw((@width - eye_mot_box_label.width) * 0.5, eye_mot_box_label_y,
                eye_mot_box_label.to_image)

    in_span = @width * 0.01
    out_span = @width * 0.050
    line_width = @height * 0.005

    x1 = out_span
    y1 = eye_mot_box_label_y + ((eye_mot_box_label.height - line_width) * 0.7)
    x2 = (@width - eye_mot_box_label.width) * 0.5 - in_span
    y2 = y1 + line_width
    diff = x2 - x1 + eye_mot_box_label.width + (2 * in_span)
    eye_mot_box_label.vanish

    @image.box_fill(x1, y1, x2, y2, C_CUD_NON_COLORED_BLACK)
    @image.box_fill(x1 + diff, y1, x2 + diff, y2, C_CUD_NON_COLORED_BLACK)

    @output_box = Images.new(0, 0, @width * 0.37, @height * 0.16, "", @height * 0.04, C_WHITE, C_BLACK)
    @output_box.frame(C_CUD_NON_COLORED_BLACK, @output_box.height * 0.02)
    @output_box.set_pos((@width - @output_box.width) * 0.08, (@height - @output_box.height) * 0.93)

    @time_input_box = Images.new(0, 0, @width * 0.16, @height * 0.1, "", @height * 0.1,
                                C_WHITE, C_BLACK, :font_name=>option[:number_font_name])
    @time_input_box.frame(C_CUD_NON_COLORED_BLACK, @time_input_box.height * 0.04)
    @time_input_box.set_pos(@x + (@width - @time_input_box.width) * 0.62, @y + (@height - @time_input_box.height) * 0.93)

    time_input_box_label = Fonts.new(0, 0, "Up", @height * 0.045, C_CUD_NON_COLORED_BLACK,
                                    {:shadow=>false, :edge=>true, :edge_color=>C_CUD_NON_COLORED_WHITE,
                                     :edge_level=>9, :font_name=>option[:default_font_name]})
    time_input_box_label.edge_width = time_input_box_label.height * 0.05

    @image.draw((@width - time_input_box_label.width) * 0.62, (@height - time_input_box_label.height) * 0.81, time_input_box_label.to_image)
    time_input_box_label.vanish

    button_color = [255, 96, 96, 96]
    time_change_button_size = @height * 0.1

    time_up_button_image = Image.load(TIME_UP_BUTTON_IMAGE)
    time_up_button_image = time_up_button_image.flush(button_color)
    time_up_button_scale_y = time_change_button_size / time_up_button_image.height
    time_up_button_scale_x = time_up_button_scale_y
    time_up_button_converted_image = Images.scale_resize(time_up_button_image,
                                                         time_up_button_scale_x, time_up_button_scale_y)

    @time_up_button = Button.new(0, 0, time_up_button_converted_image.width, time_up_button_converted_image.height)
    @time_up_button.set_image(time_up_button_converted_image)
    @time_up_button.set_pos(@x + (@width - @time_up_button.width) * 0.728,
                            @y + (@height - @time_up_button.height) * 0.93)

    time_down_button_image = Image.load(TIME_DOWN_BUTTON_IMAGE)
    time_down_button_image = time_down_button_image.flush(button_color)
    time_down_button_scale_y = time_change_button_size / time_down_button_image.height
    time_down_button_scale_x = time_down_button_scale_y
    time_down_button_converted_image = Images.scale_resize(time_down_button_image,
                                                           time_down_button_scale_x, time_down_button_scale_y)

    @time_down_button = Button.new(0, 0, time_down_button_converted_image.width,
                                   time_down_button_converted_image.height)
    @time_down_button.set_image(time_down_button_converted_image)
    @time_down_button.set_pos(@x + (@width - @time_down_button.width) * 0.48,
                              @y + (@height - @time_down_button.height) * 0.93)

    test_button_height = @height * 0.08
    test_button_width = test_button_height * 2.6
    @test_button = Button.new(@x + (@width - test_button_width) * 0.94,
                                 @y + (@height - test_button_height) * 0.83,
                              test_button_width, test_button_height, "eXg", test_button_height * 0.7)

    test_button_image = Image.load(CONNECT_BUTTON_IMAGE)
    test_button_image = test_button_image.flush(button_color)
    @test_button.set_image(Images.fit_resize(test_button_image, @test_button.width, @test_button.height))

    connect_button_height = @height * 0.08
    connect_button_width = connect_button_height * 2.6
    @connect_button = Button.new(@x + (@width - connect_button_width) * 0.94,
                                 @y + (@height - connect_button_height) * 0.94,
                                 connect_button_width, connect_button_height, "ڑ", connect_button_height * 0.7)

    connect_button_image = Image.load(CONNECT_BUTTON_IMAGE)
    connect_button_image = connect_button_image.flush(button_color)
    @connect_button.set_image(Images.fit_resize(connect_button_image, @connect_button.width, @connect_button.height))
  end

  def set_pos(x, y)
    @x = x
    @y = y
    @close_button.set_pos(@x + (@width - @close_button.width) * 0.97, @y + (@height - @close_button.height) * 0.04)
    @hilight_check_box.set_pos(@x + (@width - @hilight_check_box.width) * 0.1,
                                    @y + (@height - @hilight_check_box.height) * 0.2)
    @heatmap_check_box.set_pos(@x + (@width - @heatmap_check_box.width) * 0.55,
                               @y + (@height - @heatmap_check_box.height) * 0.2)
    @ranking_check_box.set_pos(@x + (@width - @ranking_check_box.width) * 0.1,
                               @y + (@height - @ranking_check_box.height) * 0.4)
    @output_box.set_pos(@x + (@width - @output_box.width) * 0.08, @y + (@height - @output_box.height) * 0.93)
    @time_input_box.set_pos(@x + (@width - @time_input_box.width) * 0.62, @y + (@height - @time_input_box.height) * 0.93)
    @time_up_button.set_pos(@x + (@width - @time_up_button.width) * 0.728,
                            @y + (@height - @time_up_button.height) * 0.93)
    @time_down_button.set_pos(@x + (@width - @time_down_button.width) * 0.48,
                              @y + (@height - @time_down_button.height) * 0.93)
    @test_button.set_pos(@x + (@width - @test_button.width) * 0.94, @y + (@height - @test_button.height) * 0.83)
    @connect_button.set_pos(@x + (@width - @connect_button.width) * 0.94, @y + (@height - @connect_button.height) * 0.94)
  end

  def draw
    @target.draw(@x + @shadow_x, @y + @shadow_y, @shadow, @z) if @shadow
    @target.draw(@x, @y, @image, @z) if @image
    @close_button.draw if @close_button
    @hilight_check_box.draw if @hilight_check_box
    @heatmap_check_box.draw if @heatmap_check_box
    @ranking_check_box.draw if @ranking_check_box
    @output_box.draw if @output_box
    @time_input_box.draw if @time_input_box
    @time_up_button.draw if @time_up_button
    @time_down_button.draw if @time_down_button
    @test_button.draw if @test_button
    @connect_button.draw if @connect_button
  end

  def vanish
    @shadow.clear
    @shadow.dispose
    @image.clear
    @image.dispose
    @close_button.vanish
    @hilight_check_box.vanish
    @heatmap_check_box.vanish
    @ranking_check_box.vanish
    @output_box.vanish
    @time_input_box.vanish
    @time_up_button.vanish
    @time_down_button.vanish
    @test_button.vanish
    @connect_button.vanish
  end
end


if __FILE__ == $0 then

  require File.dirname(__FILE__) + "/../lib/dxruby/color"
  include Color

  Font.install(File.dirname(__FILE__) + "/../fonts/mxPOP.otf")
  Font.install(File.dirname(__FILE__) + "/../fonts/Phenomena-Bold.ttf")

  Window.width = 1920
  Window.height = 1080

  setting_dialog_height = Window.height * 0.8
  setting_dialog_width = setting_dialog_height * 1.3
  setting_dialog_option = {:frame_thickness=>(setting_dialog_height * 0.02).round, :radius=>setting_dialog_height * 0.03,
                           :bg_color=>C_CUD_NON_COLORED_LIGHT_GRAY, :frame_color=>C_CUD_NON_COLORED_GRAY,
                           :default_font_name=>"07mxPOP", :number_font_name=>"Phenomena"}

  setting_dialog = SettingDialog.new(0, 0, setting_dialog_width, setting_dialog_height, setting_dialog_option)
  setting_dialog.set_pos((Window.width - setting_dialog.width) * 0.5, (Window.height - setting_dialog.height) * 0.5)
  setting_dialog.is_active = true
  setting_dialog.is_viewable = true

  Window.bgcolor = C_SKY_BLUE
  Window.loop do
    setting_dialog.draw if setting_dialog and setting_dialog.is_viewable
    setting_dialog.hilight_check_box.clicked?
    setting_dialog.heatmap_check_box.clicked?
  end
end