
#! ruby -Ks
# -*- mode:ruby; coding:shift_jis -*-
$KCODE = "s"
require "jcode"

require "dxruby"

# oCu}NX
# "9"Ń@Cu[V


class VibeMan

  attr_accessor :type, :vibe_time, :parent, :is_connecting
  attr_reader :output

  require "rubygems"
  require "Win32Serial"
  require "win32ole"
  require "thread"

  CONNECT_TRY_COUNT = 3

  def initialize
    @serials = []
    @responses = []
    @vibemans = []
    @vibe_type = 1
    @vibe_time = 200
    @is_connecting = false
  end

  # p\ȃVA|[gnbVŕԂ
  def serialports

    locator = WIN32OLE.new("WbemScripting.SWbemLocator")

    services = locator.ConnectServer()

    comlist = {}

    # VA|[gꗗ擾
    services.ExecQuery("SELECT * FROM Win32_SerialPort").each do |item|
      comlist[item.DeviceID] = item.Name
    end

    # PnPVA|[gꗗ擾
    services.ExecQuery("SELECT * FROM Win32_PnPEntity").each do |item|
      comlist[$1] = item.Description if item.Name =~ /\((COM\d+)\)/
    end

    return Hash[
      # VA|[gɊ܂܂鐔lɃ\[g
      comlist.sort_by {|k, v|
        k.scan(/(\d+)|([^\d]+)/).map{|s|
          s[0] ? [0, s[0].to_i] : [1, s[1]]
        }
      }
    ]
  end

  def connect

    ports = self.serialports.select { |port, value| not value.include?("Bluetooth") }

    check_port = Thread.new do
      CONNECT_TRY_COUNT.times do

        ports.each do |port|
          serial = Win32Serial.new

          serial.open(port[0])
          serial.config(9600, 8, Win32Serial::NOPARITY, Win32Serial::ONESTOPBIT)
          serial.timeouts(0,200,0,0,0)
          sleep(3)

          serial.write("areyouvibeman")
          raw = serial.read(14)

          @responses.push({:port=>port[0], :raw=>raw}) if not raw == "" and raw
          serial.close
        end
        break unless @responses.empty?
      end
    end

    check_port.join

    @output = ""
    unless @responses.empty? then

      @responses.each do |response|

        unit = response[:raw].split(/-|,/)
        response[:port]

        if unit[0] == "iamvibeman2" then
          vibeman = {:port=>response[:port], :version=>"2", :serial=>nil}
          @output += "#{response[:port]}\nEyeMoTBox[Ver.#{vibeman[:version]}]\nڑ܂B\n"
          @is_connecting = true

        elsif unit.size >= 5 then
          vibeman = {:port=>response[:port], :version=>"1", :serial=>nil}
          @output += " #{response[:port]}\nEyeMoTBox[Ver.#{vibeman[:version]}]\nڑ܂B\n"
          @is_connecting = true
        end
        @vibemans.push(vibeman)
      end
    end
    @parent.callback_output(@output) if @parent
    @responses.clear

    self.open if @is_connecting
  end

  def open

    @vibemans.each do |vibeman|
      serial = Win32Serial.new

      serial.open(vibeman[:port])
      serial.config(9600, 8, Win32Serial::NOPARITY, Win32Serial::ONESTOPBIT)
      serial.timeouts(0,200,0,0,0)

      vibeman[:serial] = serial
    end
  end

  def vibe

    @vibemans.each do |vibeman|

      case @vibe_type

      when 1
        vibeman[:serial].write("9\n")

      when 2
        vibeman[:serial].write("8:2:#{@vibe_time}\n")
      end
      response = vibeman[:serial].read(14)

      if not response == "" and response then
        @output = "MMɐ܂B\nEyeMoTBox͐\n삵Ă܂B"
      else
        @output = "MMG[c"
      end
      @parent.callback_output(@output) if @parent
    end
  end

  def disconnect

    @vibemans.each do |vibeman|
      vibeman[:serial].close
      vibeman[:serial] = nil
      @vibemans.clear
    end
    @is_connecting = false
    @output = "SĂEyeMoTBox\nؒf܂B"
    @parent.callback_output(@output) if @parent
  end
end