#! ruby -Ks
# -*- mode:ruby; coding:shift_jis -*-
$KCODE = "s"
require "jcode"

# radio_button.rb Ver 1.0
# {^쐬pCu

require "dxruby"


class RadioButton

  attr_accessor :x, :y, :id, :name, :target, :is_auto_clicked, :z
  attr_reader :size

  def initialize(x, y, id=0, size=20, markColor=C_BLACK, innerColor=C_WHITE, frameColor=C_BLACK, option={})
    option = {:id=>0, :name=>"radio_button", :markSize=>6, :frameSize=>2, :z=>0, :target=>Window}.merge(option)

    @target = option[:target]
    @x = x
    @y = y
    @z = option[:z]
    @size = size
    @name = option[:name]
    @id = id

    @markColor = markColor
    @innerColor = innerColor
    @frameColor = frameColor
    @markSize = option[:markSize]
    @frameSize = option[:frameSize]

    @isCheck = false
    self.constract
  end

  def constract

    @image.dispose if @image and not @image.disposed?
    @image = Image.new(@size, @size, C_DEFAULT)

    @image.circleFill(@size * 0.5, @size * 0.5, size * 0.5, @frameColor)
    @image.circleFill(@size * 0.5, @size * 0.5, size * 0.5 - @frameSize, @innerColor)
  end

  def setCheck(bool)

    if bool then
      unless @isCheck then
        @image.circleFill(@size * 0.5, @size * 0.5, @markSize, @markColor)
        @isCheck = true
      end
    elsif @isCheck
      @isCheck = false
      self.constract
    end
  end

  #`ʒu̐ݒ
  def setPos(x, y)
    @x, @y = x, y
  end

  def draw
    @target.draw(@x, @y, @image, @z)
  end

  #{^̏
  def checked?

    mouseX = Input.mousePosX
    mouseY = Input.mousePosY

    if Input.mousePush?(M_LBUTTON) and not @isCheck then
      if mouseX >= @x and mouseX <= @x + @size and mouseY >= @y and mouseY <= @y + @size then

        self.setCheck(true)
        @isCheck = true
        return true
      end
    end
    return false
  end
end


if __FILE__ == $0

  Window.bgcolor = C_WHITE

  radioButtons = []
  4.times do |index|
    radioButtons << RadioButton.new(300, 200 + (50 * index), index)
  end
  radioButtons[0].setCheck(true)

  Window.loop do

    # WI{^̔r ##########
    checkID = nil
    for radioButton in radioButtons do
      if radioButton.checked? then
        checkID = radioButton.id

        case checkID
        when 0 then
          # Enter your code...
        end
      end
    end

    if checkID then
      for radioButton in radioButtons do
        unless radioButton.id == checkID then
          radioButton.setCheck(false)
        end
      end
    end
    ###################################

    for radioButton in radioButtons do
      radioButton.draw
    end
  end
end
