#! ruby -Ks
# -*- mode:ruby; coding:shift_jis -*-
$KCODE = "s"
require "jcode"

# Ct@C

# exerbŌł߂exeNƂJgfBNgexẽpXɂlI
if defined?(ExerbRuntime)
  Dir.chdir(File.dirname(ExerbRuntime.filepath))
end

require "dxruby" # DXRuby{
require "./lib/dxruby/scene" # Q[Jڂ̗v

# CXg[tHg ###
# ʂ}WbN
# R̗tHg
# `FbN|CgtHg
# 07mxPOP
# ARȏM
# ݂
# Ballpark
# Boldhead
# Phenomena
# CJhL


class Configuration

  attr_reader :fps, :frame_step, :app_name, :app_sub_title, :copyright, :ver_num,
              :post_url, :get_url, :default_name, :eyemot_mouse, :log, :vibeman
  attr_accessor :scores, :screen_shot_count, :play_count, :hilighted, :heatmap_type, :is_ranking

  require "./lib/display"
  require "./lib/dxruby/color"
  require "./scripts/resolution"
  require "./scripts/eyemot_mouse"
  require "./scripts/log"
  require "./scripts/vibeman"

  include Display
  include Color

  # AvP[Vݒ
  APPLICATION_NAME = ""
  APPLICATION_SUB_TITLE = "EyeMoT Additional Game 01"
  COPYRIGHT = "Powered by Ruby, DXRuby, VisualuRuby & Rails."
  VERSION_NUMBER = "1.0.3"
  APPLICATION_ICON = "./images/icon.ico"

  FPS = 60
  FRAME_STEP = 1
  FRAME_SKIP = true

  # f[^x[X POST URL
  POST_URL = "http://tk2-254-36598.vs.sakura.ne.jp/ranking/eye_kingyo_scoopings/record"

  # f[^x[X GET URL
  GET_URL = "http://tk2-254-36598.vs.sakura.ne.jp/ranking/eye_kingyo_scoopings/show"

  DEFAULT_NAME = "ȂȂ"

  # ̃EBhEJ[
  DEFAULT_BACK_GROUND_COLER = C_CUD_NON_COLORED_BLACK

  # NɃEBhEʒɕ\
  IS_WINDOW_CENTER = true

  TANUKI_MAGIC_FONT = "./fonts/TanukiMagic.ttf"
  JIYUNO_TSUBASA_FONT = "./fonts/JiyunoTsubasa.ttf"
  CHECK_POINT_FONT = "./fonts/CP Font.ttf"
  LIGHT_NOVEL_POP_FONT = "./fonts/mxPOP.otf"
  AR_KYOUKASYOTAI_M_FONT = "./fonts/JTST00M.TTC"
  MIKACHAN_FONT = "./fonts/mikachanALL.ttc"
  BALL_PARK_FONT = "./fonts/BALLW___.TTF"
  BOLDHEAD_FONT = "./fonts/Boldhead.otf"
  PHENOMENA_FONT = "./fonts/Phenomena-Bold.ttf"
  IKAMODOKI_FONT = "./fonts/ikamodoki1_0.ttf"

  DEFAULT_IS_HILIGHTED = false
  DEFAULT_HEATMAP_TYPE = :heatmap
  DEFAULT_IS_RANKING = false

  IS_RESOLUTION_DIALOG_ENABLE = false

  def initialize

    # EyeMoTBox֘A
    @vibeman = VibeMan.new
    @vibeman.vibe_time = 200

    # ̓foCX̋N
    @eyemot_mouse = EyeMoTMouse.new
    @eyemot_mouse.open

    @log = Log.new
    @log.parent_dir = "./YOUR_RECORD/#{@log.start_date_time}"
    @log.set_log(@log.parent_dir)
    @screen_shot_count = 1
    @play_count = 0

    @hilighted = DEFAULT_IS_HILIGHTED
    @heatmap_type = DEFAULT_HEATMAP_TYPE

    @fps = FPS
    @frame_step = FRAME_STEP

    @app_name = APPLICATION_NAME
    @app_sub_title = APPLICATION_SUB_TITLE
    @copyright = COPYRIGHT
    @ver_num = VERSION_NUMBER

    @post_url = POST_URL
    @get_url = GET_URL

    @default_name = DEFAULT_NAME
    @scores = {}

    # tHg̃CXg[
    Font.install(TANUKI_MAGIC_FONT)
    Font.install(JIYUNO_TSUBASA_FONT)
    Font.install(CHECK_POINT_FONT)
    Font.install(LIGHT_NOVEL_POP_FONT)
    Font.install(AR_KYOUKASYOTAI_M_FONT)
    Font.install(MIKACHAN_FONT)
    Font.install(BOLDHEAD_FONT)
    Font.install(BALL_PARK_FONT)
    Font.install(PHENOMENA_FONT)
    Font.install(IKAMODOKI_FONT)

    resolutions =  Window.get_screen_modes.select {|resolution| resolution.delete_at(2) }
    resolutions.uniq! if resolutions.uniq!
    resolutions = resolutions.select { |resoluton|
      resoluton[0] <= Display::FHD[0] and resoluton[1] <= Display::FHD[1] and
        resoluton[0] >= Display::SVGA[0] and resoluton[1] >= Display::SVGA[1] }
    resolutions = resolutions.sort { |a, b| a[0] <=> b[0] }.reverse

    if IS_RESOLUTION_DIALOG_ENABLE then
      option = {:resolutions=>resolutions, :app_name=>APPLICATION_NAME, :ver_num=>VERSION_NUMBER}
      resolution = VRLocalScreen.modalform(nil, nil, ResolutionDialog, nil, option)

      # _CAOvOŜI
      if resolution == "cancel" or resolution == false then
        exit
      else
        window_size = resolution[0]
        window_mode = resolution[1]
      end
    else
      window_size = resolutions[0]
      window_mode = false
    end

    initWindowRect = setFixWindow(window_size, IS_WINDOW_CENTER)
    if initWindowRect[:windowX] and initWindowRect[:windowY] then
      windowX, windowY = initWindowRect[:windowX], initWindowRect[:windowY]
      Window.x = windowX
      Window.y = windowY
    end

    Window.width  = initWindowRect[:windowWidth]
    Window.height = initWindowRect[:windowHeight]
    Window.caption = "#{APPLICATION_NAME} Ver#{VERSION_NUMBER}"
    Window.loadIcon(APPLICATION_ICON)
    Window.bgcolor = DEFAULT_BACK_GROUND_COLER
    Window.frameskip = FRAME_SKIP
    Window.windowed = window_mode

    # EyeMoTMouseƂ΍
    sleep(1)

    # WindowőOʕ\
    set_window_top(Window.hWnd)
  end
end

# mp3Ȃǂ炷
Dir.chdir("./lib/dxruby") do
  require "Bass"
end
Bass.init(Window.hWnd)

# Kvŏ̃O[oϐ
$config = Configuration.new

$config.scores = {:name=>$config.default_name, :score=>0, :technical_point=>0, :max_combo=>0,
                  :catched_kingyo_number=>0, :catched_boss_number=>0, :cognomen=>"ER", :color=>C_WHITE}


# XvbV
class SplashScene < Scene::Base

  require "./lib/dxruby/color"
  require "./lib/dxruby/fonts"
  require "./lib/dxruby/images"
  require "./scripts/card"

  include Color

  SYMBOL_FRONT_IMAGE = "./images/simple_goldfish.png"
  SYMBOL_BACK_IMAGE = "./images/icon.png"
  CLICK_SE = "./sounds/meka_ge_mouse_s02.wav"
  SCREEN_SHOT_SE = "./sounds/Camera-Phone01-1.wav"
  SPLASH_IMAGE = "./images/eyemot_logo_jpn.png"

  SPLASH_IMAGE_SCALE_RATIO = 0.34
  MAX_WAIT_COUNT = 180

  def init

    @background_image = Image.new(Window.width, Window.height, C_CUD_BASE_LIGHT_SKY)
    @click_se = Sound.new(CLICK_SE)
    @screen_shot_se = Sound.new(SCREEN_SHOT_SE)

    _copyright1_label = Fonts.new(0, 0, "Produced by", Window.height * 0.04, C_CUD_ACCENT_GREEN,
                             {:font_name=>"Boldhead"})
    _copyright1_label.edge = true
    _copyright1_label.edge_width = _copyright1_label.height * 0.05

    @copyright1_label = Images.new((Window.width - _copyright1_label.width) * 0.5,
                                   (Window.height - _copyright1_label.height) * 0.77,
                                   _copyright1_label.width, _copyright1_label.height)
    @copyright1_label.image = _copyright1_label.to_image
    _copyright1_label.vanish

    _copyright2_label = Fonts.new(0, 0, "Tadano Laboratory", Window.height * 0.04, C_CUD_ACCENT_RED,
                             {:font_name=>"Boldhead"})
    _copyright2_label.edge = true
    _copyright2_label.edge_width = _copyright2_label.height * 0.05

    @copyright2_label = Images.new((Window.width - _copyright2_label.width) * 0.5,
                                   (Window.height - _copyright2_label.height) * 0.82,
                                   _copyright2_label.width, _copyright2_label.height)
    @copyright2_label.image = _copyright2_label.to_image
    _copyright2_label.vanish

    _splash_image = Image.load(SPLASH_IMAGE)
    splash_scale =  Window.height * SPLASH_IMAGE_SCALE_RATIO / _splash_image.height
    splash_image = Images.scale_resize(_splash_image, splash_scale, splash_scale)

    @splash_image = Images.new((Window.width - splash_image.width) * 0.5,
                               (Window.height - splash_image.height) * 0.17, splash_image.width, splash_image.height)
    @splash_image.image = splash_image
    @splash_image.frame(C_CUD_ACCENT_BROWN, @splash_image.height * 0.01)

    @card = Card.new(0, 0, Window.height * 0.2, Window.height * 0.2)
    @card.set_pos((Window.width - @card.width) * 0.5, (Window.height - @card.height) * 0.65)

    @card.set_image(SYMBOL_FRONT_IMAGE, SYMBOL_BACK_IMAGE)
    @card.flip_speed = 2
    @card.mode = :turn

    @wait_count = 0

    Thread.new do
      $config.vibeman.connect
    end
    $config.eyemot_mouse.eye_on
  end

  def update

    if Input.key_release?(K_ESCAPE) then
      $config.eyemot_mouse.close
      exit
    end

    if Input.key_release?(K_W) then
      if Window.windowed? then
        Window.windowed = false
      else
        Window.windowed = true
      end
      @click_se.play if @click_se
    end

    if Input.key_release?(K_X) then
      if not $config.eyemot_mouse.mode == :off then
        $config.eyemot_mouse.eye_off
      elsif $config.eyemot_mouse.mode == :off
        $config.eyemot_mouse.eye_on
      end
    end

    if Input.key_release?(K_P) then
      $config.log.screen_shot("screen_shot_#{$config.screen_shot_count}.png")
      $config.screen_shot_count += 1
      @screen_shot_se.play if @screen_shot_se
    end

    if @wait_count >= MAX_WAIT_COUNT then
      self.next_scene = TitleScene
    else
      @card.update if @card
      @wait_count += 1
    end
  end

  def render

    Window.draw(0, 0, @background_image) if @background_image
    @copyright1_label.draw if @copyright1_label
    @copyright2_label.draw if @copyright2_label
    @card.draw if @card
    @splash_image.draw if @splash_image
  end

  def will_disappear
  end
end


# ^CgEV[
class TitleScene < Scene::Base

  require "./lib/dxruby/images"
  require "./lib/dxruby/fonts"
  require "./lib/dxruby/button"
  require "./lib/dxruby/color"
  require "./lib/dxruby/easing"

  require "./scripts/poi"
  require "./scripts/message_dialog"
  require "./scripts/setting_dialog"
  require "./scripts/credit"

  include Color
  include Easing

  CLICK_SE = "./sounds/meka_ge_mouse_s02.wav"
  SCREEN_SHOT_SE = "./sounds/Camera-Phone01-1.wav"
  START_GAME_SE = "./sounds/decision27.wav"
  BACK_GROUND_IMAGE = "./images/VectorNaturalGreenBackground_S.png"
  START_BUTTON_IMAGE = "./images/start_button.png"
  EXIT_BUTTON_IMAGE = "./images/s_3.png"
  RANKING_BUTTON_IMAGE = "./images/ranking_button.png"
  VIBEMAN_START_BUTTON_IMAGE = "./images/1067276.png"
  OK_BUTTON_IMAGE = "./images/m_4.png"
  CANCEL_BUTTON_IMAGE = "./images/m_1.png"
  SETTING_BUTTON_IMAGE = "./images/192952.png"
  CREDIT_IMAGE_FILE = "./images/Credit.PNG"

  MAX_COUNT_IN_WINDOW = 40
  MAX_COUNT_IN_GAZE_AREA = 30

  POI_HEIGHT_SIZE_RATIO = 0.2
  MAX_GAZE_COUNT = 15
  POI_GAZE_RADIUS_RATIO = 0.8
  
  def init

    $config.scores = {:name=>$config.default_name, :score=>0, :technical_point=>0, :max_combo=>0,
               :catched_kingyo_number=>0, :catched_boss_number=>0, :cognomen=>"ER", :color=>C_CUD_ACCENT_BROWN}

    @click_se = Sound.new(CLICK_SE)
    @screen_shot_se = Sound.new(SCREEN_SHOT_SE)
    @start_game_se = Sound.new(START_GAME_SE)

    background_image = Image.load(BACK_GROUND_IMAGE)
    @background_image = Images.fit_resize(background_image, Window.width, Window.height)

    _title_label = Fonts.new(0, 0, $config.app_name, Window.height * 0.2, C_CUD_ACCENT_RED,
                            {:font_name=>"`FbN|CgtHg"})
    _title_label.edge = true
    _title_label.edge_width = _title_label.height * 0.05

    @title_label = Images.new((Window.width - _title_label.width) * 0.5, (Window.height - _title_label.height) * 0.3,
                              _title_label.width, _title_label.height)
    @title_label.image = _title_label.to_image
    _title_label.vanish

    _sub_title_label = Fonts.new(0, 0, $config.app_sub_title, Window.height * 0.1, C_CUD_ACCENT_YELLOW,
                                 {:font_name=>"Phenomena"})
    _sub_title_label.edge = true
    _sub_title_label.edge_width = _sub_title_label.height * 0.05

    @sub_title_label = Images.new((Window.width - _sub_title_label.width) * 0.5,
                                  (Window.height - _sub_title_label.height) * 0.09,
                              _sub_title_label.width * 0.05, _sub_title_label.height * 0.05)
    @sub_title_label.image = _sub_title_label.to_image
    _sub_title_label.vanish

    _version_number_label = Fonts.new(0, 0, "Version #{$config.ver_num}",
                                      @title_label.height * 0.3, C_CUD_ACCENT_GREEN, {:font_name=>"R̗tHg"})
    _version_number_label.edge = true
    _version_number_label.edge_width = _version_number_label.height * 0.05

    @version_number_label = Images.new(@title_label.x + @title_label.width - _version_number_label.width,
                                       @title_label.y + @title_label.height,
                                  _version_number_label.width, _version_number_label.height)
    @version_number_label.image = _version_number_label.to_image
    _version_number_label.vanish

    _copyright_label = Fonts.new(0, 0, $config.copyright, Window.height * 0.06, C_CUD_NON_COLORED_BLACK,
                                {:font_name=>"07mxPOP"})
    _copyright_label.edge = true
    _copyright_label.edge_color = C_CUD_NON_COLORED_WHITE
    _copyright_label.edge_width = _copyright_label.height * 0.05

    @copyright_label = Images.new((Window.width - _copyright_label.width) * 0.5,
                                       (Window.height - _copyright_label.height) * 0.9,
                                       _copyright_label.width, _copyright_label.height)
    @copyright_label.image = _copyright_label.to_image
    _copyright_label.vanish

    shortcut_message_sizes = [Window.height * 0.42, Window.height * 0.2]
    @shortcut_message = Images.new((Window.width - shortcut_message_sizes[0]) * 0.04,
                                  (Window.height - shortcut_message_sizes[1]) * 0.77,
                                  shortcut_message_sizes[0], shortcut_message_sizes[1], "", 0, [128] + C_CREAM)
    @shortcut_message.string =
      "ESC: ɃQ[I\nE: I_CAOJ\nW: tXN[ON/OFF\nX: ͂ON/OFF\nP: XN[Vbg"

    @shortcut_message.font_size = @shortcut_message.height * 0.19
    @shortcut_message.font_name = "07mxPOP"
    @shortcut_message.set_string_pos(@shortcut_message.width * 0.02, @shortcut_message.height * 0.02)
    @shortcut_message.frame(C_CUD_ACCENT_BROWN, @shortcut_message.height * 0.02)

    ranking_font = Fonts.new(0, 0, "LO TOP100", Window.height * 0.04, C_CUD_ACCENT_BLUE,
                             {:font_name=>"`FbN|CgtHg"})
    ranking_font.shadow = false
    ranking_font.edge = true
    ranking_font.edge_width = ranking_font.height * 0.05
    @ranking_button = Button.new(0, 0, ranking_font.width, ranking_font.height)
    @ranking_button.set_image(ranking_font.to_image)
    ranking_font.vanish
    @ranking_button.set_pos((Window.width - @ranking_button.width) * 0.5, (Window.height - @ranking_button.height) * 0.6)


    start_font = Fonts.new(0, 0, "͂߂", Window.height * 0.1, C_CUD_ACCENT_ORANGE,
                             {:font_name=>"CJhL"})
    start_font.shadow = false
    start_font.edge = true
    start_font.edge_width = start_font.height * 0.05
    @start_button = Button.new(0, 0, start_font.width, start_font.height)
    @start_button.set_image(start_font.to_image)
    start_font.vanish
    @start_button.set_pos((Window.width - @start_button.width) * 0.5, (Window.height - @start_button.height) * 0.73)

    setting_button_image = Image.load(SETTING_BUTTON_IMAGE)
    setting_button_scale = Window.height * 0.2 / setting_button_image.height
    setting_button_converted_image = Images.scale_resize(setting_button_image, setting_button_scale, setting_button_scale)

    setting_button_string = "ݒ"
    setting_button_font_size = setting_button_converted_image.height * 0.24
    setting_button_string_pos = [
      (setting_button_converted_image.width - (setting_button_string.size * 0.5 * setting_button_font_size)) * 0.56,
      (setting_button_converted_image.height - setting_button_font_size) * 0.63]

    @setting_button = Button.new(0, 0, setting_button_converted_image.width, setting_button_converted_image.height,
                                 setting_button_string, setting_button_font_size, :str_color=>C_CUD_NON_COLORED_WHITE,
                                 :font_name=>"07mxPOP", :str_pos=>setting_button_string_pos, :str_centering=>false)
    @setting_button.set_image(setting_button_converted_image)
    @setting_button.set_pos((Window.width - @start_button.width) * 0.94, (Window.height - @start_button.height) * 0.7)

    credit_font = Fonts.new(0, 0, "NWbg", Window.height * 0.05, C_CUD_ACCENT_PURPLE, {:font_name=>"07mxPOP"})
    credit_font.shadow = false
    credit_font.edge = true
    credit_font.edge_width = credit_font.height * 0.05
    @credit_button = Button.new(0, 0, credit_font.width, credit_font.height)
    @credit_button.set_image(credit_font.to_image)
    credit_font.vanish
    @credit_button.set_pos((Window.width - @credit_button.width) * 0.9, (Window.height - @credit_button.height) * 0.6)

    exit_button_image = Image.load(EXIT_BUTTON_IMAGE)
    exit_button_scale = Window.height * 0.05 / exit_button_image.height
    exit_button_converted_image = Images.scale_resize(exit_button_image, exit_button_scale, exit_button_scale)
    @exit_button = Button.new
    @exit_button.set_image(exit_button_converted_image)
    @exit_button.set_string("", exit_button_converted_image.height * 0.6,
                              "07mxPOP", {:color=>C_CUD_NON_COLORED_BLACK})
    @exit_button.set_pos(Window.width - @exit_button.width, 0)

    setting_dialog_height = Window.height * 0.8
    setting_dialog_width = setting_dialog_height * 1.3
    setting_dialog_option = {:frame_thickness=>(setting_dialog_height * 0.02).round, :radius=>setting_dialog_height * 0.03,
                             :bg_color=>C_CUD_NON_COLORED_LIGHT_GRAY, :frame_color=>C_CUD_NON_COLORED_GRAY,
                             :default_font_name=>"07mxPOP", :number_font_name=>"Phenomena"}

    @setting_dialog = SettingDialog.new(0, 0, setting_dialog_width, setting_dialog_height, setting_dialog_option)
    @setting_dialog.set_pos((Window.width - @setting_dialog.width) * 0.5,  -1 * @setting_dialog.height)
    @setting_dialog.is_active = false
    @setting_dialog.is_viewable = false
    @setting_dialog_move_time = 0
    @setting_dialog_move_direction = :down

    @setting_dialog.hilight_check_box.is_checked = $config.hilighted
    @setting_dialog.heatmap_check_box.is_checked = true if $config.heatmap_type == :heatmap
    @setting_dialog.heatmap_check_box.is_checked = false if $config.heatmap_type == :pointmap
    @setting_dialog.ranking_check_box.is_checked = $config.is_ranking

    credit_height = Window.height * 0.6
    credit_width = credit_height * (16 / 9.to_f)

    @credit = Credit.new(0, 0, credit_width, credit_height, CREDIT_IMAGE_FILE)
    @credit.set_pos(-1 *  @credit.width, (Window.height - @credit.height) * 0.5)
    @credit.is_active = false
    @credit.is_viewable = false
    @credit_move_time = 0
    @credit_move_direction = :right

    exit_message_dialog_height = Window.height * 0.4
    exit_message_dialog_width = exit_message_dialog_height * 2
    exit_message_dialog_option = {:frame_thickness=>exit_message_dialog_height * 0.04,
                                  :radius=>exit_message_dialog_height * 0.06,
                                  :bg_color=>C_CREAM, :frame_color=>C_CUD_ACCENT_ORANGE}

    @exit_message_dialog = MessageDialog.new(0, 0, exit_message_dialog_width, exit_message_dialog_height,
                                               1, exit_message_dialog_option)
    @exit_message_dialog.set_message("AvI܂H", "",
                                       @exit_message_dialog.height * 0.15, C_CUD_ACCENT_BROWN, "݂")
    @exit_message_dialog.set_pos((Window.width - @exit_message_dialog.width) * 0.5,
                                   (Window.height - @exit_message_dialog.height) * 0.5)

    @exit_message_dialog.ok_button.font_color = C_CUD_NON_COLORED_BLACK
    @exit_message_dialog.ok_button.font_name = "07mxPOP"
    @exit_message_dialog.ok_button.name = "exit_ok_button"

    @exit_message_dialog.cancel_button.font_color = C_CUD_NON_COLORED_BLACK
    @exit_message_dialog.cancel_button.font_name = "07mxPOP"
    @exit_message_dialog.cancel_button.name = "exit_cancel_button"

    exit_ok_button_image = Image.load(OK_BUTTON_IMAGE)
    @exit_message_dialog.ok_button.set_image(
      Images.fit_resize(exit_ok_button_image, @exit_message_dialog.ok_button.width,
                        @exit_message_dialog.ok_button.height))

    exit_cancel_button_image = Image.load(CANCEL_BUTTON_IMAGE)
    @exit_message_dialog.cancel_button.set_image(Images.fit_resize(
      exit_cancel_button_image, @exit_message_dialog.cancel_button.width, @exit_message_dialog.cancel_button.height))

    @is_exitable = false

    @base_buttons = [@start_button, @ranking_button, @credit_button, @setting_button]
    @setting_buttons = [@setting_dialog.close_button, @setting_dialog.hilight_check_box,
                        @setting_dialog.heatmap_check_box, @setting_dialog.ranking_check_box,
                        @setting_dialog.time_up_button, @setting_dialog.time_down_button,
                        @setting_dialog.test_button, @setting_dialog.connect_button]
    @exit_buttons = [@exit_message_dialog.ok_button, @exit_message_dialog.cancel_button]
    @buttons = [@exit_button] + @base_buttons + @setting_buttons + @exit_buttons + [@credit.close_button]

    @is_start_button_blink = false
    @start_button_blink_count = 0
    @wait_stage_change_count = 0.0

    @cover_layer = Image.new(Window.width, Window.height, [196, 128, 128, 128])
    @mouse = Sprite.new
    @mouse.collision = [0, 0]

    @poi = Poi.new(0, 0, nil, Window.height * POI_HEIGHT_SIZE_RATIO, :click, @mouse,
                   MAX_GAZE_COUNT, self, nil, true, {:max_count_in_window=>MAX_COUNT_IN_WINDOW,
                                               :gaze_radius_ratio=>POI_GAZE_RADIUS_RATIO,
                                               :max_count_in_gaze_area=>MAX_COUNT_IN_GAZE_AREA})
    @poi.set_pos((Window.width - @poi.width) * 0.5, (Window.height - @poi.height) * 0.5)

    $config.vibeman.parent = self

    @setting_dialog.time_input_box.string = $config.vibeman.vibe_time.to_s
    self.callback_output($config.vibeman.output)
  end

  def callback_output(output)

    unless output == "" then
      @setting_dialog.output_box.string = output

      if $config.vibeman.is_connecting then

        @setting_dialog.connect_button.string = "ؒf"
        @setting_dialog.connect_button.enable = true
        @setting_dialog.test_button.enable = true
        $config.vibeman.is_connecting = true

      elsif
        @setting_dialog.connect_button.string = "ڑ"
        @setting_dialog.connect_button.enable = true
        @setting_dialog.test_button.enable = false
        $config.vibeman.is_connecting = false
      end
    else
      @setting_dialog.output_box.string = "EyeMotBox͈\nڑĂ܂c"
      @setting_dialog.connect_button.enable = true unless @setting_dialog.connect_button.is_enable
    end
  end

  # oCu}ڑs
  def challenge_connect_to_vibeman

    unless $config.vibeman.is_connecting then
      @setting_dialog.output_box.string = "ڑc"
      Thread.new do
        $config.vibeman.connect
      end
    else
      @setting_dialog.output_box.string = "ؒfc"
      Thread.new do
        $config.vibeman.disconnect
      end
    end
  end

  def update

    if Input.key_release?(K_ESCAPE) then
      $config.eyemot_mouse.close
      exit
    end

    if Input.key_release?(K_W) then
      if Window.windowed? then
        Window.windowed = false
      else
        Window.windowed = true
      end
      @click_se.play if @click_se
    end

    if Input.key_release?(K_X) then
      if not $config.eyemot_mouse.mode == :off then
        $config.eyemot_mouse.eye_off
      elsif $config.eyemot_mouse.mode == :off
        $config.eyemot_mouse.eye_on
      end
    end

    if Input.key_release?(K_P) then
      $config.log.screen_shot("screen_shot_#{$config.screen_shot_count}.png")
      $config.screen_shot_count += 1
      @screen_shot_se.play if @screen_shot_se
    end

    @exit_button.hovered?
    if (@exit_button and not @is_exitable and
      (@exit_button.pushed? or @exit_button.is_auto_clicked)) or Input.key_release?(K_E) then
      @exit_button.is_auto_clicked = false

      @click_se.play if @click_se
      @is_exitable = true
    end

    @ranking_button.enable = false unless $config.is_ranking

    if not @is_exitable and @setting_dialog and @credit then

      @exit_button.enable = true
      @exit_message_dialog.ok_button.enable = false if @exit_message_dialog.ok_button.is_enable
      @exit_message_dialog.cancel_button.enable = false if @exit_message_dialog.cancel_button.is_enable

      if not @setting_dialog.is_viewable and not @credit.is_viewable then

        @setting_button.enable = true
        @start_button.enable = true
        @ranking_button.enable = true if $config.is_ranking
        @credit_button.enable = true

        @base_buttons.each do |button|
          button.hovered? if button.is_hoverable
        end

        if @start_button and (@start_button.pushed? or @start_button.is_auto_clicked) then
          @start_button.is_auto_clicked = false
          @is_start_button_blink = true unless @is_start_button_blink
          @start_button.hover = false if @start_button.is_hoverable
          @start_game_se.play
          @wait_stage_change_count = 0
        end

        if @is_start_button_blink then
          if @start_button_blink_count >= 10 then
            @start_button.blink
            @start_button_blink_count = 0
          else
            @start_button_blink_count += 1
          end
          if @wait_stage_change_count >= 150 then
            self.next_scene = GameScene
            @wait_stage_change_count = 0
          else
            @wait_stage_change_count += 1
          end
        end

        if $config.is_ranking then
          if (@ranking_button and (@ranking_button.pushed? or @ranking_button.is_auto_clicked)) then

            @ranking_button.is_auto_clicked = false
            @click_se.play if @click_se
            self.next_scene = RankingScene
          end
        end

        if @setting_button and (@setting_button.pushed? or @setting_button.is_auto_clicked) then
          @setting_button.is_auto_clicked = false
          @setting_dialog.is_viewable = true
          @click_se.play if @click_se
        end

        if @credit_button and (@credit_button.pushed? or @credit_button.is_auto_clicked) then
          @credit_button.is_auto_clicked = false
          @credit.is_viewable = true
          @click_se.play if @click_se
        end

      elsif (@setting_dialog.is_viewable and not @credit.is_viewable) or
        (not @setting_dialog.is_viewable and @credit.is_viewable)

        @setting_button.enable = false
        @start_button.enable = false
        @ranking_button.enable = false if $config.is_ranking
        @credit_button.enable = false

        if not @credit.is_viewable then
          if @setting_dialog.is_active then

            @setting_dialog.hilight_check_box.enable = true
            @setting_dialog.heatmap_check_box.enable = true
            @setting_dialog.ranking_check_box.enable = true
            @setting_dialog.close_button.enable = true
            @setting_dialog.time_up_button.enable = true
            @setting_dialog.time_down_button.enable = true
            # @setting_dialog.test_button.enable = true
            # @setting_dialog.connect_button.enable = true

            @setting_buttons.each do |button|
              button.hovered? if button.is_hoverable
            end

            if @setting_dialog.hilight_check_box and
              (@setting_dialog.hilight_check_box.clicked? or @setting_dialog.hilight_check_box.is_auto_clicked) then

              @setting_dialog.hilight_check_box.is_auto_clicked = false
              $config.hilighted = @setting_dialog.hilight_check_box.is_checked
              @click_se.play if @click_se
            end

            if @setting_dialog.heatmap_check_box and
              (@setting_dialog.heatmap_check_box.clicked? or @setting_dialog.heatmap_check_box.is_auto_clicked) then

              @setting_dialog.heatmap_check_box.is_auto_clicked = false
              $config.heatmap_type = :heatmap if @setting_dialog.heatmap_check_box.is_checked
              $config.heatmap_type = :pointmap unless @setting_dialog.heatmap_check_box.is_checked
              @click_se.play if @click_se
            end

            if @setting_dialog.ranking_check_box and
              (@setting_dialog.ranking_check_box.clicked? or @setting_dialog.ranking_check_box.is_auto_clicked) then

              @setting_dialog.ranking_check_box.is_auto_clicked = false
              $config.is_ranking = @setting_dialog.ranking_check_box.is_checked
              @click_se.play if @click_se
            end

            if @setting_dialog.close_button and
              (@setting_dialog.close_button.pushed? or @setting_dialog.close_button.is_auto_clicked) then

              @setting_dialog.close_button.is_auto_clicked = false
              @setting_dialog.is_active = false
              @click_se.play if @click_se
            end

            if @setting_dialog.time_up_button and
              (@setting_dialog.time_up_button.pushed? or @setting_dialog.time_up_button.is_auto_clicked) then
              @setting_dialog.time_up_button.is_auto_clicked = false

              if $config.vibeman.vibe_time < 10000 then
                $config.vibeman.vibe_time += 50
                @setting_dialog.time_input_box.string = $config.vibeman.vibe_time.to_s
                @click_se.play if @click_se
              end
            end

            if @setting_dialog.time_down_button and
              (@setting_dialog.time_down_button.pushed? or @setting_dialog.time_down_button.is_auto_clicked) then
              @setting_dialog.time_down_button.is_auto_clicked = false

              if $config.vibeman.vibe_time >= 50 then
                $config.vibeman.vibe_time -= 50
                @setting_dialog.time_input_box.string = $config.vibeman.vibe_time.to_s
                @click_se.play if @click_se
              end
            end

            if @setting_dialog.test_button and
              (@setting_dialog.test_button.pushed? or @setting_dialog.test_button.is_auto_clicked) then
              @setting_dialog.test_button.is_auto_clicked = false

              if $config.vibeman.is_connecting then
                @setting_dialog.output_box.string = "݁AeXgc"
                Thread.new do
                  $config.vibeman.vibe
                end
              end
              @click_se.play if @click_se
            end

            if @setting_dialog.connect_button and
              (@setting_dialog.connect_button.pushed? or @setting_dialog.connect_button.is_auto_clicked) then
              @setting_dialog.connect_button.is_auto_clicked = false

              @setting_dialog.connect_button.enable = false if @setting_dialog.connect_button.is_enable
              self.challenge_connect_to_vibeman
              @click_se.play if @click_se
            end
          else
            @setting_dialog.hilight_check_box.enable = false
            @setting_dialog.heatmap_check_box.enable = false
            @setting_dialog.ranking_check_box.enable = false
            @setting_dialog.close_button.enable = false
            @setting_dialog.time_up_button.enable = false
            @setting_dialog.time_down_button.enable = false
            # @setting_dialog.test_button.enable = false
            # @setting_dialog.connect_button.enable = false

            if @setting_dialog_move_direction == :down then
              if @setting_dialog_move_time <= 1.0 then
                pos_y = ease_in_out_quad(@setting_dialog_move_time, -1 * @setting_dialog.height,
                                         (@setting_dialog.height + Window.height) * 0.5, 1.0)
                @setting_dialog.set_pos((Window.width - @setting_dialog.width) * 0.5, pos_y)
                @setting_dialog_move_time += 0.01
              else
                @setting_dialog.set_pos((Window.width - @setting_dialog.width) * 0.5,
                                        (Window.height - @setting_dialog.height) * 0.5)
                @setting_dialog_move_time = 0
                @setting_dialog_move_direction = :up
                @setting_dialog.is_active = true
              end
            elsif @setting_dialog_move_direction == :up then
              if @setting_dialog_move_time <= 1.0 then
                pos_y = ease_in_out_quad(@setting_dialog_move_time, (Window.height - @setting_dialog.height) * 0.5,
                                         (@setting_dialog.height + Window.height) * -0.503, 1.0)
                @setting_dialog.set_pos((Window.width - @setting_dialog.width) * 0.5, pos_y)
                @setting_dialog_move_time += 0.01
              else
                @setting_dialog.set_pos((Window.width - @setting_dialog.width) * 0.5, -1 * @setting_dialog.height)
                @setting_dialog_move_time = 0
                @setting_dialog_move_direction = :down
                @setting_dialog.is_active = false
                @setting_dialog.is_viewable = false
              end
            end
          end
        end

        if not @setting_dialog.is_viewable then
          if @credit.is_active then

            @credit.close_button.enable = true
            @credit.close_button.hovered? if @credit.close_button.is_hoverable

            if @credit.close_button and
              (@credit.close_button.pushed? or @credit.close_button.is_auto_clicked) then

              @credit.close_button.is_auto_clicked = false
              @credit.is_active = false
              @click_se.play if @click_se
            end
          else
            @credit.close_button.enable = false

            if @credit_move_direction == :right then
              if @credit_move_time <= 1.0 then
                pos_x = ease_in_out_quad(@credit_move_time, -1 * @credit.width,
                                         (@credit.width + Window.width) * 0.5, 1.0)
                @credit.set_pos(pos_x, (Window.height - @credit.height) * 0.5)
                @credit_move_time += 0.01
              else
                @credit.set_pos((Window.width - @credit.width) * 0.5, (Window.height - @credit.height) * 0.5)
                @credit_move_time = 0
                @credit_move_direction = :left
                @credit.is_active = true
              end
            elsif @credit_move_direction == :left then
              if @credit_move_time <= 1.0 then
                pos_x = ease_in_out_quad(@credit_move_time, (Window.width - @credit.width) * 0.5,
                                         (@credit.width + Window.width) * -0.503, 1.0)
                @credit.set_pos(pos_x, (Window.height - @credit.height) * 0.5)
                @credit_move_time += 0.01
              else
                @credit.set_pos(-1 * @credit.width, (Window.height - @credit.height) * 0.5)
                @credit_move_time = 0
                @credit_move_direction = :right
                @credit.is_active = false
                @credit.is_viewable = false
              end
            end
          end
        end
      end
    else
      @setting_dialog.hilight_check_box.enable = false
      @setting_dialog.heatmap_check_box.enable = false
      @setting_dialog.ranking_check_box.enable = false
      @setting_dialog.close_button.enable = false
      @setting_dialog.time_up_button.enable = false
      @setting_dialog.time_down_button.enable = false
      # @setting_dialog.test_button.enable = false
      # @setting_dialog.connect_button.enable = false

      @credit.close_button.enable = false

      @setting_button.enable = false if @setting_button.is_enable
      @start_button.enable = false if @start_button.is_enable
      @ranking_button.enable = false if $config.is_ranking
      @credit_button.enable = false if @credit_button.is_enable

      @exit_message_dialog.ok_button.enable = true unless @exit_message_dialog.ok_button.is_enable
      @exit_message_dialog.cancel_button.enable = true unless @exit_message_dialog.cancel_button.is_enable

      @exit_buttons.each do |button|
        button.hovered? if button.is_hoverable
      end

      if @exit_message_dialog then

        if @exit_message_dialog.ok_button.pushed? or @exit_message_dialog.ok_button.is_auto_clicked then
          @exit_message_dialog.ok_button.is_auto_clicked = false
          $config.eyemot_mouse.close
          exit
        end
        if @exit_message_dialog.cancel_button.pushed? or @exit_message_dialog.cancel_button.is_auto_clicked then
          @exit_message_dialog.cancel_button.is_auto_clicked = false

          @click_se.play if @click_se
          @is_exitable = false
        end
      end
      @exit_button.enable = false
    end
    @mouse.x, @mouse.y = Input.mouse_pos_x, Input.mouse_pos_y if @mouse
    @poi.update if @poi
  end

  def gazed(x, y, center_x, center_y)

    if @buttons and not @buttons.empty? then
      @buttons.each do |button|
        if button.is_enable then

          if x + center_x >= button.x and x + center_x <= button.x + button.width and
            y + center_y >= button.y and y + center_y <= button.y + button.height then

            button.auto_click if button.class == CheckBox
            button.is_auto_clicked = true
          else
            button.is_auto_clicked = false
          end
        end
      end
    end
    @poi.mode = :search
  end

  def render

    Window.draw(0, 0, @background_image) if @background_image

    @title_label.draw if @title_label
    @sub_title_label.draw if @sub_title_label
    @version_number_label.draw if @version_number_label
    @copyright_label.draw if @copyright_label

    @shortcut_message.draw if @shortcut_message
    @credit_button.draw if @credit_button

    @ranking_button.draw if @ranking_button and $config.is_ranking
    @start_button.draw if @start_button
    @setting_button.draw if @setting_button

    @exit_button.draw if @exit_button and @is_exitable

    Window.draw(0, 0, @cover_layer) if @cover_layer and not @is_exitable and
      (@setting_dialog.is_viewable or @credit.is_viewable)

    @setting_dialog.draw if @setting_dialog and @setting_dialog.is_viewable
    @credit.draw if @credit and @credit.is_viewable

    Window.draw(0, 0, @cover_layer) if @cover_layer and @is_exitable

    @exit_message_dialog.draw if @exit_message_dialog and @is_exitable

    @exit_button.draw if @exit_button unless @is_exitable

    @poi.draw if @poi
  end

  def will_disappear
  end
end


# Q[EV[
class GameScene < Scene::Base

  require "rubygems"
  require "bigdecimal"

  require "./lib/dxruby/fonts"
  require "./lib/dxruby/images"
  require "./lib/dxruby/button"
  require "./lib/dxruby/color"
  require "./lib/common"
  require "./lib/encode" # R[hϊ

  require "./scripts/border"
  require "./scripts/kingyo"
  require "./scripts/poi"
  require "./scripts/container"
  require "./scripts/weed"
  require "./scripts/boss"
  require "./scripts/bgm_info"
  require "./scripts/alert"
  require "./scripts/splash"
  require "./scripts/SampleMapping"
  require "./scripts/gauge"
  require "./scripts/heatmap"

  include Common
  include Color
  include Heatmap

  CLICK_SE = "./sounds/meka_ge_mouse_s02.wav"
  SCREEN_SHOT_SE = "./sounds/Camera-Phone01-1.wav"
  MAIN_BGM = "./sounds/minamo.mp3"
  ALERT_BGM = "./sounds/nc40157.wav"
  BOSS_BGM = "./sounds/boss_panic_big_march.mp3"
  SPLASH_SMALL_SE = "./sounds/water-drop3.wav"
  SPLASH_RARGE_SE = "./sounds/water-throw-stone2.wav"
  CHANGE_STAGE_SE = "./sounds/sei_ge_bubble06.wav"

  OK_BUTTON_IMAGE = "./images/m_4.png"
  RETURN_TO_TITLE_BUTTON_IMAGE = "./images/s_3.png"
  CANCEL_BUTTON_IMAGE = "./images/m_1.png"
  STONE_TILE_IMAGE = "./images/stone_tile.png"
  AQUARIUM_BACK_IMAGE = "./images/seamless-water.jpg"

  MAX_COUNT_IN_WINDOW = 60
  MAX_COUNT_IN_GAZE_AREA = 30

  POI_HEIGHT_SIZE_RATIO = 0.35
  MAX_GAZE_COUNT = 40
  POI_GAZE_RADIUS_RATIO = 0.5

  POI_IS_IMPACT = true
  POI_IS_VIEW_IMPACT_RANGE = false

  FIRST_STAGE_NUMBER = 1
  FIRST_MODE = :start
  MAX_STAGE_NUMBER = 3

  IMPACT_GAINS = [1.0, 2.0, 3.0]

  KINGYO_NUMBERS = [5, 15, 30]
  KINGYO_SCALE_RANGES = [[0.1, 0.15], [0.1, 0.2], [0.1, 0.25]]

  KINGYO_SPEED_RANGES = [{:wait=>[1, 2], :move=>[1, 2], :escape=>[2, 4]},
                         {:wait=>[1, 4], :move=>[1, 4], :escape=>[2, 8]},
                         {:wait=>[1, 6], :move=>[1, 6], :escape=>[2, 12]}]

  KINGYO_MODE_RANGES = [{:wait=>[90, 720], :move=>[30, 180], :escape=>[30, 180]},
                        {:wait=>[60, 360], :move=>[60, 360], :escape=>[60, 360]},
                        {:wait=>[30, 180], :move=>[90, 720], :escape=>[90, 720]}]

  KINGYO_PERSONALITY_WEIGHTS = [{:escape=>50, :ignore=>50, :against=>10},
                               {:escape=>60, :ignore=>30, :against=>20},
                               {:escape=>80, :ignore=>10, :against=>30}]

  KINGYO_ESCAPE_CHANGE_TIMINGS = [0.4, 0.3, 0.2]

  KIND_OF_KINGYOS = [:red, :black]

  BOSS_SCALE_RANGES = [0.3, 0.7]
  BOSS_SPEED_RANGES = {:wait=>[1, 2], :move=>[1, 2], :escape=>[2, 4]}
  BOSS_MODE_RANGES = {:wait=>[20, 200], :move=>[20, 200], :escape=>[20, 200]}
  BOSS_PERSONALITY_WEIGHTS = {:escape=>10, :ignore=>30, :against=>80}
  BOSS_ESCAPE_CHANGE_TIMINGS = 0.3

  WEED_NUMBERS = [2, 5, 8]
  WEED_SPEED_RANGES = {:escape=>[100, 200]}
  WEED_MODE_RANGES = {:escape=>[100, 200]}
  WEED_SCALE_RANGES = [[0.1, 0.3], [0.2, 0.4], [0.3, 0.5]]
  WEED_ESCAPE_CHANGE_TIMINGS = 0.3

  CONTAINER_SPEED_RANGES = {:escape=>[100, 200]}
  CONTAINER_MODE_RANGES = {:escape=>[100, 200]}
  CONTAINER_ESCAPE_CHANGE_TIMINGS = 0.3

  BASE_SCORES = {"red_kingyo"=>200, "black_kingyo"=>100, "weed"=>-300, "boss"=>5000}

  KINGYO_DAMAGE_UNIT_RATIO = 0.02
  WEED_DAMAGE_UNIT_RATIO = 0.2
  BOSS_DAMAGE_UNIT_RATIO = 0.05
  BUBBLE_SHOT_DAMAGE_UNIT_RATIO = 0.005

  CHALLENGE_POINT_UP_RANGE = 600
  MAX_POI_GAUGE_NUMBER = 5

  TILDE =  "\x81\x60".encode("BINARY")
  MAIN_BGM_DATA = ["", "Composed by iPad", "" + TILDE]
  BOSS_BGM_DATA = ["{XEpjbNsi", "Composed by iPad", "" + TILDE]
  MAIN_ALERT_STRING = "xI {XoI"
  SUB_ALERT_STRING = "WARNING!"

  Z_POSITION_TOP = 300
  Z_POSITION_UP = 200
  Z_POSITION_DOWN = 100
  Z_POSITION_BOTTOM = 0

  POI_CATCH_ADJUST_RANGE_RATIO = 1.0

  CONTAINER_CATCH_ADJUST_RANGE_RATIO = 1.0
  CONTAINER_RESERVE_ADJUST_RANGE_RATIO = 0.55
  CONTAINER_CONTACT_ADJUST_RANGE_RATIO = 1.2

  START_MAX_COUNT = 180
  BREAK_MAX_COUNT = 240
  POINT_LABEL_MOVE_SCALE = 5.0

  HEATMAP_POINT_SIZE_RATIO = 0.05
  POINTMAP_POINT_SIZE_RATIO = 0.02
  
  def init

    $config.play_count += 1

    @click_se = Sound.new(CLICK_SE)
    @screen_shot_se = Sound.new(SCREEN_SHOT_SE)
    @change_stage_se = Sound.new(CHANGE_STAGE_SE)
    @splash_small_se = Sound.new(SPLASH_SMALL_SE)
    @splash_rarge_se = Sound.new(SPLASH_RARGE_SE)

    @main_bgm = Bass.loadSample(MAIN_BGM)
    @alert_bgm = Bass.loadSample(ALERT_BGM)
    @boss_bgm = Bass.loadSample(BOSS_BGM)

    return_to_title_button_image = Image.load(RETURN_TO_TITLE_BUTTON_IMAGE)
    return_to_title_button_scale = Window.height * 0.05 / return_to_title_button_image.height
    return_to_title_button_converted_image =
      Images.scale_resize(return_to_title_button_image, return_to_title_button_scale, return_to_title_button_scale)

    @return_to_title_button = Button.new
    @return_to_title_button.set_image(return_to_title_button_converted_image)
    @return_to_title_button.set_string("", return_to_title_button_converted_image.height * 0.6,
                              "07mxPOP", {:color=>C_CUD_NON_COLORED_BLACK})
    @return_to_title_button.set_pos(Window.width - @return_to_title_button.width, 0)
    @return_to_title_button.name = "return_to_title_button"
    @return_to_title_button.z = Z_POSITION_TOP

    return_to_title_message_dialog_height = Window.height * 0.4
    return_to_title_message_dialog_width = return_to_title_message_dialog_height * 2
    return_to_title_message_dialog_option = {:frame_thickness=>return_to_title_message_dialog_height * 0.04,
                                             :radius=>return_to_title_message_dialog_height * 0.06,
                                             :bg_color=>C_CREAM, :frame_color=>C_CUD_ACCENT_ORANGE}

    @return_to_title_message_dialog = MessageDialog.new(0, 0, return_to_title_message_dialog_width,
                                                        return_to_title_message_dialog_height, 1,
                                                        return_to_title_message_dialog_option)
    @return_to_title_message_dialog.set_message("^Cgɖ߂܂H", "",
                                       @return_to_title_message_dialog.height * 0.15, C_CUD_ACCENT_BROWN, "݂")
    @return_to_title_message_dialog.set_pos((Window.width - @return_to_title_message_dialog.width) * 0.5,
                                   (Window.height - @return_to_title_message_dialog.height) * 0.5)
    @return_to_title_message_dialog.z = Z_POSITION_TOP

    @return_to_title_message_dialog.ok_button.font_color = C_CUD_NON_COLORED_BLACK
    @return_to_title_message_dialog.ok_button.font_name = "07mxPOP"
    @return_to_title_message_dialog.ok_button.name = "return_to_title_ok_button"
    @return_to_title_message_dialog.ok_button.z = Z_POSITION_TOP

    @return_to_title_message_dialog.cancel_button.font_color = C_CUD_NON_COLORED_BLACK
    @return_to_title_message_dialog.cancel_button.font_name = "07mxPOP"
    @return_to_title_message_dialog.cancel_button.name = "return_to_title_cancel_button"
    @return_to_title_message_dialog.cancel_button.z = Z_POSITION_TOP

    ok_button_image = Image.load(OK_BUTTON_IMAGE)
    @return_to_title_message_dialog.ok_button.set_image(
      Images.fit_resize(ok_button_image, @return_to_title_message_dialog.ok_button.width,
                        @return_to_title_message_dialog.ok_button.height))

    cancel_button_image = Image.load(CANCEL_BUTTON_IMAGE)
    @return_to_title_message_dialog.cancel_button.set_image(Images.fit_resize(
      cancel_button_image, @return_to_title_message_dialog.cancel_button.width,
      @return_to_title_message_dialog.cancel_button.height))

    @is_returnable = false

    @buttons = [@return_to_title_button, @return_to_title_message_dialog.ok_button,
                @return_to_title_message_dialog.cancel_button]

    unless $config.hilighted then

      stone_tile_image = Image.load(STONE_TILE_IMAGE)
      stone_tile_image_scale = Window.height * 0.3 / stone_tile_image.height
      stone_tile_converted_image = Images.scale_resize(stone_tile_image, stone_tile_image_scale, stone_tile_image_scale)
      stone_tile_rt = RenderTarget.new(Window.width, Window.height)
      stone_tile_rt.drawTile(0, 0, [[0]], [stone_tile_converted_image], nil, nil, nil, nil)
      @stone_tile_image = stone_tile_rt.to_image
      stone_tile_converted_image.dispose
      stone_tile_rt.dispose

      aquarium_back_image = Image.load(AQUARIUM_BACK_IMAGE)
      aquarium_back_image_scale = Window.height * 0.15 / aquarium_back_image.height
      aquarium_back_converted_image = Images.scale_resize(aquarium_back_image, aquarium_back_image_scale,
                                                          aquarium_back_image_scale)
      aquarium_back_rt = RenderTarget.new(Window.width, Window.height)
      aquarium_back_rt.drawTile(0, 0, [[0]], [aquarium_back_converted_image], nil, nil, nil, nil)
      @aquarium_back_image = aquarium_back_rt.to_image
      aquarium_back_converted_image.dispose
      aquarium_back_rt.dispose
    end

    @wave_shader = SampleMappingShader.new
    @shader_rt = RenderTarget.new(Window.width, Window.height)

    @_stage_info_label = Fonts.new(0, 0, "###", Window.height * 0.2, C_CUD_ACCENT_BROWN, {:font_name=>"07mxPOP"})

    @stage_info_label = Images.new((Window.width - @_stage_info_label.width) * 0.5,
                                   (Window.height - @_stage_info_label.height) * 0.5,
                                   @_stage_info_label.width, @_stage_info_label.height)
    @stage_info_label.z = Z_POSITION_TOP

    @_score_label = Fonts.new(0, 0, "SCORE : #{$config.scores[:score]}_", Window.height * 0.05, C_CUD_ACCENT_GREEN,
                             {:font_name=>"R̗tHg"})
    @_score_label.edge = true
    @_score_label.edge_width = @_score_label.height * 0.05

    @score_label = Images.new((Window.width - @_score_label.width) * 0.01, (Window.height - @_score_label.height) * 0.01,
                              @_score_label.width, @_score_label.height)
    @score_label.image = @_score_label.to_image
    @score_label.z = Z_POSITION_TOP

    @_wait_label = Fonts.new(0, 0, "΂炭܂", Window.height * 0.05, C_CUD_ACCENT_PURPLE,
                              {:font_name=>"07mxPOP"})
    @_wait_label.edge = true
    @_wait_label.edge_width = @_wait_label.height * 0.05

    @wait_label = Images.new((Window.width - @_wait_label.width) * 0.5, (Window.height - @_wait_label.height) * 0.7,
                              @_wait_label.width, @_wait_label.height)
    @wait_label.image = @_wait_label.to_image
    @wait_label.z = Z_POSITION_TOP

    @border = Border.new(0, 0, Window.width, Window.height)

    @container = Container.new(0, 0, nil, Window.height * 0.4,
                               { :escape=>[CONTAINER_SPEED_RANGES[:escape][0],
                                           CONTAINER_SPEED_RANGES[:escape][1]]},
                               {:escape=>[CONTAINER_MODE_RANGES[:escape][0],
                                          CONTAINER_MODE_RANGES[:escape][1]]}, CONTAINER_ESCAPE_CHANGE_TIMINGS)

    @container.set_pos(rand_float(@border.x, @border.x + @border.width - @container.width),
                       rand_float(@border.y, @border.y + @border.height - @container.height))
    @container.z = Z_POSITION_DOWN

    @mouse = Sprite.new
    @mouse.collision = [0, 0]

    @poi = Poi.new(0, 0, nil, Window.height * POI_HEIGHT_SIZE_RATIO, :scooping, @mouse,
                   MAX_GAZE_COUNT, self, @container, false, {:max_count_in_window=>MAX_COUNT_IN_WINDOW,
                                         :gaze_radius_ratio=>POI_GAZE_RADIUS_RATIO,
                                                      :max_count_in_gaze_area=>MAX_COUNT_IN_GAZE_AREA})
    @poi.set_pos((Window.width - @poi.width) * 0.5, (Window.height - @poi.height) * 0.5)
    @poi.z = Z_POSITION_TOP

    @poi.is_impact = POI_IS_IMPACT
    @poi.view_impact_range = POI_IS_VIEW_IMPACT_RANGE

    bgm_info_height = Window.height * 0.15
    bgm_info_width = bgm_info_height * 2.7
    @bgm_info = BgmInfo.new(Window.width, Window.height * 0.08, bgm_info_width, bgm_info_height)
    @bgm_info.initial_velocity = -1 * Math.sqrt(Window.height * 8.7)
    @bgm_info.z = Z_POSITION_TOP

    life_gauge_width = Window.width * 0.75
    life_gauge_height = Window.height * 0.02
    @life_gauge = LifeGauge.new(life_gauge_width, life_gauge_height)
    @life_gauge.set_pos((Window.width - @life_gauge.width) * 0.2, (Window.height - @life_gauge.height) * 0.95)
    @life_gauge.z = Z_POSITION_UP
    @life_continueble = true

    poi_gauge_height_size = Window.height * 0.1
    poi_gauge_interval = Window.width * 0.023

    @poi_gauges = []
    MAX_POI_GAUGE_NUMBER.times do |index|
      poi_gauge = PoiGage.new(nil, poi_gauge_height_size)
      poi_gauge.set_pos((Window.width - poi_gauge.width) * 0.85 + (poi_gauge_interval * index),
                        (Window.height - poi_gauge.height) * 0.96)
      poi_gauge.z = Z_POSITION_UP
      @poi_gauges.push(poi_gauge)
    end
    @poi_gauges.reverse!

    @cover_layer = Image.new(Window.width, Window.height, [196, 128, 128, 128])

    @alert = Alert.new(0, 0, Window.width, Window.height)
    @alert.z = Z_POSITION_TOP
    @alert.make_sub_alert(SUB_ALERT_STRING, "07mxPOP")
    @alert.make_main_alert(MAIN_ALERT_STRING, "`FbN|CgtHg")
    @alert.main_alert_speed = -1 * Math.sqrt(Window.height * 0.1)
    @alert.sub_alert_speed = Math.sqrt(Window.height * 0.1)

    @windows = []
    @swimmers = []
    @splashs = []
    @catch_objects = []
    @points = []

    @challenge_point = 0
    @start_count = 0
    @break_count = 0
    @end_count = 0
    @wait_count = 0

    @_wait_label.string = ""
    @stage_number = FIRST_STAGE_NUMBER

    @vibeman_is_rannable = true
    self.change_mode(FIRST_MODE)
  end

  def change_mode(mode)

    case mode

    when :start

      @change_stage_se.play if @change_stage_se
      self.stage_init

      if @_stage_info_label then

        @_stage_info_label.string = "Xe[W#{@stage_number}"
        @_stage_info_label.edge = true
        @_stage_info_label.edge_width = @_stage_info_label.height * 0.05

        @stage_info_label.image = @_stage_info_label.to_image
        @stage_info_label.set_pos((Window.width - @_stage_info_label.width) * 0.5,
                                  (Window.height - @_stage_info_label.height) * 0.5)
      end

    when :normal

      if  @stage_number == 1 then
        if @bgm then
          @bgm.stop
          @bgm = nil
        end
        if @main_bgm then
          @bgm = @main_bgm
          @bgm.play(:loop=>true, :volume=>0.5)
        end
        if @bgm_info then
          @bgm_info.set_info({:title=>MAIN_BGM_DATA[0], :data=>MAIN_BGM_DATA[1], :copyright=>MAIN_BGM_DATA[2]},
                             {:title=>"ʂ}WbN",
                              :data=>"ʂ}WbN", :copyright=>"ʂ}WbN"},
                             {:title=>@bgm_info.height * 0.3, :data=>@bgm_info.height * 0.2,
                              :copyright=>@bgm_info.height * 0.25})
          @bgm_info.mode = :run
        end
      end

    when :break

      self.set_wait_label
      self.set_heatmap
      self.save_log

    when :game_over

      if @bgm then
        @bgm.stop
        @bgm = nil
      end
      if @stage_info_label then

        @_stage_info_label.string = "Q[I[o["
        @_stage_info_label.color = C_CUD_BASE_CREAM
        @_stage_info_label.edge = true
        @_stage_info_label.edge_width = @_stage_info_label.height * 0.05

        @stage_info_label.image = @_stage_info_label.to_image
        @stage_info_label.set_pos((Window.width - @_stage_info_label.width) * 0.5,
                                  (Window.height - @_stage_info_label.height) * 0.5)
      end

      self.set_wait_label
      self.set_heatmap
      self.save_log

    when :game_clear

      if @bgm then
        @bgm.stop
        @bgm = nil
      end
      if @stage_info_label then

        @_stage_info_label.string = "Q[NA"
        @_stage_info_label.color = C_CUD_BASE_LIGHT_GREEN
        @_stage_info_label.edge = true
        @_stage_info_label.edge_width = @_stage_info_label.height * 0.05

        @stage_info_label.image = @_stage_info_label.to_image
        @stage_info_label.set_pos((Window.width - @_stage_info_label.width) * 0.5,
                                  (Window.height - @_stage_info_label.height) * 0.5)
      end

      self.set_wait_label
      self.set_heatmap
      self.save_log

    when :alert

      @alert.mode = :run if @alert

      if @bgm then
        @bgm.stop
        @bgm = nil
      end
      if @alert_bgm then
        @bgm = @alert_bgm
        @bgm.play(:loop=>true, :volume=>0.5)
      end

      self.boss_init

    when :boss

      if @swimmers.select { |obj| obj.class == Boss}.empty? then
        self.boss_init
      else
        bosss = @swimmers.select { |obj| obj.class == Boss }
        bosss.each do |boss|
          unless boss.is_attackable then
            boss.is_attackable = true
          end
        end
      end

      if @bgm then
        @bgm.stop
        @bgm = nil
      end
      if @boss_bgm then
        @bgm = @boss_bgm
        @bgm.play(:loop=>true, :volume=>0.5)
      end
      if @bgm_info then
        @bgm_info.set_info({:title=>BOSS_BGM_DATA[0], :data=>BOSS_BGM_DATA[1], :copyright=>BOSS_BGM_DATA[2]},
                           {:title=>"ʂ}WbN", :data=>"ʂ}WbN", :copyright=>"ʂ}WbN"},
                           {:title=>@bgm_info.height * 0.24, :data=>@bgm_info.height * 0.2,
                            :copyright=>@bgm_info.height * 0.25})
        @bgm_info.mode = :run
      end
    end

    @mode = mode
  end

  def save_log
    @save_log_thr = Thread.new do
      $config.log.set_log($config.log.parent_dir, "heatmap_stage#{@stage_number}_play#{$config.play_count}.csv")
      $config.log.write(@points, 2)
    end
  end

  def set_wait_label

    @_wait_label.string = "΂炭܂"
    start_time = Time.now
    aug_flag = true

    @wait_label_thr = Thread.new do
      while true do

        if @heatmap_image then
          @heatmap_thr.kill
          @wait_count = 0
          @_wait_label.string = ""
          @wait_label_thr.kill
          break
        end

        if @wait_count % 10 == 0 and not @wait_count == 0 and aug_flag then
          aug_flag = false

          if @wait_count / 10 <= 4 then
            @_wait_label.string += "."
          else
            @_wait_label.string = "΂炭܂"
            @wait_count = 0
          end
          @wait_label.image = @_wait_label.to_image
        end
        current_time = Time.now
        if current_time - start_time >= 1.0 / 60 then
          @wait_count += 1

          aug_flag = true
          start_time = Time.now
        end
      end
    end
  end

  def set_heatmap

    @heatmap_thr = Thread.new do

      if $config.heatmap_type == :heatmap then
        heatmap_point_size = Window.height * HEATMAP_POINT_SIZE_RATIO

        heatmap(@points, Window.width, Window.height, heatmap_point_size,
                "#{$config.log.parent_dir}/heatmap_stage#{@stage_number}_play#{$config.play_count}.png")

        @heatmap_image = Image.load("#{$config.log.parent_dir}/heatmap_stage#{@stage_number}_play#{$config.play_count}.png")

      elsif $config.heatmap_type == :pointmap
        heatmap_point_size = Window.height * POINTMAP_POINT_SIZE_RATIO

        @heatmap_image = pointmap(@points, Window.width, Window.height, heatmap_point_size, C_WHITE, C_BLACK,
                                  heatmap_point_size * 0.1, C_BLACK,
                                  "#{$config.log.parent_dir}/heatmap_stage#{@stage_number}_play#{$config.play_count}.png")
      end
    end
  end

  def stage_init

    @points = []
    @poi.impact_gain = IMPACT_GAINS[@stage_number - 1]

    weeds = []
    WEED_NUMBERS[@stage_number - 1].times do |index|
      weed_height = Window.height * rand_float(WEED_SCALE_RANGES[@stage_number - 1][0],
                                               WEED_SCALE_RANGES[@stage_number - 1][1])
      weed = Weed.new(0, 0, nil, weed_height, rand(360), index,
                      {:escape=>[WEED_SPEED_RANGES[:escape][0], WEED_SPEED_RANGES[:escape][1]]},
                      {:escape=>[WEED_MODE_RANGES[:escape][0], WEED_MODE_RANGES[:escape][1]]},
                      WEED_ESCAPE_CHANGE_TIMINGS)
      weed.set_pos(random_int(@border.x, @border.x + @border.width - weed.width),
                   random_int(@border.y, @border.y + @border.height - weed.height)) if @border
      weed.z = Z_POSITION_TOP
      weeds.push(weed)
    end

    kingyos = []
    KINGYO_NUMBERS[@stage_number - 1].times do |index|
      kingyo_height = Window.height * rand_float(KINGYO_SCALE_RANGES[@stage_number - 1][0],
                                                 KINGYO_SCALE_RANGES[@stage_number - 1][1])
      kingyo = Kingyo.new(0, 0, nil, kingyo_height, KIND_OF_KINGYOS[rand(2)], rand(360), index,
                          {:wait=>[KINGYO_SPEED_RANGES[@stage_number - 1][:wait][0],
                                   KINGYO_SPEED_RANGES[@stage_number - 1][:wait][1]],
                           :move=>[KINGYO_SPEED_RANGES[@stage_number - 1][:move][0],
                                   KINGYO_SPEED_RANGES[@stage_number - 1][:move][1]],
                           :escape=>[KINGYO_SPEED_RANGES[@stage_number - 1][:escape][0],
                                     KINGYO_SPEED_RANGES[@stage_number - 1][:escape][1]]},
                          {:wait=>[KINGYO_MODE_RANGES[@stage_number - 1][:wait][0],
                                   KINGYO_MODE_RANGES[@stage_number - 1][:wait][1]],
                           :move=>[KINGYO_MODE_RANGES[@stage_number - 1][:move][0],
                                   KINGYO_MODE_RANGES[@stage_number - 1][:move][1]],
                           :escape=>[KINGYO_MODE_RANGES[@stage_number - 1][:escape][0],
                                     KINGYO_MODE_RANGES[@stage_number - 1][:escape][1]]},
                          KINGYO_PERSONALITY_WEIGHTS[@stage_number - 1],
                          KINGYO_ESCAPE_CHANGE_TIMINGS[@stage_number - 1])
      kingyo.set_pos(random_int(@border.x, @border.x + @border.width - kingyo.width),
                     random_int(@border.y, @border.y + @border.height - kingyo.height)) if @border
      kingyo.z = Z_POSITION_TOP
      kingyos.push(kingyo)
    end

    @swimmers = weeds + kingyos
    fisher_yates(@swimmers)
  end

  def boss_init

    bosss = []
    @poi_gauges.size.times do |index|
      boss_height = Window.height * rand_float(BOSS_SCALE_RANGES[0], BOSS_SCALE_RANGES[1])
      boss = Boss.new(0, 0, nil, boss_height, rand(360), index,
                      {:wait=>[BOSS_SPEED_RANGES[:wait][0], BOSS_SPEED_RANGES[:wait][1]],
                       :move=>[BOSS_SPEED_RANGES[:move][0], BOSS_SPEED_RANGES[:move][1]],
                       :escape=>[BOSS_SPEED_RANGES[:escape][0], BOSS_SPEED_RANGES[:escape][1]]},
                      {:wait=>[BOSS_MODE_RANGES[:wait][0], BOSS_MODE_RANGES[:wait][1]],
                       :move=>[BOSS_MODE_RANGES[:move][0], BOSS_MODE_RANGES[:move][1]],
                       :escape=>[BOSS_MODE_RANGES[:escape][0], BOSS_MODE_RANGES[:escape][1]]},
                      BOSS_PERSONALITY_WEIGHTS, BOSS_ESCAPE_CHANGE_TIMINGS, @poi, @border.blocks)
      boss.set_pos(random_int(@border.x, @border.x + @border.width - boss.width),
                   random_int(@border.y, @border.y + @border.height - boss.height)) if @border
      boss.z = Z_POSITION_TOP
      bosss.push(boss)
    end

    @swimmers += bosss
    fisher_yates(@swimmers)
  end

  def update
    
    if Input.key_release?(K_ESCAPE) then
      $config.eyemot_mouse.close
      exit
    end

    if Input.key_release?(K_W) then
      if Window.windowed? then
        Window.windowed = false
      else
        Window.windowed = true
      end
      @click_se.play if @click_se
    end

    if Input.key_release?(K_X) then
      if not $config.eyemot_mouse.mode == :off then
        $config.eyemot_mouse.eye_off
      elsif $config.eyemot_mouse.mode == :off
        $config.eyemot_mouse.eye_on
      end
    end

    if Input.key_release?(K_P) then
      $config.log.screen_shot("screen_shot_#{$config.screen_shot_count}.png")
      $config.screen_shot_count += 1
      @screen_shot_se.play if @screen_shot_se
    end

    if (@return_to_title_button and not @is_returnable and
      (@return_to_title_button.pushed? or @return_to_title_button.is_auto_clicked)) or Input.key_release?(K_E) then
      @return_to_title_button.is_auto_clicked = false

      @click_se.play if @click_se
      @is_returnable = true
    end

    if @buttons and not @buttons.empty? then
      @buttons.each do |button|
        if @is_returnable and (button.name == "return_to_title_ok_button" or
          button.name == "return_to_title_cancel_button") then
          button.hovered?
        elsif not @is_returnable and
          not (button.name == "return_to_title_ok_button" or button.name == "return_to_title_cancel_button") then
          button.hovered?
        end
      end
    end

    if @return_to_title_message_dialog and @is_returnable and
      (@return_to_title_message_dialog.ok_button.pushed? or @return_to_title_message_dialog.ok_button.is_auto_clicked) then
      @return_to_title_message_dialog.ok_button.is_auto_clicked = false

      if @bgm then
        @bgm.stop
        @bgm = nil
      end
      @click_se.play if @click_se
      self.next_scene = TitleScene
      @is_returnable = false
      @poi.z = Z_POSITION_TOP
    end

    if @return_to_title_message_dialog and @is_returnable and
      (@return_to_title_message_dialog.cancel_button.pushed? or
        @return_to_title_message_dialog.cancel_button.is_auto_clicked) then

      @return_to_title_message_dialog.cancel_button.is_auto_clicked = false
      @click_se.play if @click_se
      @is_returnable = false
    end

    @mouse.x, @mouse.y = Input.mouse_pos_x, Input.mouse_pos_y if @mouse
    @points.push([@mouse.x, @mouse.y])

    if @mode == :start then
      if @start_count <= START_MAX_COUNT then
        @wave_shader.update if @wave_shader
        @start_count += 1
      else
        @start_count = 0
        self.change_mode(:normal)
      end
    end

    if @mode == :break then
      if @break_count >= BREAK_MAX_COUNT then
        if @heatmap_image and not @heatmap_image.disposed? then
          @heatmap_image.dispose
          @heatmap_image = nil
        end

        @stage_number += 1
        @break_count = 0
        self.change_mode(:start)
      else
        @break_count += 1
      end
    end

    @bgm_info.update if @bgm_info and @bgm_info.mode == :run and not @mode == :start

    if @alert and @alert.mode == :run and not @mode == :start then
      @alert.update
    elsif @alert and @alert.mode == :finish
      @alert.mode = :wait
      self.change_mode(:boss)
    end

    if @swimmers and not @swimmers.empty? and not @mode == :start
      @swimmers.each do |swimmer|
        swimmer.update

        if not swimmer.mode == :catched and not swimmer.is_reserved then
          if (swimmer.x + swimmer.center_x - (@container.x + (@container.width * 0.5))) ** 2 +
            ((swimmer.y + swimmer.center_y - (@container.y + (@container.height * 0.5))) ** 2) <=
            (@container.width * 0.5 * CONTAINER_CONTACT_ADJUST_RANGE_RATIO) ** 2 then
            swimmer.z = Z_POSITION_BOTTOM
          else
            swimmer.z = Z_POSITION_TOP
          end
        end

        if swimmer.is_reserved then
          max_radius = @container.width * 0.5 * CONTAINER_RESERVE_ADJUST_RANGE_RATIO
          obj_radius = Math.sqrt((swimmer.x + swimmer.center_x - (@container.x + @container.center_x)) ** 2 +
                                   ((swimmer.y + swimmer.center_y - (@container.y + @container.center_y)) ** 2))

          if obj_radius >= max_radius then
            angle = Math.atan2(swimmer.y + swimmer.center_y - (@container.y + @container.center_y),
                               swimmer.x + swimmer.center_x - (@container.x + @container.center_x))
            swimmer.x = @container.x + @container.center_x - (swimmer.width * 0.5) + (max_radius * Math.cos(angle))
            swimmer.y = @container.y + @container.center_y - (swimmer.height * 0.5) + (max_radius * Math.sin(angle))
          end
        end

        if @poi.impact_radius and not @is_returnable and
          (swimmer.x + swimmer.center_x - (@poi.x + (@poi.width * 0.5))) ** 2 +
            ((swimmer.y + swimmer.center_y - (@poi.y + (@poi.height * 0.5))) ** 2) <= @poi.impact_radius ** 2 then

          if swimmer.class == Kingyo or swimmer.class == Boss or swimmer.class == Weed then

            swimmer_radian = Math.atan2(swimmer.y + swimmer.center_y - (@poi.y + (@poi.height * 0.5)),
                                        swimmer.x + swimmer.center_x - (@poi.x + (@poi.width * 0.5)))

            swimmer.angle_candidate = swimmer_radian * (180 / Math::PI) + 90

            if swimmer.class == Weed then
              radian = swimmer.angle * (Math::PI / 180)

              weed_vec_scale = swimmer.height * 0.5
              weed_vector_x = weed_vec_scale * Math.sin(radian)
              weed_vector_y = -1 * weed_vec_scale * Math.cos(radian)

              poi_vector_x = @poi.x + @poi.center_x - (swimmer.x + swimmer.center_x)
              poi_vector_y = @poi.y + @poi.center_y - (swimmer.y + swimmer.center_y)
              poi_vec_scale = Math.sqrt(poi_vector_x ** 2 + (poi_vector_y ** 2))

              dot_weed_and_poi_vec = weed_vector_x * poi_vector_x + (weed_vector_y * poi_vector_y) # 
              phi = Math.acos(dot_weed_and_poi_vec / (weed_vec_scale * poi_vec_scale))

              deg_phi = phi * (180 / Math::PI)
              cross = weed_vector_x * poi_vector_y - (weed_vector_y * poi_vector_x) # O

              direction_of_rotation = 1 if 0 < deg_phi and deg_phi <= 90
              direction_of_rotation = -1 if 90 < deg_phi and deg_phi <= 180

              if direction_of_rotation * cross < 0 then
                swimmer.direction_of_rotation = :right
              else
                swimmer.direction_of_rotation = :left
              end
            end
            swimmer.change_mode(:escape)
          end
        end

        if @poi.impact_radius and not @is_returnable and
          (@container.x + @container.center_x - (@poi.x + (@poi.width * 0.5))) ** 2 +
          ((@container.y + @container.center_y - (@poi.y + (@poi.height * 0.5))) ** 2) <= @poi.impact_radius ** 2 then

          container_radian = Math.atan2(@container.y + @container.center_y - (@poi.y + (@poi.height * 0.5)),
                                        @container.x + @container.center_x - (@poi.x + (@poi.width * 0.5)))
          @container.angle = container_radian * (180 / Math::PI) + 90
          @container.change_mode(:escape)
        end

        if not @swimmers.select { |obj| obj.class == Boss }.empty? and not @is_returnable then
          bosss = @swimmers.select { |obj| obj.class == Boss }

          bosss.each do |boss|
            if boss.bubble_shots and not boss.bubble_shots.empty? and boss.is_attackable then

              boss.bubble_shots.each do |bubble_shot|
                bubble_shot.z = Z_POSITION_TOP if not bubble_shot.z == Z_POSITION_TOP

                if bubble_shot.killed_by_poi then
                  bubble_shot.killed_by_poi = false

                  @life_gauge.change_life(-1 * bubble_shot.height * BUBBLE_SHOT_DAMAGE_UNIT_RATIO) if
                    not @mode == :game_over and not @mode == :game_clear
                  @poi.set_damage
                end
              end
            end
          end
        end
      end
    end

    if @splashs and not @splashs.empty? and not @mode == :start
      @splashs.each do |splash|
        if splash.mode == :finish then
          @splashs.delete(splash)
        else
          splash.update
        end
      end
    end

    @container.update if @container

    @poi.update if @poi

    @point_label.update if @point_label
    @point_label = nil if @point_label and @point_label.vanished?

    @combo_label.update if @combo_label
    @combo_label = nil if @combo_label and @combo_label.vanished?

    Sprite.check(@border.blocks + @swimmers + [@container]) if
      @border and @swimmers and not @swimmers.empty? and @container and not @mode == :start

    if @poi and @poi.mode == :transport then

      if $config.vibeman and $config.vibeman.is_connecting and @vibeman_is_rannable then
        @vibeman_is_rannable = false
        Thread.new do
          $config.vibeman.vibe
        end
      end
      @catch_objects.each do |catch_object|
        catch_object[0].set_pos(@poi.x + catch_object[1][0], @poi.y + catch_object[1][1])

        distance_in_poi = Math.sqrt((catch_object[1][0] + catch_object[0].center_x - @poi.center_x) ** 2 +
                                      (catch_object[1][0] + catch_object[0].center_y - @poi.center_y) ** 2)
        distance_damage_unit = 1 / distance_in_poi

        damage_unit_ratio = KINGYO_DAMAGE_UNIT_RATIO if catch_object[0].class == Kingyo
        damage_unit_ratio = WEED_DAMAGE_UNIT_RATIO if catch_object[0].class == Weed
        damage_unit_ratio = BOSS_DAMAGE_UNIT_RATIO if catch_object[0].class == Boss

        @life_gauge.change_life(-1 * catch_object[0].height * damage_unit_ratio * distance_damage_unit) if
          not @mode == :game_over and not @mode == :game_clear

        catch_object[0].z = Z_POSITION_TOP
      end
    elsif @poi and (@poi.mode == :reserve or @poi.mode == :broke) then
      catched_objects = []

      @catch_objects.each do |catch_object|
        if (catch_object[0].x + catch_object[0].center_x - (@container.x + (@container.width * 0.5))) ** 2 +
          ((catch_object[0].y + catch_object[0].center_y - (@container.y + (@container.height * 0.5))) ** 2) <=
          (@container.width * 0.5 * CONTAINER_CATCH_ADJUST_RANGE_RATIO) ** 2 then

          catch_object[0].z = Z_POSITION_UP
          catch_object[0].is_reserved = true
          catch_object[0].change_mode(:reserved)
          catched_objects.push(catch_object[0])
        else
          catch_object[0].change_mode(:broke)
        end
      end
      self.reserved(catched_objects)
      @catch_objects.clear
      @vibeman_is_rannable = true
    end

    # |Cjꂽ
    if @life_gauge.has_out_of_life and not @mode == :game_over and not @mode == :game_clear then
      if @poi_gauges.empty? then

        # 莝̃|CSȂȂĂcĂꍇ
        if not @swimmers.select { |obj| not obj.is_reserved and not obj.class == Weed }.empty? then
          @life_gauge.change_gauge(0)
          self.change_mode(:game_over)
          @poi.set_break(true)

          # 莝̃|CSȂȂǋSꍇ
        else
          @life_gauge.change_gauge(0)
          self.change_mode(:game_clear)
          @poi.set_break(true)
        end
      else
        @poi_gauges[-1].vanish
        @poi_gauges.delete_at(-1)
        @poi.set_break(false)
      end
      @life_gauge.has_out_of_life = false
    end

    if @mode == :game_over or @mode == :game_clear then

      if @end_count > 240 then
        if @heatmap_image and not @heatmap_image.disposed? then
          @heatmap_image.dispose
          @heatmap_image = nil
        end
        @end_count = 0

        self.will_disappear
        self.next_scene = ResultScene
      else
        @end_count += 1
      end
    end
  end

  def gazed(x, y, center_x, center_y)

    if @buttons and not @buttons.empty? then
      @buttons.each do |button|
        if button.is_enable then

          if x + center_x >= button.x and x + center_x <= button.x + button.width and
            y + center_y >= button.y and y + center_y <= button.y + button.height then

            if button.name = "return_to_title_button" then
              button.is_auto_clicked = true
              return
            end
            if @is_returnable and (button.name == "return_to_title_ok_button" or
              button.name == "return_to_title_cancel_button") then
              button.is_auto_clicked = true
            elsif not @is_returnable and
              not (button.name == "return_to_title_ok_button" or button.name == "return_to_title_cancel_button") then
              button.is_auto_clicked = true
            end
          else
            button.is_auto_clicked = false
          end
        end
      end
    end

    if @poi and not @mode == :start and not @is_returnable then
      @catch_objects = []
      if @swimmers and not @swimmers.empty? then

        @swimmers.each do |swimmer|
          if not swimmer.z == Z_POSITION_BOTTOM and not swimmer.is_reserved and
            not (swimmer.class == Boss and @mode == :alert) then

            if (swimmer.x + swimmer.center_x - (x + center_x)) ** 2 +
              ((swimmer.y + swimmer.center_y - (y + center_y)) ** 2) <=
              (@poi.width * 0.5 * POI_CATCH_ADJUST_RANGE_RATIO) ** 2 then

              if not swimmer.class == Boss then
                swimmer.change_mode(:catched)
                @catch_objects.push([swimmer, [swimmer.x - x, swimmer.y - y]])
              else
                swimmer.hp -= 1
                if swimmer.hp > 0 then
                  swimmer.change_mode(:damaged)
                else
                  swimmer.change_mode(:died)
                  @catch_objects.push([swimmer, [swimmer.x - x, swimmer.y - y]])
                end
              end
            end
          end
        end
        unless @catch_objects.empty? then
          @poi.old_pos = [@poi.x, @poi.y]
          @poi.mode = :transport
        else
          @poi.mode = :search
        end
      end
    end
  end

  def reserved(catched_objects)

    if catched_objects and not catched_objects.empty? then

      point = 0
      technical_point_diff = 0

      catched_object_center_xs = []
      catched_object_center_ys = []

      catched_objects.each do |catched_object|

        catched_object_center_x = catched_object.x + catched_object.center_x
        catched_object_center_y = catched_object.y + catched_object.center_y

        distance_in_poi = Math.sqrt((catched_object_center_x - (@poi.x + @poi.center_x)) ** 2 +
                                      (catched_object_center_y - (@poi.y + @poi.center_y)) ** 2)
        technical_distance_in_poi = distance_in_poi / (@poi.width * 0.5)

        if catched_object.class == Kingyo then
          techinical_max_size = Window.height * KINGYO_SCALE_RANGES[@stage_number - 1][1]
          $config.scores[:catched_kingyo_number] += 1

        elsif catched_object.class == Boss then
          techinical_max_size = Window.height * BOSS_SCALE_RANGES[1]
          $config.scores[:catched_boss_number] += 1

          catched_object.is_shot = false

        elsif catched_object.class == Weed then
          techinical_max_size = Window.height * WEED_SCALE_RANGES[@stage_number - 1][1]
        else
        end
        technical_size = catched_object.height / techinical_max_size

        if catched_object.pre_mode == :wait then
          mode_point_unit = 1
        elsif catched_object.pre_mode == :move then
          mode_point_unit = 3
        elsif catched_object.pre_mode == :escape then
          mode_point_unit = 2
        else
          mode_point_unit = 0.5
        end
        mode_point = mode_point_unit / 3.to_f

        techinical_unit = technical_size + technical_distance_in_poi + mode_point
        point += BASE_SCORES[catched_object.name] * techinical_unit

        technical_point_diff += techinical_unit * 10
        technical_point_diff *= -1 if catched_object.class == Weed

        catched_object_center_xs.push(catched_object_center_x)
        catched_object_center_ys.push(catched_object_center_y)

        splash = Splash.new(10, 1)
        splash.run(catched_object_center_x - (splash.width * 0.5), catched_object_center_y - (splash.height * 0.5),
                   catched_object, catched_object.height * 2.0, 0.8)

        if catched_object.class == Boss then
          @splash_rarge_se.play
        else
          @splash_small_se.play
        end
        @splashs.push(splash)
      end

      combo = catched_objects.size
      point *= combo
      technical_point_diff += combo / @swimmers.size.to_f * 10

      $config.scores[:score] += point.round

      @_score_label.string = "SCORE : #{$config.scores[:score]}_"
      @_score_label.edge = true
      @_score_label.edge_width = @_score_label.height * 0.05

      @score_label.image = @_score_label.to_image
      @score_label.z = Z_POSITION_TOP

      original_points = [@container.x + @container.center_x, @container.y + @container.center_y]
      geometric_centers = calc_geometric_center(catched_object_center_xs, catched_object_center_ys)
      diff_vector = [geometric_centers[0] - original_points[0], geometric_centers[1] - original_points[1]]
      v_changes = [diff_vector[0] * POINT_LABEL_MOVE_SCALE, diff_vector[1] * POINT_LABEL_MOVE_SCALE]
      weight_ratio = 1 - (1 / (1 + (point.abs * 0.03)))

      point_color = C_CUD_ACCENT_RED if point >= 0
      point_color = C_CUD_ACCENT_BLUE if point < 0
      @point_label = SpriteFont.new(0, 0, "#{point.round}_", 128, point_color, C_DEFAULT,
                                    {:font_name=>"݂", :shadow=>true,
                                     :shadow_color=>[128, 128, 128, 128], :edge=>true})
      @point_label.alpha = 0
      @point_label.z = Z_POSITION_TOP
      @point_label.fade_move(geometric_centers, v_changes, weight_ratio, [0, 0, Window.width, Window.height])

      if combo > 1 then
        v_changes = v_changes.map { |v_change| v_change * -1 }
        weight_ratio = 1 - (1 / (1 + (combo * 0.8)))

        @combo_label = SpriteFont.new(0, 0, "#{combo}R{I", 164, C_CUD_ACCENT_PURPLE, C_DEFAULT,
                                      {:font_name=>"݂", :weight=>true,  :shadow=>true,
                                       :shadow_color=>[128, 128, 128, 128], :edge=>true})
        @combo_label.alpha = 0
        @combo_label.z = Z_POSITION_TOP
        @combo_label.fade_move(geometric_centers, v_changes, weight_ratio, [0, 0, Window.width, Window.height])
      end

      $config.scores[:technical_point] += technical_point_diff
      $config.scores[:technical_point] = BigDecimal($config.scores[:technical_point].to_s).round(2).to_f
      $config.scores[:max_combo] = combo if combo > $config.scores[:max_combo]

      @challenge_point += technical_point_diff

      boss_remaind_numbes = @swimmers.select { |obj| obj.name == "boss" and not obj.is_reserved }
      if @challenge_point >= CHALLENGE_POINT_UP_RANGE and not @mode == :alert and boss_remaind_numbes.empty? then
        self.change_mode(:alert)
        @challenge_point = 0
      end

      # ȂȂ
      if @swimmers.select { |obj| not obj.is_reserved and not obj.class == Weed }.empty? then
        if @stage_number < MAX_STAGE_NUMBER then
          self.change_mode(:break)
        else
          self.change_mode(:game_clear)
        end
      end
    end
  end

  def render

    unless $config.hilighted then
      Window.draw(0, 0, @stone_tile_image) if @stone_tile_image
      Window.draw_ex(0, 0, @aquarium_back_image, :alpha=>180) if @aquarium_back_image
    end

    @border.draw if @border and @mode == :start

    @shader_rt.draw(0, 0, @aquarium_back_image) if @shader_rt and @aquarium_back_image and @mode == :start
    Window.draw_shader(0, 0, @shader_rt, @wave_shader) if @shader_rt and @wave_shader and @mode == :start

    @container.draw if @container and not @mode == :start
    @life_gauge.draw if @life_gauge and not @mode == :start

    if @poi_gauges and not @poi_gauges.empty? and not @mode == :start then
      @poi_gauges.each do |poi_gauge|
        poi_gauge.draw
      end
    end

    @score_label.draw if @score_label and not @mode == :start
    @stage_info_label.draw if @stage_info_label and @mode == :start

    @return_to_title_button.draw if @return_to_title_button and not
    (@mode == :break and @mode == :game_over and @mode == :game_clear and @mode == :start)

    @poi.draw if @poi and not (@mode == :break and @mode == :game_over and @mode == :game_clear and @is_returnable)

    if @splashs and not @splashs.empty? and not @mode == :start then
      @splashs.each do |splash|
        splash.draw
      end
    end

    if @swimmers and not @swimmers.empty? and not @mode == :start then
      @swimmers.each do |swimmer|
        swimmer.draw if not (swimmer.class == Boss and not swimmer.is_reserved) or not @mode == :alert
      end
    end

    @point_label.draw if @point_label and not @mode == :start
    @combo_label.draw if @combo_label and not @mode == :start

    @alert.draw if @alert and @alert.mode == :run and not @mode == :start
    @bgm_info.draw if @bgm_info and @bgm_info.mode == :run and not @mode == :start

    if @mode == :break then
      @wait_label.draw if @wait_label and not @_wait_label.string == ""
      Window.draw_ex(0, 0, @heatmap_image, :alpha=>192, :z=>Z_POSITION_TOP) if @heatmap_image
      @return_to_title_button.draw if @return_to_title_button and not @is_returnable
      @poi.draw if @poi and not @is_returnable
    end

    if @mode == :game_over or @mode == :game_clear then
      Window.draw(0, 0, @cover_layer, Z_POSITION_TOP) if @cover_layer
      @stage_info_label.draw if @stage_info_label and
      @wait_label.draw if @wait_label and not @_wait_label.string == ""
      Window.draw_ex(0, 0, @heatmap_image, :alpha=>192, :z=>Z_POSITION_TOP) if @heatmap_image
      @return_to_title_button.draw if @return_to_title_button and not @is_returnable
      @poi.draw if @poi and not @is_returnable
    end

    if @is_returnable then
      Window.draw(0, 0, @cover_layer, Z_POSITION_TOP) if @cover_layer and not (@mode == :game_over and @mode == :game_clear)
      @return_to_title_message_dialog.draw if @return_to_title_message_dialog
      @poi.draw if @poi and not (@mode == :game_over and @mode == :game_clear)
    end
  end

  def will_disappear
    if @bgm then
      @bgm.stop
      @bgm = nil
      @main_bgm.free if @main_bgm
      @alert_bgm.free if @alert_bgm
      @boss_bgm.free if @boss_bgm
    end
  end
end


class ResultScene < Scene::Base

  require "./lib/dxruby/images"
  require "./lib/dxruby/color"

  require "./scripts/confetti"
  require "./scripts/message_dialog"

  include Color

  CLICK_SE = "./sounds/meka_ge_mouse_s02.wav"
  SCREEN_SHOT_SE = "./sounds/Camera-Phone01-1.wav"
  CONGRATULATIONS_SE = "./sounds/nc134713.wav"
  OK_BUTTON_IMAGE = "./images/m_4.png"
  RETURN_TO_TITLE_BUTTON_IMAGE = "./images/s_3.png"
  CANCEL_BUTTON_IMAGE = "./images/m_1.png"

  COMMENDATION_POINT = 850
  CONFETTI_MAX_NUMBER = 800

  MAX_COUNT_IN_WINDOW = 40
  MAX_COUNT_IN_GAZE_AREA = 30

  POI_HEIGHT_SIZE_RATIO = 0.2
  MAX_GAZE_COUNT = 15
  POI_GAZE_RADIUS_RATIO = 0.8

  def init

    @click_se = Sound.new(CLICK_SE)
    @screen_shot_se = Sound.new(SCREEN_SHOT_SE)
    @congratulations_se = Sound.new(CONGRATULATIONS_SE)

    @background_image = Image.new(Window.width, Window.height, C_CUD_BASE_LIGHT_PINK)

    $config.scores[:cognomen], $config.scores[:color] = "ER", C_CUD_ACCENT_BROWN if $config.scores[:technical_point] < COMMENDATION_POINT * 0.9
    $config.scores[:cognomen], $config.scores[:color] = "UR", C_CUD_ACCENT_PURPLE if
      $config.scores[:technical_point] >= COMMENDATION_POINT * 0.9 and $config.scores[:technical_point] < COMMENDATION_POINT * 0.95
    $config.scores[:cognomen], $config.scores[:color] = "S҃y[", C_CUD_ACCENT_ORANGE if
      $config.scores[:technical_point] >= COMMENDATION_POINT * 0.95 and $config.scores[:technical_point] < COMMENDATION_POINT * 1.0
    $config.scores[:cognomen], $config.scores[:color] = "ʃ^", C_CUD_ACCENT_PINK if
      $config.scores[:technical_point] >= COMMENDATION_POINT * 1.0 and $config.scores[:technical_point] < COMMENDATION_POINT * 1.05
    $config.scores[:cognomen], $config.scores[:color] = "ǂ", C_CUD_ACCENT_SKY if
      $config.scores[:technical_point] >= COMMENDATION_POINT * 1.05 and $config.scores[:technical_point] < COMMENDATION_POINT * 1.1
    $config.scores[:cognomen], $config.scores[:color] = "X[p[Ju", C_CUD_ACCENT_BLUE if
      $config.scores[:technical_point] >= COMMENDATION_POINT * 1.1 and $config.scores[:technical_point] < COMMENDATION_POINT * 1.15
    $config.scores[:cognomen], $config.scores[:color] = "WFh", C_CUD_ACCENT_GREEN if
      $config.scores[:technical_point] >= COMMENDATION_POINT * 1.15 and $config.scores[:technical_point] < COMMENDATION_POINT * 1.2
    $config.scores[:cognomen], $config.scores[:color] = "l", C_CUD_ACCENT_YELLOW if
      $config.scores[:technical_point] >= COMMENDATION_POINT * 1.2 and $config.scores[:technical_point] < COMMENDATION_POINT * 1.25
    $config.scores[:cognomen], $config.scores[:color] = "_", C_CUD_ACCENT_RED if $config.scores[:technical_point] >= COMMENDATION_POINT * 1.25

    _title_label = Fonts.new(0, 0, "", Window.height * 0.1, C_CUD_ACCENT_PURPLE, {:font_name=>"`FbN|CgtHg"})
    _title_label.edge = true
    _title_label.edge_width = _title_label.height * 0.05

    @title_label = Images.new((Window.width - _title_label.width) * 0.5, (Window.height - _title_label.height) * 0.03,
                             _title_label.width, _title_label.height)
    @title_label.image = _title_label.to_image
    _title_label.vanish

    _score_label = Fonts.new(0, 0, "SCORE : #{$config.scores[:score]}_",
                             Window.height * 0.05, C_CUD_ACCENT_GREEN, {:font_name=>"R̗tHg"})
    _score_label.edge = true
    _score_label.edge_width = _score_label.height * 0.05

    @score_label = Images.new((Window.width - _score_label.width) * 0.5, (Window.height - _score_label.height) * 0.18,
                              _score_label.width, _score_label.height)
    @score_label.image = _score_label.to_image
    _score_label.vanish

    _catched_kingyo_number_label = Fonts.new(0, 0, "ߊl : #{$config.scores[:catched_kingyo_number]}C",
                                             Window.height * 0.07, C_CUD_ACCENT_RED, {:font_name=>"R̗tHg"})
    _catched_kingyo_number_label.edge = true
    _catched_kingyo_number_label.edge_width = _catched_kingyo_number_label.height* 0.05

    @catched_kingyo_number_label = Images.new((Window.width - _catched_kingyo_number_label.width) * 0.5,
                                              (Window.height - _catched_kingyo_number_label.height) * 0.28,
                                              _catched_kingyo_number_label.width, _catched_kingyo_number_label.height)
    @catched_kingyo_number_label.image = _catched_kingyo_number_label.to_image
    _catched_kingyo_number_label.vanish

    _catched_boss_number_label = Fonts.new(0, 0, "{Xߊl : #{$config.scores[:catched_boss_number]}C",
                                           Window.height * 0.07, C_CUD_ACCENT_RED, {:font_name=>"R̗tHg"})
    _catched_boss_number_label.edge = true
    _catched_boss_number_label.edge_width = _catched_boss_number_label.height * 0.05

    @catched_boss_number_label = Images.new((Window.width - _catched_boss_number_label.width) * 0.5,
                              (Window.height - _catched_boss_number_label.height) * 0.38,
                              _catched_boss_number_label.width, _catched_boss_number_label.height)
    @catched_boss_number_label.image = _catched_boss_number_label.to_image
    _catched_boss_number_label.vanish

    _max_combo_label = Fonts.new(0, 0, "MAXR{ : #{$config.scores[:max_combo]}",
                                 Window.height * 0.07, C_CUD_ACCENT_ORANGE, {:font_name=>"R̗tHg"})
    _max_combo_label.edge = true
    _max_combo_label.edge_width = _max_combo_label.height * 0.05

    @max_combo_label = Images.new((Window.width - _max_combo_label.width) * 0.5,
                                  (Window.height - _max_combo_label.height) * 0.48, _max_combo_label.width,
                                  _max_combo_label.height)
    @max_combo_label.image = _max_combo_label.to_image
    _max_combo_label.vanish

    _technical_point_label = Fonts.new(0, 0, "eNjJ|Cg : #{$config.scores[:technical_point]}",
                                       Window.height * 0.05, C_CUD_ACCENT_BLUE, {:font_name=>"R̗tHg"})
    _technical_point_label.edge = true
    _technical_point_label.edge_width = _technical_point_label.height * 0.05

    @technical_point_label = Images.new((Window.width - _technical_point_label.width) * 0.5,
                                        (Window.height - _technical_point_label.height) * 0.6,
                                        _technical_point_label.width, _technical_point_label.height)
    @technical_point_label.image = _technical_point_label.to_image
    _technical_point_label.vanish

    _cognomen_label = Fonts.new(0, 0, "̍ : #{$config.scores[:cognomen]}",
                                Window.height * 0.1, $config.scores[:color], {:font_name=>"ʂ}WbN"})
    _cognomen_label.set_weight = true
    _cognomen_label.edge = true
    _cognomen_label.edge_width = _cognomen_label.height * 0.05

    @cognomen_label = Images.new((Window.width - _cognomen_label.width) * 0.5,
                                        (Window.height - _cognomen_label.height) * 0.75,
                                        _cognomen_label.width, _cognomen_label.height)
    @cognomen_label.image = _cognomen_label.to_image
    _cognomen_label.vanish

    ok_button_image = Image.load(OK_BUTTON_IMAGE)
    @ok_button = Button.new(Window.width * 0.4, Window.height * 0.85, Window.width * 0.2, Window.height * 0.1, "OK",
                            Window.height * 0.08, {:str_color=>C_CUD_NON_COLORED_BLACK, :font_name=>"07mxPOP"})
    @ok_button.set_image(Images.fit_resize(ok_button_image, Window.width * 0.2, Window.height * 0.1))

    return_to_title_button_image = Image.load(RETURN_TO_TITLE_BUTTON_IMAGE)
    return_to_title_button_scale = Window.height * 0.05 / return_to_title_button_image.height
    return_to_title_button_converted_image =
      Images.scale_resize(return_to_title_button_image, return_to_title_button_scale, return_to_title_button_scale)

    @return_to_title_button = Button.new
    @return_to_title_button.set_image(return_to_title_button_converted_image)
    @return_to_title_button.set_string("", return_to_title_button_converted_image.height * 0.6,
                              "07mxPOP", {:color=>C_CUD_NON_COLORED_BLACK})
    @return_to_title_button.set_pos(Window.width - @return_to_title_button.width, 0)

    return_to_title_message_dialog_height = Window.height * 0.4
    return_to_title_message_dialog_width = return_to_title_message_dialog_height * 2
    return_to_title_message_dialog_option = {:frame_thickness=>return_to_title_message_dialog_height * 0.04,
                                             :radius=>return_to_title_message_dialog_height * 0.06,
                                             :bg_color=>C_CREAM, :frame_color=>C_CUD_ACCENT_ORANGE}

    @return_to_title_message_dialog = MessageDialog.new(0, 0, return_to_title_message_dialog_width,
                                                        return_to_title_message_dialog_height, 1,
                                                        return_to_title_message_dialog_option)

    @return_to_title_message_dialog.set_message("^Cgɖ߂܂H", "",
                                       @return_to_title_message_dialog.height * 0.15, C_CUD_ACCENT_BROWN, "݂")
    @return_to_title_message_dialog.set_pos((Window.width - @return_to_title_message_dialog.width) * 0.5,
                                   (Window.height - @return_to_title_message_dialog.height) * 0.5)

    @return_to_title_message_dialog.ok_button.font_color = C_CUD_NON_COLORED_BLACK
    @return_to_title_message_dialog.ok_button.font_name = "07mxPOP"
    @return_to_title_message_dialog.ok_button.name = "return_to_title_ok_button"

    @return_to_title_message_dialog.cancel_button.font_color = C_CUD_NON_COLORED_BLACK
    @return_to_title_message_dialog.cancel_button.font_name = "07mxPOP"
    @return_to_title_message_dialog.cancel_button.name = "return_to_title_cancel_button"

    ok_button_image = Image.load(OK_BUTTON_IMAGE)
    @return_to_title_message_dialog.ok_button.set_image(
      Images.fit_resize(ok_button_image, @return_to_title_message_dialog.ok_button.width,
                        @return_to_title_message_dialog.ok_button.height))

    cancel_button_image = Image.load(CANCEL_BUTTON_IMAGE)
    @return_to_title_message_dialog.cancel_button.set_image(
      Images.fit_resize(cancel_button_image, @return_to_title_message_dialog.cancel_button.width,
                        @return_to_title_message_dialog.cancel_button.height))

    @is_returnable = false

    @buttons = [@ok_button, @return_to_title_button, @return_to_title_message_dialog.ok_button,
                @return_to_title_message_dialog.cancel_button]

    if $config.scores[:technical_point] >= COMMENDATION_POINT then

      confetti_size_min = Window.height * 0.028
      confetti_size_max = confetti_size_min * 3
      confetti_accel_min = 0.02
      confetti_accel_max = confetti_accel_min * 4
      confetti_amp_min = Window.height * 0.005
      confetti_amp_max = confetti_amp_min * 2
      confetti_rot_speed_min = 0.5
      confetti_rot_speed_max = confetti_rot_speed_min * 15
      confetti_angular_velo_min = 0.5
      confetti_angular_velo_max = confetti_angular_velo_min * 10

      @confettis = []
      CONFETTI_MAX_NUMBER.times do
        confetti = Confetti.new(Window.height, [0, 0], [0, 0], [confetti_size_min, confetti_size_max],
                                [confetti_accel_min, confetti_accel_max], [confetti_amp_min, confetti_amp_max],
                                [confetti_rot_speed_min, confetti_rot_speed_max],
                                [confetti_angular_velo_min, confetti_angular_velo_max])
        confetti.set_x([-1 * confetti.width * Math.sqrt(2), Window.width + (confetti.width * Math.sqrt(2))])
        confetti.set_y([-1 * confetti.height * Math.sqrt(2), -1 * Window.height + confetti.height * Math.sqrt(2)])
        @confettis.push(confetti)
      end
      @congratulations_se.play
    end

    @cover_layer = Image.new(Window.width, Window.height, [196, 128, 128, 128])
    @mouse = Sprite.new
    @mouse.collision = [0, 0]

    @poi = Poi.new(0, 0, nil, Window.height * POI_HEIGHT_SIZE_RATIO, :click, @mouse,
                   MAX_GAZE_COUNT, self, nil, true, {:max_count_in_window=>MAX_COUNT_IN_WINDOW,
                                               :gaze_radius_ratio=>POI_GAZE_RADIUS_RATIO,
                                               :max_count_in_gaze_area=>MAX_COUNT_IN_GAZE_AREA})
    @poi.set_pos((Window.width - @poi.width) * 0.5, (Window.height - @poi.height) * 0.5)
  end

  def update

    if @confettis and not @confettis.empty? then
      @confettis.each do |confetti|
        confetti.update
      end
    end

    if Input.key_release?(K_ESCAPE) then
      $config.eyemot_mouse.close
      exit
    end

    if Input.key_release?(K_W) then
      if Window.windowed? then
        Window.windowed = false
      else
        Window.windowed = true
      end
      @click_se.play if @click_se
    end

    if Input.key_release?(K_X) then
      if not $config.eyemot_mouse.mode == :off then
        $config.eyemot_mouse.eye_off
      elsif $config.eyemot_mouse.mode == :off
        $config.eyemot_mouse.eye_on
      end
    end

    if Input.key_release?(K_P) then
      $config.log.screen_shot("screen_shot_#{$config.screen_shot_count}.png")
      $config.screen_shot_count += 1
      @screen_shot_se.play if @screen_shot_se
    end

    if (@return_to_title_button and not @is_returnable and
      (@return_to_title_button.pushed? or @return_to_title_button.is_auto_clicked)) or Input.key_release?(K_E) then
      @return_to_title_button.is_auto_clicked = false

      @click_se.play if @click_se
      @is_returnable = true
    end

    if @ok_button and not @is_returnable and (@ok_button.pushed? or @ok_button.is_auto_clicked) then
      @click_se.play if @click_se
      if $config.scores[:technical_point] >= COMMENDATION_POINT then
        self.next_scene = EndingScene
      else
        if $config.is_ranking then
          self.next_scene = NameEntryScene
        else
          self.next_scene = TitleScene
        end
      end
    end

    if @buttons and not @buttons.empty? then
      @buttons.each do |button|
        if @is_returnable and (button.name == "return_to_title_ok_button" or
          button.name == "return_to_title_cancel_button") then
          button.hovered?
        elsif not @is_returnable and
          not (button.name == "return_to_title_ok_button" or button.name == "return_to_title_cancel_button") then
          button.hovered?
        end
      end
    end

    if @return_to_title_message_dialog and @is_returnable and
      (@return_to_title_message_dialog.ok_button.pushed? or @return_to_title_message_dialog.ok_button.is_auto_clicked) then
      @return_to_title_message_dialog.ok_button.is_auto_clicked = false

      @click_se.play if @click_se
      self.next_scene = TitleScene
      @is_returnable = false
    end

    if @return_to_title_message_dialog and @is_returnable and
      (@return_to_title_message_dialog.cancel_button.pushed? or
        @return_to_title_message_dialog.cancel_button.is_auto_clicked) then

      @return_to_title_message_dialog.cancel_button.is_auto_clicked = false
      @click_se.play if @click_se
      @is_returnable = false
    end

    @mouse.x, @mouse.y = Input.mouse_pos_x, Input.mouse_pos_y if @mouse

    @poi.update if @poi
  end

  def gazed(x, y, center_x, center_y)

    if @buttons and not @buttons.empty? then
      @buttons.each do |button|
        if button.is_enable then

          if x + center_x >= button.x and x + center_x <= button.x + button.width and
            y + center_y >= button.y and y + center_y <= button.y + button.height then

            if @is_returnable and (button.name == "return_to_title_ok_button" or
              button.name == "return_to_title_cancel_button") then
              button.is_auto_clicked = true
            elsif not @is_returnable and
              not (button.name == "return_to_title_ok_button" or button.name == "return_to_title_cancel_button") then
              button.is_auto_clicked = true
            end
          else
            button.is_auto_clicked = false
          end
        end
      end
    end
    @poi.mode = :search
  end

  def render

    Window.draw(0, 0, @background_image) if @background_image

    if @confettis and not @confettis.empty? then
      @confettis.each do |confetti|
        confetti.draw
      end
    end

    @title_label.draw if @title_label
    @score_label.draw if @score_label
    @catched_kingyo_number_label.draw if @catched_kingyo_number_label
    @catched_boss_number_label.draw if @catched_boss_number_label
    @max_combo_label.draw if @max_combo_label
    @technical_point_label.draw if @technical_point_label
    @cognomen_label.draw if @cognomen_label

    @ok_button.draw if @ok_button
    @return_to_title_button.draw if @return_to_title_button

    Window.draw(0, 0, @cover_layer) if @cover_layer and @is_returnable
    @return_to_title_message_dialog.draw if @return_to_title_message_dialog and @is_returnable

    @poi.draw if @poi
  end

  def will_disappear
  end
end


class NameEntryScene < Scene::Base

  require "net/http"
  require "./lib/dxruby/images"
  require "./lib/dxruby/color"

  require "./scripts/name_entry"
  require "./scripts/message_dialog"
  require "./scripts/loading_anime"

  include Color

  CLICK_SE = "./sounds/meka_ge_mouse_s02.wav"
  SCREEN_SHOT_SE = "./sounds/Camera-Phone01-1.wav"
  NAME_ENTRY_BGM = "./sounds/yuugure.mp3"

  NAME_ENTRY_BUTTON_IMAGE = "./images/942037.png"
  FLOOR_IMAGE = "./images/floor1.jpg"
  RESET_BUTTON_IMAGE = "./images/m_1.png"
  DECITION_BUTTON_IMAGE = "./images/m_2.png"
  DELETE_BUTTON_IMAGE = "./images/m_3.png"
  RETURN_TO_TITLE_BUTTON_IMAGE = "./images/s_3.png"
  OK_BUTTON_IMAGE = "./images/m_4.png"
  CANCEL_BUTTON_IMAGE = "./images/m_1.png"

  MAX_NAME_INPUT_NUMBER = 8
  WORDS_SIZE = [17, 5]

  MAX_COUNT_IN_WINDOW = 40
  MAX_COUNT_IN_GAZE_AREA = 30

  POI_HEIGHT_SIZE_RATIO = 0.2
  MAX_GAZE_COUNT = 15
  POI_GAZE_RADIUS_RATIO = 0.8

  RETRY_MAX_COUNT = 2 # 
  RETRY_WAIT_TIME = 3 # b
  REQUEST_TIMEOUT = 5 # b

  def init

    @click_se = Sound.new(CLICK_SE)
    @screen_shot_se = Sound.new(SCREEN_SHOT_SE)
    @bgm = Bass.loadSample(NAME_ENTRY_BGM)

    floor_image = Image.load(FLOOR_IMAGE)
    floor_image_scale = Window.height * 0.3 / floor_image.height.to_f
    floor_src_image = Images.scale_resize(floor_image, floor_image_scale, floor_image_scale)
    floor_rt = RenderTarget.new(Window.width, Window.height)
    floor_rt.drawTile(0, 0, [[0]], [floor_src_image], nil, nil, nil, nil)
    @floor_image = floor_rt.to_image
    floor_src_image.dispose
    floor_rt.dispose

    _title_label = Fonts.new(0, 0, "O̓", Window.height * 0.05, C_CUD_ACCENT_ORANGE, {:font_name=>"07mxPOP"})
    _title_label.edge = true
    _title_label.edge_width = _title_label.height * 0.05

    @title_label = Images.new((Window.width - _title_label.width) * 0.5, (Window.height - _title_label.height) * 0.02,
                              _title_label.width, _title_label.height)
    @title_label.image = _title_label.to_image
    _title_label.vanish

    interval_margin = Window.height * 0.04
    _score_label = Fonts.new(0, 0, "SCORE : #{$config.scores[:score]}_", Window.height * 0.05, C_CUD_ACCENT_GREEN,
                             {:font_name=>"R̗tHg"})
    _score_label.edge = true
    _score_label.edge_width = _score_label.height * 0.05

    _cognomen_label = Fonts.new(0, 0, "̍ : #{$config.scores[:cognomen]}",
                                Window.height * 0.05, $config.scores[:color], {:font_name=>"ʂ}WbN"})
    _cognomen_label.set_weight = true
    _cognomen_label.edge = true
    _cognomen_label.edge_width = _cognomen_label.height * 0.05

    @score_label = Images.new((Window.width - (_score_label.width + _cognomen_label.width + interval_margin)) * 0.5,
                              (Window.height - _score_label.height) * 0.1,
                              _score_label.width, _score_label.height)
    @score_label.image = _score_label.to_image
    _score_label.vanish

    @cognomen_label = Images.new(@score_label.x + @score_label.width + interval_margin,
                                 (Window.height - _cognomen_label.height) * 0.1,
                                 _cognomen_label.width, _cognomen_label.height)
    @cognomen_label.image = _cognomen_label.to_image
    _cognomen_label.vanish

    input_box_height = Window.height * 0.1
    @input_box = Images.new(0, 0, input_box_height * (MAX_NAME_INPUT_NUMBER - 1),
                            input_box_height, "", input_box_height * 0.85)
    @input_box.set_pos((Window.width - @input_box.width) * 0.5, (Window.height - @input_box.height) * 0.185)
    @input_box.set_string_pos((@input_box.width - (@input_box.font_size * MAX_NAME_INPUT_NUMBER)) * 0.5,
                              (@input_box.height - @input_box.font_size) * 0.5)
    @input_box.font_name = "ARȏM"
    @input_box.frame(C_CUD_ACCENT_BROWN, @input_box.height * 0.05)

    return_to_title_button_image = Image.load(RETURN_TO_TITLE_BUTTON_IMAGE)
    return_to_title_button_scale = Window.height * 0.05 / return_to_title_button_image.height
    return_to_title_button_converted_image =
      Images.scale_resize(return_to_title_button_image, return_to_title_button_scale, return_to_title_button_scale)

    @return_to_title_button = Button.new
    @return_to_title_button.set_image(return_to_title_button_converted_image)
    @return_to_title_button.set_string("", return_to_title_button_converted_image.height * 0.6,
                              "07mxPOP", {:color=>C_CUD_NON_COLORED_BLACK})
    @return_to_title_button.set_pos(Window.width - @return_to_title_button.width, 0)

    decision_button_image = Image.load(DECITION_BUTTON_IMAGE)
    @decision_button = Button.new(Window.width * 0.4, Window.height * 0.85, Window.width * 0.2, Window.height * 0.1,
                                  "", Window.height * 0.065, {:str_color=>C_CUD_NON_COLORED_BLACK, :font_name=>"07mxPOP"})
    @decision_button.set_image(Images.fit_resize(decision_button_image, Window.width * 0.2, Window.height * 0.1))

    reset_button_image = Image.load(RESET_BUTTON_IMAGE)
    @reset_button = Button.new(Window.width * 0.2, Window.height * 0.85, Window.width * 0.2, Window.height * 0.1,
                               "Zbg", Window.height * 0.065, {:str_color=>C_CUD_NON_COLORED_BLACK, :font_name=>"07mxPOP"})
    @reset_button.set_image(Images.fit_resize(reset_button_image, Window.width * 0.2, Window.height * 0.1))

    delete_button_image = Image.load(DELETE_BUTTON_IMAGE)
    @delete_button = Button.new(Window.width * 0.6, Window.height * 0.85, Window.width * 0.2, Window.height * 0.1,
                                "ꕶ", Window.height * 0.065, {:str_color=>C_CUD_NON_COLORED_BLACK, :font_name=>"07mxPOP"})
    @delete_button.set_image(Images.fit_resize(delete_button_image, Window.width * 0.2, Window.height * 0.1))

    name_entry_pre_width = Window.width * 0.96
    name_entry_button_width = name_entry_pre_width / WORDS_SIZE[0]
    name_entry_button_height = name_entry_button_width
    name_entry_button_image = Image.load(NAME_ENTRY_BUTTON_IMAGE)
    name_entry_button_x_scale =  name_entry_button_width / name_entry_button_image.width
    name_entry_button_y_scale = name_entry_button_height / name_entry_button_image.height
    name_entry_button_coverted_image = Images.scale_resize(name_entry_button_image,
                                                           name_entry_button_x_scale, name_entry_button_y_scale)
    name_entry_buttons_font_size = name_entry_button_height * 0.8

    @name_entry = NameEntry.new(0, 0, name_entry_button_width, name_entry_button_height, name_entry_buttons_font_size,
                               C_CUD_ACCENT_BROWN, C_CUD_NON_COLORED_WHITE, {:font_name=>"݂"})
    @name_entry.set_pos((Window.width - @name_entry.width) * 0.5 - WORDS_SIZE[0] * 0.5,
                        (Window.height - @name_entry.height) * 0.6 - WORDS_SIZE[1] * 0.5)
    @name_entry.set_image(name_entry_button_coverted_image)

    @input_box.string = $config.scores[:name]

    @mouse = Sprite.new
    @mouse.collision = [0, 0]

    @poi = Poi.new(0, 0, nil, Window.height * POI_HEIGHT_SIZE_RATIO, :click, @mouse,
                   MAX_GAZE_COUNT, self, nil, true, {:max_count_in_window=>MAX_COUNT_IN_WINDOW,
                                               :gaze_radius_ratio=>POI_GAZE_RADIUS_RATIO,
                                               :max_count_in_gaze_area=>MAX_COUNT_IN_GAZE_AREA})
    @poi.set_pos((Window.width - @poi.width) * 0.5, (Window.height - @poi.height) * 0.5)

    @bgm.play(:loop=>true, :volume=>0.5)

    @cover_layer = Image.new(Window.width, Window.height, [196, 128, 128, 128])

    @is_connect_error = false
    @loading_kingyo = LoadingAnime.new(0, 0, nil, Window.width * 0.2)
    @loading_kingyo.set_pos(0, Window.height - @loading_kingyo.height)

    connect_error_message_dialog_height = Window.height * 0.4
    connect_error_message_dialog_width = connect_error_message_dialog_height * 2
    connect_error_message_dialog_option = {:frame_thickness=>connect_error_message_dialog_height * 0.04,
                                           :radius=>connect_error_message_dialog_height * 0.06,
                                           :bg_color=>C_CUD_NON_COLORED_WHITE, :frame_color=>C_CUD_BASE_LIGHT_YELLOW_GREEN}

    @connect_error_message_dialog = MessageDialog.new(0, 0, connect_error_message_dialog_width,
                                                      connect_error_message_dialog_height,
                                                      0, connect_error_message_dialog_option)
    @connect_error_message_dialog.set_message("ʐMG[c", "^Cgɖ߂܂B",
                                              @connect_error_message_dialog.height * 0.25, C_CUD_ACCENT_RED, "݂")
    @connect_error_message_dialog.set_pos((Window.width - @connect_error_message_dialog.width) * 0.5,
                                          (Window.height - @connect_error_message_dialog.height) * 0.5)

    @connect_error_message_dialog.ok_button.font_color = C_CUD_NON_COLORED_BLACK
    @connect_error_message_dialog.ok_button.font_name = "07mxPOP"
    @connect_error_message_dialog.ok_button.name = "connect_error_ok_button"

    ok_button_image = Image.load(OK_BUTTON_IMAGE)
    @connect_error_message_dialog.ok_button.set_image(Images.fit_resize(ok_button_image,
                                                                        @connect_error_message_dialog.ok_button.width,
                                                                        @connect_error_message_dialog.ok_button.height))

    return_to_title_message_dialog_height = Window.height * 0.4
    return_to_title_message_dialog_width = return_to_title_message_dialog_height * 2
    return_to_title_message_dialog_option = {:frame_thickness=>return_to_title_message_dialog_height * 0.04,
                                             :radius=>return_to_title_message_dialog_height * 0.06,
                                             :bg_color=>C_CREAM, :frame_color=>C_CUD_ACCENT_ORANGE}

    @return_to_title_message_dialog = MessageDialog.new(0, 0, return_to_title_message_dialog_width,
                                                        return_to_title_message_dialog_height, 1,
                                                        return_to_title_message_dialog_option)
    @return_to_title_message_dialog.set_message("^Cgɖ߂܂H", "",
                                @return_to_title_message_dialog.height * 0.15, C_CUD_ACCENT_BROWN, "݂")
    @return_to_title_message_dialog.set_pos((Window.width - @return_to_title_message_dialog.width) * 0.5,
                            (Window.height - @return_to_title_message_dialog.height) * 0.5)

    @return_to_title_message_dialog.ok_button.font_color = C_CUD_NON_COLORED_BLACK
    @return_to_title_message_dialog.ok_button.font_name = "07mxPOP"
    @return_to_title_message_dialog.ok_button.name = "return_ok_button"

    @return_to_title_message_dialog.cancel_button.font_color = C_CUD_NON_COLORED_BLACK
    @return_to_title_message_dialog.cancel_button.font_name = "07mxPOP"
    @return_to_title_message_dialog.cancel_button.name = "return_cancel_button"

    ok_button_image = Image.load(OK_BUTTON_IMAGE)
    @return_to_title_message_dialog.ok_button.set_image(
      Images.fit_resize(ok_button_image, @return_to_title_message_dialog.ok_button.width,
                        @return_to_title_message_dialog.ok_button.height))

    cancel_button_image = Image.load(CANCEL_BUTTON_IMAGE)
    @return_to_title_message_dialog.cancel_button.set_image(Images.fit_resize(
      cancel_button_image, @return_to_title_message_dialog.cancel_button.width,
      @return_to_title_message_dialog.cancel_button.height))

    @is_returnable = false

    @buttons = [@return_to_title_button, @decision_button, @reset_button, @delete_button,
                @connect_error_message_dialog.ok_button, @return_to_title_message_dialog.ok_button,
                @return_to_title_message_dialog.cancel_button]
  end

  def update

    if Input.key_release?(K_ESCAPE) then
      $config.eyemot_mouse.close
      exit
    end

    if Input.key_release?(K_W) then
      if Window.windowed? then
        Window.windowed = false
      else
        Window.windowed = true
      end
      @click_se.play if @click_se
    end

    if Input.key_release?(K_X) then
      if not $config.eyemot_mouse.mode == :off then
        $config.eyemot_mouse.eye_off
      elsif $config.eyemot_mouse.mode == :off
        $config.eyemot_mouse.eye_on
      end
    end

    if Input.key_release?(K_P) then
      $config.log.screen_shot("screen_shot_#{$config.screen_shot_count}.png")
      $config.screen_shot_count += 1
      @screen_shot_se.play if @screen_shot_se
    end

    if (@return_to_title_button and not @is_connect_error and not @loading_kingyo.is_anime and not @is_returnable and
      (@return_to_title_button.pushed? or @return_to_title_button.is_auto_clicked)) or Input.key_release?(K_E) then
      @return_to_title_button.is_auto_clicked = false

      @click_se.play if @click_se
      @is_returnable = true
    end

    if @name_entry and not @is_connect_error and not @loading_kingyo.is_anime and not @is_returnable then
      @name_entry.word_buttons.each do |word_button|
        if word_button.pushed? or word_button.is_auto_clicked then
          word_button.is_auto_clicked = false
          @click_se.play if @click_se
          if $config.scores[:name].size < MAX_NAME_INPUT_NUMBER * 2 then
            $config.scores[:name] += word_button.string
            @input_box.string = $config.scores[:name]
          end
        end
        word_button.hovered?
      end
    end

    if @decision_button and not @is_connect_error and not @loading_kingyo.is_anime and not @is_returnable and
      (@decision_button.pushed? or @decision_button.is_auto_clicked) then
      @decision_button.is_auto_clicked = false
      @click_se.play if @click_se

      Thread.new do
        @loading_kingyo.is_anime = true

        retry_count = 0
        begin
          self.send_to_database
          @loading_kingyo.is_anime = false
          self.next_scene = RankingScene
          self.will_disappear
        rescue
          if retry_count < RETRY_MAX_COUNT
            sleep RETRY_WAIT_TIME
            retry_count += 1
            retry
          else
            @is_connect_error = true
            @loading_kingyo.is_anime = false
            self.will_disappear
            false
          end
        end
      end
    end

    if @reset_button and not @is_connect_error and not @loading_kingyo.is_anime and not @is_returnable and
      (@reset_button.pushed? or @reset_button.is_auto_clicked) then
      @reset_button.is_auto_clicked = false
      @click_se.play if @click_se
      $config.scores[:name] = ""
      @input_box.string = $config.scores[:name]
    end

    if @delete_button and not @is_connect_error and not @loading_kingyo.is_anime and not @is_returnable and
      (@delete_button.pushed? or @delete_button.is_auto_clicked) then
      @delete_button.is_auto_clicked = false
      @click_se.play if @click_se
      if $config.scores[:name].size > 0 then
        $config.scores[:name].chop!
        @input_box.string = $config.scores[:name]
      end
    end

    if @buttons and not @buttons.empty? then
      @buttons.each do |button|
        if @is_connect_error or @loading_kingyo.is_anime or @is_returnable and
          (button.name == "connect_error_ok_button" or button.name == "return_ok_button" or
            button.name == "return_cancel_button") then
          button.hovered?
        elsif not @is_connect_error and not @loading_kingyo.is_anime and not @is_returnable and
          not (button.name == "connect_error_ok_button" or button.name == "return_ok_button" or
            button.name == "return_cancel_button") then
          button.hovered?
        end
      end
    end

    if @connect_error_message_dialog and @is_connect_error and (@connect_error_message_dialog.ok_button.pushed? or
      @connect_error_message_dialog.ok_button.is_auto_clicked) then
      @connect_error_message_dialog.ok_button.is_auto_clicked = false
      @click_se.play if @click_se
      self.next_scene = TitleScene
    end

    if @return_to_title_message_dialog and @is_returnable and
      (@return_to_title_message_dialog.ok_button.pushed? or @return_to_title_message_dialog.ok_button.is_auto_clicked) then
      @return_to_title_message_dialog.ok_button.is_auto_clicked = false

      @click_se.play if @click_se
      @bgm.stop
      @bgm = nil
      self.next_scene = TitleScene
      @is_returnable = false
    end

    if @return_to_title_message_dialog and @is_returnable and
      (@return_to_title_message_dialog.cancel_button.pushed? or
        @return_to_title_message_dialog.cancel_button.is_auto_clicked) then

      @return_to_title_message_dialog.cancel_button.is_auto_clicked = false
      @click_se.play if @click_se
      @is_returnable = false
    end

    @mouse.x, @mouse.y = Input.mouse_pos_x, Input.mouse_pos_y

    @poi.update if @poi

    @loading_kingyo.update if @loading_kingyo.is_anime
  end

  def gazed(x, y, center_x, center_y)

    if @buttons and not @buttons.empty? then
      @buttons.each do |button|
        if button.is_enable then

          if button and x + center_x >= button.x and x + center_x <= button.x + button.width and
            y + center_y >= button.y and y + center_y <= button.y + button.height then

            if @is_connect_error or @loading_kingyo.is_anime or @is_returnable and
              (button.name == "connect_error_ok_button" or button.name == "return_ok_button" or
                button.name == "return_cancel_button") then
              button.is_auto_clicked = true
            elsif not @is_connect_error and not @loading_kingyo.is_anime and not @is_returnable and
              not (button.name == "connect_error_ok_button" or button.name == "return_ok_button" or
                button.name == "return_cancel_button") then
              button.is_auto_clicked = true
            end
          else
            button.is_auto_clicked = false
          end
        end
      end
    end

    if @name_entry and not @is_connect_error and not @loading_kingyo.is_anime and not @is_returnable then
      @name_entry.word_buttons.each do |word_button|
        if x + center_x >= word_button.x and x + center_x <= word_button.x + word_button.width and
          y + center_y >= word_button.y and y + center_y <= word_button.y + word_button.height then
          word_button.is_auto_clicked = true
        end
      end
    end

    @poi.mode = :search
  end

  def send_to_database

    uri = URI.parse($config.post_url)
    http = Net::HTTP.new(uri.host, uri.port)
    http.open_timeout = REQUEST_TIMEOUT

    req = Net::HTTP::Post.new(uri.path)
    req.set_form_data({:name=>$config.scores[:name].encode("UTF-8"), :score=>$config.scores[:score],
                       :cognomen=>$config.scores[:cognomen].encode("UTF-8")})

    http.request(req)
  end

  def render

    Window.draw(0, 0, @floor_image) if @floor_image

    @title_label.draw if @title_label
    @score_label.draw if @score_label
    @cognomen_label.draw if @cognomen_label

    @return_to_title_button.draw if @return_to_title_button
    @name_entry.draw if @name_entry
    @input_box.draw if @input_box

    @decision_button.draw if @decision_button
    @reset_button.draw if @reset_button
    @delete_button.draw if @delete_button

    @loading_kingyo.draw if @loading_kingyo.is_anime

    Window.draw(0, 0, @cover_layer) if @cover_layer and (@is_connect_error or @is_returnable)

    @return_to_title_message_dialog.draw if @return_to_title_message_dialog and @is_returnable
    @connect_error_message_dialog.draw if @connect_error_message_dialog and @is_connect_error

    @poi.draw if @poi
  end

  def will_disappear
    if @bgm then
      @bgm.stop
      @bgm = nil
    end
  end
end


class RankingScene < Scene::Base

  require "rubygems"
  require "json" # gem install json -v 1.8.6

  require "net/http"
  require "time"

  require "./lib/encode" # R[hϊ
  require "./lib/dxruby/color"
  require "./lib/dxruby/images"

  require "./scripts/message_dialog"
  require "./scripts/loading_anime"

  require "./scripts/score_list_box"
  require "./scripts/bubble"

  include Color

  CLICK_SE = "./sounds/meka_ge_mouse_s02.wav"
  SCREEN_SHOT_SE = "./sounds/Camera-Phone01-1.wav"
  PAGE_UP_BUTTON = "./images/1396945_up.png"
  PAGE_DOWN_BUTTON = "./images/1396945_down.png"
  OK_BUTTON_IMAGE = "./images/m_4.png"
  RETURN_TO_TITLE_BUTTON_IMAGE = "./images/m_1.png"

  MAX_COUNT_IN_WINDOW = 40
  MAX_COUNT_IN_GAZE_AREA = 30

  POI_HEIGHT_SIZE_RATIO = 0.2
  MAX_GAZE_COUNT = 15
  POI_GAZE_RADIUS_RATIO = 0.8

  RETRY_MAX_COUNT = 2 # 
  RETRY_WAIT_TIME = 3 # b

  SCROLL_SPEED_RATIO = 0.015

  def init

    @background_image = Image.new(Window.width, Window.height, C_CUD_BASE_LIGHT_SKY)

    _title_label = Fonts.new(0, 0, "LO TOP100", Window.height * 0.07, C_CUD_ACCENT_BLUE,
                             {:font_name=>"`FbN|CgtHg"})
    _title_label.edge = true
    _title_label.edge_width = _title_label.height * 0.05

    @title_label = Images.new((Window.width - _title_label.width) * 0.5, (Window.height - _title_label.height) * 0.04,
                              _title_label.width, _title_label.height)
    @title_label.image = _title_label.to_image
    _title_label.vanish

    return_to_title_button_image = Image.load(RETURN_TO_TITLE_BUTTON_IMAGE)
    @return_to_title_button = Button.new(Window.width * 0.4, Window.height * 0.85, Window.width * 0.2,
                                Window.height * 0.1, "^Cgɖ߂",
                                Window.height * 0.045, {:str_color=>C_CUD_NON_COLORED_BLACK, :font_name=>"07mxPOP"})
    @return_to_title_button.set_image(Images.fit_resize(return_to_title_button_image, Window.width * 0.2,
                                                        Window.height * 0.1))

    page_up_button_image = Image.load(PAGE_UP_BUTTON)
    page_up_button_scale = Window.height * 0.15 / page_up_button_image.height
    page_up_button_converted_image = Images.scale_resize(page_up_button_image,
                                                         page_up_button_scale, page_up_button_scale)
    @page_up_button = Button.new
    @page_up_button.set_image(page_up_button_converted_image)
    @page_up_button.set_pos((Window.width - @page_up_button.width) * 0.963,
                            (Window.height - @page_up_button.height) * 0.35)

    page_down_button_image = Image.load(PAGE_DOWN_BUTTON)
    page_down_button_scale = Window.height * 0.15 / page_down_button_image.height
    page_down_button_converted_image = Images.scale_resize(page_down_button_image,
                                                           page_down_button_scale, page_down_button_scale)
    @page_down_button = Button.new
    @page_down_button.set_image(page_down_button_converted_image)
    @page_down_button.set_pos((Window.width - @page_down_button.width) * 0.96,
                              (Window.height - @page_down_button.height) * 0.65)

    @buttons = [@return_to_title_button, @page_up_button, @page_down_button]

    @click_se = Sound.new(CLICK_SE)
    @screen_shot_se = Sound.new(SCREEN_SHOT_SE)

    bubble_scale_up_speed_min = 1
    bubble_scale_up_speed_max = bubble_scale_up_speed_min * 1.004
    bubble_accel_min = 0.005
    bubble_accel_max = bubble_accel_min * 10
    bubble_amplification_speed_min = 1
    bubble_amplification_speed_max = bubble_amplification_speed_min * 10
    bubble_angular_velo_up_speed_min = 1
    bubble_angular_velo_up_speed_max = bubble_angular_velo_up_speed_min * 10

    @bubbles = []
    800.times do
      bubble = Bubble.new(-1 * Window.height * 0.5, [0, 0], [0, 0],
                          [bubble_scale_up_speed_min, bubble_scale_up_speed_max],
                          [bubble_accel_min, bubble_accel_max],
                          [bubble_amplification_speed_min, bubble_amplification_speed_max],
                          [bubble_angular_velo_up_speed_min, bubble_angular_velo_up_speed_max])
      bubble.set_x([-1 * bubble.width * Math.sqrt(2), Window.width + (bubble.width * Math.sqrt(2))])
      bubble.set_y([Window.height + bubble.height, Window.height * 1.1])
      @bubbles.push(bubble)
    end

    @mouse = Sprite.new
    @mouse.collision = [0, 0]

    @poi = Poi.new(0, 0, nil, Window.height * POI_HEIGHT_SIZE_RATIO, :click, @mouse,
                   MAX_GAZE_COUNT, self, nil, true, {:max_count_in_window=>MAX_COUNT_IN_WINDOW,
                                               :gaze_radius_ratio=>POI_GAZE_RADIUS_RATIO,
                                               :max_count_in_gaze_area=>MAX_COUNT_IN_GAZE_AREA})
    @poi.set_pos((Window.width - @poi.width) * 0.5, (Window.height - @poi.height) * 0.5)

    @cover_layer = Image.new(Window.width, Window.height, [196, 128, 128, 128])

    @is_connect_error = false
    @loading_kingyo = LoadingAnime.new(0, 0, nil, Window.width * 0.2)
    @loading_kingyo.set_pos(0, Window.height - @loading_kingyo.height)

    connect_error_message_dialog_height = Window.height * 0.4
    connect_error_message_dialog_width = connect_error_message_dialog_height * 2
    connect_error_message_dialog_option = {:frame_thickness=>connect_error_message_dialog_height * 0.04,
                                           :radius=>connect_error_message_dialog_height * 0.06,
                                           :bg_color=>C_CUD_BASE_CREAM, :frame_color=>C_CUD_ACCENT_YELLOW}

    @connect_error_message_dialog = MessageDialog.new(0, 0,
                                                      connect_error_message_dialog_width,
                                                      connect_error_message_dialog_height, 0,
                                                      connect_error_message_dialog_option)
    @connect_error_message_dialog.set_message("ʐMG[c", "^Cgɖ߂܂B",
                                @connect_error_message_dialog.height * 0.25, C_CUD_ACCENT_RED, "݂")
    @connect_error_message_dialog.set_pos((Window.width - @connect_error_message_dialog.width) * 0.5,
                            (Window.height - @connect_error_message_dialog.height) * 0.5)

    @connect_error_message_dialog.ok_button.font_color = C_CUD_NON_COLORED_BLACK
    @connect_error_message_dialog.ok_button.font_name = "07mxPOP"
    @connect_error_message_dialog.ok_button.name = "connect_error_ok_button"

    ok_button_image = Image.load(OK_BUTTON_IMAGE)
    @connect_error_message_dialog.ok_button.
      set_image(Images.fit_resize(ok_button_image, @connect_error_message_dialog.ok_button.width,
                                  @connect_error_message_dialog.ok_button.height))

    @buttons.push(@connect_error_message_dialog.ok_button)

    Thread.new do
      @loading_kingyo.is_anime = true

      retry_count = 0
      begin
        results = self.load_from_database

        items = []
        colors = []

        results.each_with_index do |result, index|

          result.unshift("#{index + 1}")
          result[2] += "_"
          items.push(result)

          color = C_CUD_ACCENT_BROWN if result[3] == "ER"
          color = C_CUD_ACCENT_PURPLE if result[3] == "UR"
          color = C_CUD_ACCENT_ORANGE if result[3] == "S҃y["
          color = C_CUD_ACCENT_PINK if result[3] == "ʃ^"
          color = C_CUD_ACCENT_SKY if result[3] == "ǂ"
          color = C_CUD_ACCENT_BLUE if result[3] == "X[p[Ju"
          color = C_CUD_ACCENT_GREEN if result[3] == "WFh"
          color = C_CUD_ACCENT_YELLOW if result[3] == "l"
          color = C_CUD_ACCENT_RED if result[3] == "_"
          colors.push(color)
        end

        self.make_list_box(items, colors)
        @loading_kingyo.is_anime = false
      rescue => e
        p e
        if retry_count < RETRY_MAX_COUNT
          sleep RETRY_WAIT_TIME
          retry_count += 1
          retry
        else
          @is_connect_error = true
          @loading_kingyo.is_anime = false
          false
        end
      end
    end
  end

  def load_from_database

    uri = URI.parse($config.get_url)

    # 2Hashw肷邱ƂPOSTۂ̃f[^wo
    response = Net::HTTP.post_form(uri, {})

    jsons = JSON.parse(response.body)

    raws = []
    results = []

    for json in jsons do
      raws << json["name"].to_s.encode("Shift_JIS")
      raws << json["score"].to_s
      raws << json["cognomen"].to_s.encode("Shift_JIS")
      raws << Time.parse(json["created_at"]).strftime("%YN%m%d %H%M%Sb")
      results << raws
      raws = []
    end

    return results
  end

  def make_list_box(items, colors)
    @list_box = ScoreListBox.new(0, 0, Window.width * 0.74, Window.height * 0.68,
                                 Window.height * SCROLL_SPEED_RATIO)
    @list_box.set_pos((Window.width - @list_box.width) * 0.5, (Window.height - @list_box.height) * 0.42)
    @list_box.set_items(items, [2, 5, 4, 3, 5], C_CUD_ACCENT_BLUE,
                        colors, 3, "݂")
  end

  def update

    if Input.key_release?(K_ESCAPE) then
      $config.eyemot_mouse.close
      exit
    end

    if Input.key_release?(K_W) then
      if Window.windowed? then
        Window.windowed = false
      else
        Window.windowed = true
      end
      @click_se.play if @click_se
    end

    if Input.key_release?(K_X) then
      if not $config.eyemot_mouse.mode == :off then
        $config.eyemot_mouse.eye_off
      elsif $config.eyemot_mouse.mode == :off
        $config.eyemot_mouse.eye_on
      end
    end

    if Input.key_release?(K_P) then
      $config.log.screen_shot("screen_shot_#{$config.screen_shot_count}.png")
      $config.screen_shot_count += 1
      @screen_shot_se.play if @screen_shot_se
    end

    if @return_to_title_button and not @is_connect_error and not @loading_kingyo.is_anime and
      (@return_to_title_button.pushed? or @return_to_title_button.is_auto_clicked) then

      @return_to_title_button.is_auto_clicked = false
      @click_se.play
      self.next_scene = TitleScene
    end

    if @page_up_button and not @is_connect_error and not @loading_kingyo.is_anime and
      (@page_up_button.pushed? or @page_up_button.is_auto_clicked) then

      @page_up_button.is_auto_clicked = false
      @click_se.play
      @list_box.scroll_up
    end

    if @page_down_button and not @is_connect_error and not @loading_kingyo.is_anime and
      (@page_down_button.pushed? or @page_down_button.is_auto_clicked) then

      @page_down_button.is_auto_clicked = false
      @click_se.play
      @list_box.scroll_down
    end


    if @buttons and not @buttons.empty? then
      @buttons.each do |button|
        if @is_connect_error or @loading_kingyo.is_anime and button.name == "connect_error_ok_button" then
          button.hovered?
        elsif not @is_connect_error and not @loading_kingyo.is_anime and
          not button.name == "connect_error_ok_button" then
          button.hovered?
        end
      end
    end

    if @connect_error_message_dialog and @is_connect_error and
      (@connect_error_message_dialog.ok_button.pushed? or @connect_error_message_dialog.ok_button.is_auto_clicked) then
      @connect_error_message_dialog.ok_button.is_auto_clicked = false

      @click_se.play if @click_se
      self.next_scene = TitleScene
    end

    @mouse.x, @mouse.y = Input.mouse_pos_x, Input.mouse_pos_y

    @poi.update if @poi

    @loading_kingyo.update if @loading_kingyo.is_anime

    @list_box.update if @list_box

    if @bubbles and not @bubbles.empty? then
      @bubbles.each do |bubble|
        bubble.update
      end
    end
  end

  def gazed(x, y, center_x, center_y)

    if @buttons and not @buttons.empty? then
      @buttons.each do |button|
        if button.is_enable then

          if button and x + center_x >= button.x and x + center_x <= button.x + button.width and
            y + center_y >= button.y and y + center_y <= button.y + button.height then

            if @is_connect_error or @loading_kingyo.is_anime and button.name == "connect_error_ok_button" then
              button.is_auto_clicked = true
            elsif not @is_connect_error and not @loading_kingyo.is_anime and
              not button.name == "connect_error_ok_button" then
              button.is_auto_clicked = true
            end
          else
            button.is_auto_clicked = false
          end
        end
      end
    end
    @poi.mode = :search
  end

  def render

    Window.draw(0, 0, @background_image) if @background_image

    if @bubbles and not @bubbles.empty? then
      @bubbles.each do |bubble|
        bubble.draw
      end
    end

    @list_box.draw if @list_box

    @title_label.draw if @title_label
    @return_to_title_button.draw if @return_to_title_button

    @page_up_button.draw if @page_up_button
    @page_down_button.draw if @page_down_button

    @loading_kingyo.draw if @loading_kingyo.is_anime

    Window.draw(0, 0, @cover_layer) if @cover_layer and @is_connect_error
    @connect_error_message_dialog.draw if @connect_error_message_dialog and @is_connect_error

    @poi.draw if @poi
  end

  def will_disappear
  end
end


class EndingScene < Scene::Base

  require "./lib/files"
  require "./lib/common"
  require "./lib/dxruby/images"
  require "./lib/dxruby/color"

  require "./scripts/message_dialog"
  require "./scripts/sprite_font"
  require "./scripts/illust"

  include Files
  include Common
  include Color

  BACKGROUND_IMAGE = "./images/BG00a1_80a.jpg"
  STAFF_DATA_FILE = "./data/staff.csv"
  ENDING_BGM = "./sounds/itsuka_miagete_ta_tooi_sora.mp3"
  CLICK_SE = "./sounds/meka_ge_mouse_s02.wav"
  SCREEN_SHOT_SE = "./sounds/Camera-Phone01-1.wav"

  RETURN_TO_TITLE_BUTTON_IMAGE = "./images/s_3.png"
  OK_BUTTON_IMAGE = "./images/m_4.png"
  CANCEL_BUTTON_IMAGE = "./images/m_1.png"

  BASE_FONT_SIZE_RATIO = 0.06
  FONT_SHADOW_OFF_SET_X = 3
  FONT_SHADOW_OFF_SET_Y = 3
  BASE_Y_INTERVAL = 100

  BGM_TIME = 89
  MAX_NEXT_SCENE_WAIT_COUNT = 300
  ILLUST_RELATIVE_SCALES = [0.18, 0.14, 0.18, 0.24, 0.38, 0.21]
  ILLUST_MAX_NUMBER = 15
  NUMBER_OF_ILLUST = 6

  MAX_COUNT_IN_WINDOW = 40
  MAX_COUNT_IN_GAZE_AREA = 30

  POI_HEIGHT_SIZE_RATIO = 0.2
  MAX_GAZE_COUNT = 15
  POI_GAZE_RADIUS_RATIO = 0.8

  POI_CATCH_ADJUST_RANGE_RATIO = 1.0

  def init

    @click_se = Sound.new(CLICK_SE)
    @screen_shot_se = Sound.new(SCREEN_SHOT_SE)

    staff_datas = csvReadArray(STAFF_DATA_FILE)

    @sprite_fonts = []
    sum_interval = 0

    staff_datas.each do |staff_data|
      sprite_font = SpriteFont.new(0, 0, staff_data[0], Window.height * BASE_FONT_SIZE_RATIO * staff_data[1].to_f,
                                   hex_to_rgb(staff_data[2].hex).values, C_DEFAULT,
                                   {:font_name=>staff_data[3], :shadow=>true, :shadow_color=>C_CUD_NON_COLORED_GRAY,
                                    :shadow_x=>FONT_SHADOW_OFF_SET_X, :shadow_y=>FONT_SHADOW_OFF_SET_Y, :edge=>true})
      sum_interval += BASE_Y_INTERVAL * staff_data[4].to_f
      sprite_font.set_pos((Window.width - sprite_font.width) * 0.5, Window.height + sum_interval)
      @sprite_fonts.push(sprite_font)
    end

    max_scroll_range = @sprite_fonts[-1].y + (Window.height + @sprite_fonts[-1].height) * 0.6
    @scroll_speed = max_scroll_range / BGM_TIME / 60

    background_image = Image.load(BACKGROUND_IMAGE)
    @background_image = Images.fit_resize(background_image, Window.width, Window.height)

    @mouse = Sprite.new
    @mouse.collision = [0, 0]

    @poi = Poi.new(0, 0, nil, Window.height * POI_HEIGHT_SIZE_RATIO, :click, @mouse,
                   MAX_GAZE_COUNT, self, nil, true, {:max_count_in_window=>MAX_COUNT_IN_WINDOW,
                                               :gaze_radius_ratio=>POI_GAZE_RADIUS_RATIO,
                                               :max_count_in_gaze_area=>MAX_COUNT_IN_GAZE_AREA})
    @poi.set_pos((Window.width - @poi.width) * 0.5, (Window.height - @poi.height) * 0.5)

    @illusts = []
    ILLUST_MAX_NUMBER.times do
      illust_number = rand(NUMBER_OF_ILLUST)
      relative_size = Window.height * ILLUST_RELATIVE_SCALES[illust_number]
      illust = Illust.new(illust_number, relative_size, [0, 0, Window.width, Window.height], @poi)
      @illusts.push(illust)
    end

    return_to_title_button_image = Image.load(RETURN_TO_TITLE_BUTTON_IMAGE)
    return_to_title_button_scale = Window.height * 0.05 / return_to_title_button_image.height
    return_to_title_button_converted_image =
      Images.scale_resize(return_to_title_button_image, return_to_title_button_scale, return_to_title_button_scale)

    @return_to_title_button = Button.new
    @return_to_title_button.set_image(return_to_title_button_converted_image)
    @return_to_title_button.set_string("", return_to_title_button_converted_image.height * 0.6,
                            "07mxPOP", {:color=>C_CUD_NON_COLORED_BLACK})
    @return_to_title_button.set_pos(Window.width - @return_to_title_button.width, 0)

    @cover_layer = Image.new(Window.width, Window.height, [196, 128, 128, 128])

    return_to_title_message_dialog_height = Window.height * 0.4
    return_to_title_message_dialog_width = return_to_title_message_dialog_height * 2
    return_to_title_message_dialog_option = {:frame_thickness=>return_to_title_message_dialog_height * 0.04,
                                             :radius=>return_to_title_message_dialog_height * 0.06,
                                             :bg_color=>C_CREAM, :frame_color=>C_CUD_ACCENT_ORANGE}

    @return_to_title_message_dialog = MessageDialog.new(0, 0, return_to_title_message_dialog_width,
                                                        return_to_title_message_dialog_height, 1,
                                                        return_to_title_message_dialog_option)
    @return_to_title_message_dialog.set_message("^Cgɖ߂܂H", "",
                                @return_to_title_message_dialog.height * 0.15, C_CUD_ACCENT_BROWN, "݂")
    @return_to_title_message_dialog.set_pos((Window.width - @return_to_title_message_dialog.width) * 0.5,
                            (Window.height - @return_to_title_message_dialog.height) * 0.5)

    @return_to_title_message_dialog.ok_button.font_color = C_CUD_NON_COLORED_BLACK
    @return_to_title_message_dialog.ok_button.font_name = "07mxPOP"
    @return_to_title_message_dialog.ok_button.name = "return_to_title_ok_button"

    @return_to_title_message_dialog.cancel_button.font_color = C_CUD_NON_COLORED_BLACK
    @return_to_title_message_dialog.cancel_button.font_name = "07mxPOP"
    @return_to_title_message_dialog.cancel_button.name = "return_to_title_cancel_button"

    ok_button_image = Image.load(OK_BUTTON_IMAGE)
    @return_to_title_message_dialog.ok_button.set_image(
      Images.fit_resize(ok_button_image, @return_to_title_message_dialog.ok_button.width,
                        @return_to_title_message_dialog.ok_button.height))

    cancel_button_image = Image.load(CANCEL_BUTTON_IMAGE)
    @return_to_title_message_dialog.cancel_button.set_image(Images.fit_resize(
      cancel_button_image, @return_to_title_message_dialog.cancel_button.width,
      @return_to_title_message_dialog.cancel_button.height))

    @buttons = [@return_to_title_button, @return_to_title_message_dialog.ok_button,
                @return_to_title_message_dialog.cancel_button]

    @bgm = Bass.loadSample(ENDING_BGM)
    @bgm.play(:loop=>false, :volume=>0.5)

    @next_scene_wait_count = 0
    @is_returnable = false
  end

  def update

    if @sprite_fonts and not @sprite_fonts.empty? and @sprite_fonts[-1].y <=
      (Window.height - @sprite_fonts[-1].height) * 0.6 then

      if @next_scene_wait_count < MAX_NEXT_SCENE_WAIT_COUNT then
        @next_scene_wait_count += 1
      else
        @next_scene_wait_count = 0
        if $config.is_ranking then
          self.next_scene = NameEntryScene
        else
          self.next_scene = TitleScene
        end
      end
    else
      if @sprite_fonts and not @sprite_fonts.empty? then
        @sprite_fonts.each do |sprite_font|
          sprite_font.y -= @scroll_speed
        end
      end
    end

    if @illusts and not @illusts.empty? then
      @illusts.each do |illust|
        illust.update
      end
    end

    if Input.key_release?(K_ESCAPE) then
      $config.eyemot_mouse.close
      exit
    end

    if Input.key_release?(K_W) then
      if Window.windowed? then
        Window.windowed = false
      else
        Window.windowed = true
      end
      @click_se.play if @click_se
    end

    if Input.key_release?(K_X) then
      if not $config.eyemot_mouse.mode == :off then
        $config.eyemot_mouse.eye_off
      elsif $config.eyemot_mouse.mode == :off
        $config.eyemot_mouse.eye_on
      end
    end

    if Input.key_release?(K_P) then
      $config.log.screen_shot("screen_shot_#{$config.screen_shot_count}.png")
      $config.screen_shot_count += 1
      @screen_shot_se.play if @screen_shot_se
    end

    if (@return_to_title_button and not @is_returnable and
      (@return_to_title_button.pushed? or @return_to_title_button.is_auto_clicked)) or Input.key_release?(K_E) then
      @return_to_title_button.is_auto_clicked = false

      @click_se.play if @click_se
      @is_returnable = true
    end

    if @buttons and not @buttons.empty? then
      @buttons.each do |button|
        if @is_returnable and (button.name == "return_to_title_ok_button" or
          button.name == "return_to_title_cancel_button") then
          button.hovered?
        elsif not @is_returnable and
          not (button.name == "return_to_title_ok_button" or button.name == "return_to_title_cancel_button") then
          button.hovered?
        end
      end
    end

    if @return_to_title_message_dialog and
      (@return_to_title_message_dialog.ok_button.pushed? or
        @return_to_title_message_dialog.ok_button.is_auto_clicked) and @is_returnable then
      @return_to_title_message_dialog.ok_button.is_auto_clicked = false

      @click_se.play if @click_se
      @bgm.stop
      @bgm = nil
      self.next_scene = TitleScene
      @is_returnable = false
    end

    if @return_to_title_message_dialog and
      (@return_to_title_message_dialog.cancel_button.pushed? or
        @return_to_title_message_dialog.cancel_button.is_auto_clicked) and @is_returnable then
      @return_to_title_message_dialog.cancel_button.is_auto_clicked = false

      @click_se.play if @click_se
      @is_returnable = false
    end

    @mouse.x, @mouse.y = Input.mouse_pos_x, Input.mouse_pos_y if @mouse

    @poi.update if @poi

    Sprite.check(@illusts + [@poi]) if @illusts and not @illusts.empty? and @poi
  end

  def gazed(x, y, center_x, center_y)

    if @buttons and not @buttons.empty? then
      @buttons.each do |button|
        if button.is_enable then

          if x + center_x >= button.x and x + center_x <= button.x + button.width and
            y + center_y >= button.y and y + center_y <= button.y + button.height then

            if @is_returnable and
              (button.name == "return_to_title_ok_button" or button.name == "return_to_title_cancel_button") then
              button.is_auto_clicked = true
            elsif not @is_returnable and
              not (button.name == "return_to_title_ok_button" or button.name == "return_to_title_cancel_button") then
              button.is_auto_clicked = true
            end
          else
            button.is_auto_clicked = false
          end
        end
      end
    end
    @poi.mode = :search
  end

  def render

    Window.draw(0, 0, @background_image) if @background_image

    if @illusts and not @illusts.empty? then
      @illusts.each do |illust|
        illust.draw
      end
    end

    if @sprite_fonts and not @sprite_fonts.empty? then
      @sprite_fonts.each do |sprite_font|
        sprite_font.draw
      end
    end

    @return_to_title_button.draw if @return_to_title_button

    Window.draw(0, 0, @cover_layer) if @cover_layer and @is_returnable
    @return_to_title_message_dialog.draw if @return_to_title_message_dialog and @is_returnable

    @poi.draw if @poi
  end

  def will_disappear
  end
end


Scene.main_loop SplashScene, $config.fps, $config.frame_step
