#! ruby -Ks
# -*- mode:ruby; coding:shift_jis -*-
$KCODE = "s"
require "jcode"

# q[g}bv̕\

require "dxruby"
require "win32ole"


module Heatmap

  BASE_ABSOLUTE_PATH = File.dirname(File.expand_path('.', __FILE__))
  IMAGE_MAGICK_DIR = BASE_ABSOLUTE_PATH + "/../ImageMagick"
  POINT = BASE_ABSOLUTE_PATH + "/../data/point.png"
  GRADIENT = BASE_ABSOLUTE_PATH + "/../data/gradient.png"

  def heatmap(datas, width=800, height=600, point_size=50, file="heatmap.png")

    base_image = Image.new(width, height, C_WHITE)

    _point_image = Image.load(POINT)
    point_image = RenderTarget.new(point_size, point_size).draw_scale(0, 0, _point_image, point_size / _point_image.width.to_f,
                                                                      point_size / _point_image.height.to_f, 0, 0).update.to_image
    _point_image.dispose

    radius = point_image.width * 0.5
    datas.each do |data|
      x = data[0].to_f
      y = data[1].to_f

      base_image.draw(x - radius, y - radius, point_image)
    end
    base_image.save(file)

    base_image.dispose
    point_image.dispose

    wsh = WIN32OLE.new("Wscript.Shell")
    wsh.Run("#{IMAGE_MAGICK_DIR}/convert -channel ALL -clut #{file} #{GRADIENT} #{file}", 0, true)
    wsh.Run("#{IMAGE_MAGICK_DIR}/convert #{file} -fuzz 30% -transparent black #{file}", 0, true)
  end

  def pointmap(datas, width=800, height=600, point_size=50, point_color=C_WHITE, frame_color=C_BLACK, frame_width=3,
               line_color=C_BLACK, file="heatmap.png")

    base_image = Image.new(width, height, C_DEFAULT)
    back_image = Image.new(width, height, [255, 196, 196, 196])

    point_image = Image.new(point_size, point_size, C_DEFAULT)
    point_image.circle_fill(point_size * 0.5, point_size * 0.5, point_size * 0.5, frame_color)
    point_image.circle_fill(point_size * 0.5, point_size * 0.5, point_size * 0.5 - frame_width, point_color)

    radius = point_image.width * 0.5
    datas.each_with_index do | data, index|

      if index < datas.size - 1 then
        lx1 = datas[index][0].to_i
        ly1 = datas[index][1].to_i
        lx2 = datas[index + 1][0].to_i
        ly2 = datas[index + 1][1].to_i
        base_image.line(lx1, ly1, lx2, ly2, line_color)
      end
      x = data[0].to_f
      y = data[1].to_f
      base_image.draw(x - radius, y - radius, point_image)
    end
    point_image.dispose

    back_image.draw(0, 0, base_image)
    back_image.save(file)

    return base_image
  end
end
