#! ruby -Ks
# -*- mode:ruby; coding:shift_jis -*-
$KCODE= "s"
require "jcode"

# Created by Toshiharu Tadano 2015-2019.
# This class needs require wav-file.rb.


class WavAnalyze

  attr_reader :waves, :max, :min, :num, :start, :end, :moving_average_waves, :threshold,
              :start_time, :end_time

  def initialize
    @waves = nil # ruby -Ks
    @max = nil # ől
    @min = nil # ŏl
    @num = nil # f[^
    
    @moving_average_waves # ړσf[^
    @start = nil # Jn_
    @end = nil # I_
    @start_time = nil
    @end_time = nil
  end

  # WAVt@C̓ǂݍ
  def load_wave(filename, skip)

    f = File.open(filename, "rb")
    format, chunks = WavFile::readAll(f)
    f.close
    data_chunk = nil

    chunks.each{|c|
      data_chunk = c if c.name == "data"
    }

    if data_chunk == nil
      puts "no data chunk"
      exit 1
    end

    bit = 's*' if format.bitPerSample == 16 # int16_t
    bit = 'c*' if format.bitPerSample == 8 # signed char
    wavs = data_chunk.data.unpack(bit) # 16bit or 8bitbinaryǂݏo

    out_waves = []

    # skip΂ď
    (wavs.size / skip).times do |i|
      out_waves[i] = wavs[i*skip]
    end
  
    @format = format
    @waves = out_waves
    @max = out_waves.max
    @min = out_waves.min
    @amplitude = @max - @min
    # @threshold = @amplitude/2*0.05 # 臒lݒ@ꉞU101 -- 傫ȊԈႢȂ̂ˁI
    @num = out_waves.size
  end


  # ړϏ
  def moving_average(range=100)

    outs = []
    total = 0

    @waves.size.times do |i|
      total -= @waves[i - range].abs if i > range
      total += @waves[i + range].abs if i + range < @waves.size
      outs.push((total / (range * 2).round))
    end

    @moving_average_waves = outs
    return outs
  end

  # 臒lo -- 蒼܂
  def detect_threshold(waves)

    waves_abs = waves.map{|foctor| foctor.abs}
    @threshold = waves_abs.max * 0.1 # 臒lݒ U101
  end
  
  # g`̗オo
  def detect_start_point(waves)

    waves.each_with_index do |e, index|

      # 臒l𒴂uCN
      if e.abs >= @threshold
        @start = index
        break
      end
    end

    self.calc_start_time(@start)
    return @start
  end
  
  def calc_start_time(start_point)

    @start_time = start_point.to_f / (@format.hz * @format.channel)
    @start_time = (@start_time * 1000).round / 1000.0   # _ȉ3Ŏľܓ
  end
  
  # g`̏Io
  def detect_end_point(waves)

    @num.times do |i|

      # 臒l𒴂uCN
      if waves[@num - 1 - i].abs >= @threshold
        @end = @num - 1 - i
        break
      end
    end

    self.calc_end_time(@end)
    return @end
  end
  
  def calc_end_time(end_point)

    @end_time = end_point.to_f / (@format.hz * @format.channel)
    @end_time = (@end_time * 1000).round / 1000.0  # _ȉ3Ŏľܓ
  end
  
  def time
    return @end_time - @start_time
  end
  
  # ͂
  def analyze(filename, skip=1)

    self.load_wave(filename, skip)
    moving_average_wavs = self.moving_average(100) # -- ړς̐xiقǃ^C~ÔꂪȂȂj

    self.detect_threshold(moving_average_wavs)  # 臒lݒ ړς̐U101
    self.detect_start_point(moving_average_wavs)
    self.detect_end_point(moving_average_wavs)
  end
end
