#define OFFSET 23
#define WEIGHT 60
#define BEEP_LEN 100
#define BEEP_FRQ1 523
#define BEEP_FRQ2 1047

// ピン設定
const int SwitchPin = 2;   // 外部&基板スイッチ
const int ModePin = 3;     // モード表示LED（白）
const int RelayPin = 6;    // リレー動作&LED（緑）
const int CounterPin = 9;  // カウンター表示LED（赤）
const int BeepPin = 11;    // スピーカー
const int VolPin = 0;      // 時間調整用ボリューム

int SwitchState = 1;
int SwitchState_Prev = 1;
int Mode = 0;
int Mode_Prev = -1;
bool LatchState = false;
int Vol_Value = 0;

unsigned long millis();
 
void setup()
{
  Serial.begin(9600);
  pinMode(ModePin, OUTPUT);
  pinMode(RelayPin, OUTPUT);
  pinMode(BeepPin, OUTPUT);
  pinMode(CounterPin, OUTPUT);
  pinMode(SwitchPin, INPUT_PULLUP); // Inputモードでプルアップ抵抗を有効

  // 起動チェッカー
  digitalWrite(RelayPin, HIGH);
  digitalWrite(BeepPin, HIGH);
  digitalWrite(ModePin, HIGH);
  digitalWrite(CounterPin, HIGH);
  delay(500);
  digitalWrite(RelayPin, LOW);
  digitalWrite(BeepPin, LOW);
  digitalWrite(ModePin, LOW);
  digitalWrite(CounterPin, LOW);
  delay(500);
}
 
void loop()
{
  // モード判定
  Vol_Value =  analogRead(VolPin);
  if (Vol_Value > OFFSET)
  {
    Mode = 1; // タイマーモード
    digitalWrite(ModePin, HIGH);
  }
  else
  {
    Mode = 0; // ラッチモード
    digitalWrite(ModePin, LOW);
  }

  // モード切り替え音・起動時鳴動
  if (Mode != Mode_Prev) 
  {
    tone(BeepPin, BEEP_FRQ2, 100);
  }
  Mode_Prev = Mode;

  SwitchState = digitalRead(SwitchPin); // 0:ON 1:OFF
  //delay(50);
  if (Mode == 0) Latch();
  if (Mode == 1) Timer();

Serial.print(SwitchState);
Serial.print(":");
Serial.print(LatchState);
Serial.print(":");
Serial.print(Vol_Value);
Serial.print(":");
Serial.println(Mode);
}

// タイマー動作
void Timer()
{
  // ラッチのリセット
  LatchState = false;
  digitalWrite(RelayPin, LOW);

  if (SwitchState - SwitchState_Prev == -1) // 立ち下がり検出 00001111
  {
    Vol_Value =  analogRead(VolPin);
    unsigned int time_value = (Vol_Value - OFFSET) * WEIGHT;
    unsigned long time_prev = millis();  // 時間を保持
    unsigned long time_past = millis() - time_prev;

    unsigned long counter = 0;
    while (time_past  < time_value)  // 現在時と保持した時間との差 
    {
      // リレーON
      if (counter == 0) tone(BeepPin, BEEP_FRQ1, BEEP_LEN);
      digitalWrite(RelayPin, HIGH);

      // 一定のVR回転でタイマー再設定として認識
      if (abs(Vol_Value - analogRead(VolPin)) > 30) break;
       
      // 1000ms毎の点滅
      if (time_past % 1000 > 500)
      {
        tone(BeepPin, BEEP_FRQ2, BEEP_LEN);
        digitalWrite(CounterPin, HIGH);
      }
      else
      {
        digitalWrite(CounterPin, LOW);
      }

      counter++;
      time_past = millis() - time_prev;

Serial.print(Vol_Value);
Serial.print(":");
Serial.print(time_value);
Serial.print(":");
Serial.println(time_past);
    }

    // ビープ音とリレーのOFF
    digitalWrite(CounterPin, LOW);
    digitalWrite(RelayPin, LOW);
  }
  SwitchState_Prev = SwitchState;  // 直前のスイッチ状態を保持
}

// ラッチ動作
void Latch()
{
  if (SwitchState - SwitchState_Prev == -1) // 立ち下がり検出 00001111
  {
    switch (LatchState)
    {
    case false:
      LatchState = true;
      tone(BeepPin, BEEP_FRQ1, BEEP_LEN);
      digitalWrite(RelayPin, HIGH);
      break;
    case true:
      LatchState = false;
      tone(BeepPin, BEEP_FRQ2, BEEP_LEN);
      digitalWrite(RelayPin, LOW);
      break;
    }
  }
  SwitchState_Prev = SwitchState;  // 直前のスイッチ状態を保持
}
